/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.businessprocess;

import org.eclipse.jubula.client.core.commands.ServerLogResponseCommand;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.events.IServerLogListener;
import org.eclipse.jubula.client.internal.AutAgentConnection;
import org.eclipse.jubula.client.internal.BaseConnection;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.communication.internal.ICommand;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.SendServerLogMessage;
import org.eclipse.jubula.communication.internal.message.ServerLogResponseMessage;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;

public final class ShowServerLogBP
implements DataEventDispatcher.IServerConnectionListener,
IServerLogListener {
    private static final int TIMEOUT = 3000;
    private static ShowServerLogBP instance = null;
    private boolean m_isConnectedToServer = false;
    private ServerLogResponseMessage m_response = null;

    private ShowServerLogBP() {
        DataEventDispatcher.getInstance().addAutAgentConnectionListener((DataEventDispatcher.IServerConnectionListener)this, true);
    }

    public static ShowServerLogBP getInstance() {
        if (instance == null) {
            instance = new ShowServerLogBP();
        }
        return instance;
    }

    public void handleServerConnStateChanged(DataEventDispatcher.ServerState state) {
        this.m_isConnectedToServer = state == DataEventDispatcher.ServerState.Connected;
    }

    public boolean isEnabled() {
        return this.m_isConnectedToServer;
    }

    public void processServerLog(ServerLogResponseMessage response) {
        this.m_response = response;
    }

    public ServerLogResponseMessage requestServerLog() {
        ServerLogResponseCommand request = new ServerLogResponseCommand((IServerLogListener)this);
        SendServerLogMessage message = new SendServerLogMessage();
        try {
            AutAgentConnection.getInstance().request((Message)message, (ICommand)request, 3000);
        }
        catch (BaseConnection.NotConnectedException notConnectedException) {
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_NO_SERVER_CONNECTION_INIT);
        }
        catch (CommunicationException communicationException) {
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_MESSAGE_REQUEST);
        }
        int waited = 0;
        while (this.m_response == null && waited <= 3000) {
            TimeUtil.delay((long)200L);
            waited += 200;
        }
        ServerLogResponseMessage responseToReturn = this.m_response;
        this.m_response = null;
        this.handleServerRequestErrors(responseToReturn);
        return responseToReturn;
    }

    private void handleServerRequestErrors(ServerLogResponseMessage response) {
        if (response != null) {
            int status = response.getStatus();
            if (status == 1) {
                ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_FILE_LOGGING_NOT_ENABLED, (Object[])new String[]{"AUT Agent"}, null);
            } else if (status == 2) {
                ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_FILE_NOT_FOUND);
            } else if (status == 3) {
                ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_IO_EXCEPTION);
            } else if (status == 4) {
                ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_CONFIG_ERROR);
            }
        } else {
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_MESSAGE_REQUEST);
        }
    }
}

