/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.pushstream;

import java.time.Duration;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.LongUnaryOperator;
import java.util.function.Supplier;
import java.util.function.ToLongBiFunction;
import java.util.stream.Collector;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.util.function.Function;
import org.osgi.util.function.Predicate;
import org.osgi.util.promise.Promise;
import org.osgi.util.pushstream.PushEvent;
import org.osgi.util.pushstream.PushEventConsumer;
import org.osgi.util.pushstream.PushEventSource;
import org.osgi.util.pushstream.PushStreamBuilder;

@ProviderType
public interface PushStream<T>
extends AutoCloseable {
    @Override
    public void close();

    public PushStream<T> onClose(Runnable var1);

    public PushStream<T> onError(Consumer<? super Throwable> var1);

    public PushStream<T> filter(Predicate<? super T> var1);

    public <R> PushStream<R> map(Function<? super T, ? extends R> var1);

    public <R> PushStream<R> asyncMap(int var1, int var2, Function<? super T, Promise<? extends R>> var3);

    public <R> PushStream<R> flatMap(Function<? super T, ? extends PushStream<? extends R>> var1);

    public PushStream<T> distinct();

    public PushStream<T> sorted();

    public PushStream<T> sorted(Comparator<? super T> var1);

    public PushStream<T> limit(long var1);

    public PushStream<T> limit(Duration var1);

    public PushStream<T> timeout(Duration var1);

    public PushStream<T> skip(long var1);

    public PushStream<T> fork(int var1, int var2, Executor var3);

    public PushStream<T> buffer();

    public <U extends BlockingQueue<PushEvent<? extends T>>> PushStreamBuilder<T, U> buildBuffer();

    public PushStream<T> merge(PushEventSource<? extends T> var1);

    public PushStream<T> merge(PushStream<? extends T> var1);

    public PushStream<T>[] split(Predicate<? super T> ... var1);

    public PushStream<T> sequential();

    public <R> PushStream<R> coalesce(Function<? super T, Optional<R>> var1);

    public <R> PushStream<R> coalesce(int var1, Function<Collection<T>, R> var2);

    public <R> PushStream<R> coalesce(IntSupplier var1, Function<Collection<T>, R> var2);

    public <R> PushStream<R> window(Duration var1, Function<Collection<T>, R> var2);

    public <R> PushStream<R> window(Duration var1, Executor var2, Function<Collection<T>, R> var3);

    public <R> PushStream<R> window(Supplier<Duration> var1, IntSupplier var2, BiFunction<Long, Collection<T>, R> var3);

    public <R> PushStream<R> window(Supplier<Duration> var1, IntSupplier var2, Executor var3, BiFunction<Long, Collection<T>, R> var4);

    public PushStream<T> adjustBackPressure(LongUnaryOperator var1);

    public PushStream<T> adjustBackPressure(ToLongBiFunction<T, Long> var1);

    public Promise<Void> forEach(Consumer<? super T> var1);

    public Promise<Object[]> toArray();

    public <A extends T> Promise<A[]> toArray(IntFunction<A[]> var1);

    public Promise<T> reduce(T var1, BinaryOperator<T> var2);

    public Promise<Optional<T>> reduce(BinaryOperator<T> var1);

    public <U> Promise<U> reduce(U var1, BiFunction<U, ? super T, U> var2, BinaryOperator<U> var3);

    public <R, A> Promise<R> collect(Collector<? super T, A, R> var1);

    public Promise<Optional<T>> min(Comparator<? super T> var1);

    public Promise<Optional<T>> max(Comparator<? super T> var1);

    public Promise<Long> count();

    public Promise<Boolean> anyMatch(Predicate<? super T> var1);

    public Promise<Boolean> allMatch(Predicate<? super T> var1);

    public Promise<Boolean> noneMatch(Predicate<? super T> var1);

    public Promise<Optional<T>> findFirst();

    public Promise<Optional<T>> findAny();

    public Promise<Long> forEachEvent(PushEventConsumer<? super T> var1);
}

