/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.logging.aeri.core;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Report</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.IReport#getAnonymousId <em>Anonymous Id</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.IReport#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.IReport#getEmail <em>Email</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.IReport#getComment <em>Comment</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.IReport#getEclipseBuildId <em>Eclipse Build Id</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.IReport#getEclipseProduct <em>Eclipse Product</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.IReport#getJavaRuntimeVersion <em>Java Runtime Version</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.IReport#getOsgiWs <em>Osgi Ws</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.IReport#getOsgiOs <em>Osgi Os</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.IReport#getOsgiOsVersion <em>Osgi Os Version</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.IReport#getOsgiArch <em>Osgi Arch</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.IReport#getPresentBundles <em>Present Bundles</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.IReport#getStatus <em>Status</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.IReport#getSeverity <em>Severity</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.IReport#getAuxiliaryInformation <em>Auxiliary Information</em>}</li>
 * </ul>
 *
 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getReport()
 * @model
 * @generated
 */
public interface IReport extends EObject {
	/**
	 * Returns the value of the '<em><b>Anonymous Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Anonymous Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Anonymous Id</em>' attribute.
	 * @see #setAnonymousId(String)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getReport_AnonymousId()
	 * @model
	 * @generated
	 */
	String getAnonymousId();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.IReport#getAnonymousId <em>Anonymous Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Anonymous Id</em>' attribute.
	 * @see #getAnonymousId()
	 * @generated
	 */
	void setAnonymousId(String value);

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getReport_Name()
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.IReport#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Email</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Email</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Email</em>' attribute.
	 * @see #setEmail(String)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getReport_Email()
	 * @model
	 * @generated
	 */
	String getEmail();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.IReport#getEmail <em>Email</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Email</em>' attribute.
	 * @see #getEmail()
	 * @generated
	 */
	void setEmail(String value);

	/**
	 * Returns the value of the '<em><b>Comment</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Comment</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Comment</em>' attribute.
	 * @see #setComment(String)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getReport_Comment()
	 * @model
	 * @generated
	 */
	String getComment();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.IReport#getComment <em>Comment</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Comment</em>' attribute.
	 * @see #getComment()
	 * @generated
	 */
	void setComment(String value);

	/**
	 * Returns the value of the '<em><b>Eclipse Build Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Eclipse Build Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Eclipse Build Id</em>' attribute.
	 * @see #setEclipseBuildId(String)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getReport_EclipseBuildId()
	 * @model
	 * @generated
	 */
	String getEclipseBuildId();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.IReport#getEclipseBuildId <em>Eclipse Build Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Eclipse Build Id</em>' attribute.
	 * @see #getEclipseBuildId()
	 * @generated
	 */
	void setEclipseBuildId(String value);

	/**
	 * Returns the value of the '<em><b>Eclipse Product</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Eclipse Product</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Eclipse Product</em>' attribute.
	 * @see #setEclipseProduct(String)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getReport_EclipseProduct()
	 * @model
	 * @generated
	 */
	String getEclipseProduct();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.IReport#getEclipseProduct <em>Eclipse Product</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Eclipse Product</em>' attribute.
	 * @see #getEclipseProduct()
	 * @generated
	 */
	void setEclipseProduct(String value);

	/**
	 * Returns the value of the '<em><b>Java Runtime Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Java Runtime Version</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Java Runtime Version</em>' attribute.
	 * @see #setJavaRuntimeVersion(String)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getReport_JavaRuntimeVersion()
	 * @model
	 * @generated
	 */
	String getJavaRuntimeVersion();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.IReport#getJavaRuntimeVersion <em>Java Runtime Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Java Runtime Version</em>' attribute.
	 * @see #getJavaRuntimeVersion()
	 * @generated
	 */
	void setJavaRuntimeVersion(String value);

	/**
	 * Returns the value of the '<em><b>Osgi Ws</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Osgi Ws</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Osgi Ws</em>' attribute.
	 * @see #setOsgiWs(String)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getReport_OsgiWs()
	 * @model
	 * @generated
	 */
	String getOsgiWs();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.IReport#getOsgiWs <em>Osgi Ws</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Osgi Ws</em>' attribute.
	 * @see #getOsgiWs()
	 * @generated
	 */
	void setOsgiWs(String value);

	/**
	 * Returns the value of the '<em><b>Osgi Os</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Osgi Os</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Osgi Os</em>' attribute.
	 * @see #setOsgiOs(String)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getReport_OsgiOs()
	 * @model
	 * @generated
	 */
	String getOsgiOs();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.IReport#getOsgiOs <em>Osgi Os</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Osgi Os</em>' attribute.
	 * @see #getOsgiOs()
	 * @generated
	 */
	void setOsgiOs(String value);

	/**
	 * Returns the value of the '<em><b>Osgi Os Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Osgi Os Version</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Osgi Os Version</em>' attribute.
	 * @see #setOsgiOsVersion(String)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getReport_OsgiOsVersion()
	 * @model
	 * @generated
	 */
	String getOsgiOsVersion();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.IReport#getOsgiOsVersion <em>Osgi Os Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Osgi Os Version</em>' attribute.
	 * @see #getOsgiOsVersion()
	 * @generated
	 */
	void setOsgiOsVersion(String value);

	/**
	 * Returns the value of the '<em><b>Osgi Arch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Osgi Arch</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Osgi Arch</em>' attribute.
	 * @see #setOsgiArch(String)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getReport_OsgiArch()
	 * @model
	 * @generated
	 */
	String getOsgiArch();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.IReport#getOsgiArch <em>Osgi Arch</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Osgi Arch</em>' attribute.
	 * @see #getOsgiArch()
	 * @generated
	 */
	void setOsgiArch(String value);

	/**
	 * Returns the value of the '<em><b>Present Bundles</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.epp.logging.aeri.core.IBundle}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Present Bundles</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Present Bundles</em>' containment reference list.
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getReport_PresentBundles()
	 * @model containment="true"
	 * @generated
	 */
	EList<IBundle> getPresentBundles();

	/**
	 * Returns the value of the '<em><b>Status</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Status</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Status</em>' containment reference.
	 * @see #setStatus(IStatus)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getReport_Status()
	 * @model containment="true"
	 * @generated
	 */
	IStatus getStatus();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.IReport#getStatus <em>Status</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Status</em>' containment reference.
	 * @see #getStatus()
	 * @generated
	 */
	void setStatus(IStatus value);

	/**
	 * Returns the value of the '<em><b>Severity</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.epp.logging.aeri.core.Severity}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Severity</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Severity</em>' attribute.
	 * @see org.eclipse.epp.logging.aeri.core.Severity
	 * @see #setSeverity(Severity)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getReport_Severity()
	 * @model required="true"
	 * @generated
	 */
	Severity getSeverity();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.IReport#getSeverity <em>Severity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Severity</em>' attribute.
	 * @see org.eclipse.epp.logging.aeri.core.Severity
	 * @see #getSeverity()
	 * @generated
	 */
	void setSeverity(Severity value);

	/**
	 * Returns the value of the '<em><b>Auxiliary Information</b></em>' map.
	 * The key is of type {@link java.lang.String},
	 * and the value is of type {@link java.lang.String},
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Auxiliary Information</em>' map isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Auxiliary Information</em>' map.
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getReport_AuxiliaryInformation()
	 * @model mapType="org.eclipse.epp.logging.aeri.core.StringToStringMap<org.eclipse.emf.ecore.EString, org.eclipse.emf.ecore.EString>"
	 * @generated
	 */
	EMap<String, String> getAuxiliaryInformation();

} // IReport
