/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.debug;

import java.math.BigInteger;
import java.util.HashMap;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICEventBreakpoint;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.ui.breakpoints.AbstractToggleBreakpointAdapter;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkbenchPart;

public class ToggleBreakpointAdapter
extends AbstractToggleBreakpointAdapter {
    protected ICLineBreakpoint findLineBreakpoint(String sourceHandle, IResource resource, int lineNumber) throws CoreException {
        return CDIDebugModel.lineBreakpointExists((String)sourceHandle, (IResource)resource, (int)lineNumber);
    }

    protected void createLineBreakpoint(boolean interactive, IWorkbenchPart part, String sourceHandle, IResource resource, int lineNumber) throws CoreException {
        if (interactive) {
            ICLineBreakpoint lineBp = CDIDebugModel.createBlankLineBreakpoint();
            HashMap attributes = new HashMap();
            CDIDebugModel.setLineBreakpointAttributes(attributes, (String)sourceHandle, (Integer)this.getBreakpointType(), (int)lineNumber, (boolean)true, (int)0, (String)"");
            this.openBreakpointPropertiesDialog((ICBreakpoint)lineBp, part, resource, attributes);
        } else {
            CDIDebugModel.createLineBreakpoint((String)sourceHandle, (IResource)resource, (int)this.getBreakpointType(), (int)lineNumber, (boolean)true, (int)0, (String)"", (boolean)true);
        }
    }

    protected ICFunctionBreakpoint findFunctionBreakpoint(String sourceHandle, IResource resource, String functionName) throws CoreException {
        return CDIDebugModel.functionBreakpointExists((String)sourceHandle, (IResource)resource, (String)functionName);
    }

    protected void createFunctionBreakpoint(boolean interactive, IWorkbenchPart part, String sourceHandle, IResource resource, String functionName, int charStart, int charEnd, int lineNumber) throws CoreException {
        if (interactive) {
            ICFunctionBreakpoint bp = CDIDebugModel.createBlankFunctionBreakpoint();
            HashMap attributes = new HashMap();
            CDIDebugModel.setFunctionBreakpointAttributes(attributes, (String)sourceHandle, (int)this.getBreakpointType(), (String)functionName, (int)charStart, (int)charEnd, (int)lineNumber, (boolean)true, (int)0, (String)"");
            this.openBreakpointPropertiesDialog((ICBreakpoint)bp, part, resource, attributes);
        } else {
            CDIDebugModel.createFunctionBreakpoint((String)sourceHandle, (IResource)resource, (int)this.getBreakpointType(), (String)functionName, (int)charStart, (int)charEnd, (int)lineNumber, (boolean)true, (int)0, (String)"", (boolean)true);
        }
    }

    protected ICWatchpoint findWatchpoint(String sourceHandle, IResource resource, String expression) throws CoreException {
        return CDIDebugModel.watchpointExists((String)sourceHandle, (IResource)resource, (String)expression);
    }

    protected void createWatchpoint(boolean interactive, IWorkbenchPart part, String sourceHandle, IResource resource, int charStart, int charEnd, int lineNumber, String expression, String memorySpace, String range) throws CoreException {
        ICWatchpoint bp = CDIDebugModel.createBlankWatchpoint();
        HashMap attributes = new HashMap();
        CDIDebugModel.setWatchPointAttributes(attributes, (String)sourceHandle, (IResource)resource, (boolean)true, (boolean)false, (String)expression, (String)memorySpace, (BigInteger)new BigInteger(range), (boolean)true, (int)0, (String)"");
        this.openBreakpointPropertiesDialog((ICBreakpoint)bp, part, resource, attributes);
    }

    protected void createEventBreakpoint(boolean interactive, IWorkbenchPart part, IResource resource, String type, String arg) throws CoreException {
        ICEventBreakpoint bp = CDIDebugModel.createBlankEventBreakpoint();
        HashMap attributes = new HashMap();
        CDIDebugModel.setEventBreakpointAttributes(attributes, (String)type, (String)arg);
        this.openBreakpointPropertiesDialog((ICBreakpoint)bp, part, resource, attributes);
    }

    protected int getBreakpointType() {
        return 0;
    }
}

