/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.ui.actions;

import java.util.ArrayList;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemProfile;
import org.eclipse.cdt.codan.internal.core.model.CodanProblem;
import org.eclipse.cdt.codan.internal.core.model.CodanProblemMarker;
import org.eclipse.cdt.codan.internal.ui.dialogs.CustomizeProblemDialog;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class OpenProblemPreferences
implements IObjectActionDelegate {
    private ISelection selection;
    private IWorkbenchPart targetPart;

    public void run(IAction action) {
        if (this.selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)this.selection;
            ArrayList<CodanProblem> list = new ArrayList<CodanProblem>();
            IResource resource = null;
            for (Object el : ss) {
                if (!(el instanceof IMarker)) continue;
                IMarker marker = (IMarker)el;
                String id = CodanProblemMarker.getProblemId((IMarker)marker);
                if (id == null) {
                    return;
                }
                resource = marker.getResource();
                IProblemProfile profile = CodanProblemMarker.getProfile((IResource)resource);
                CodanProblem problem = (CodanProblem)profile.findProblem(id);
                list.add(problem);
            }
            new CustomizeProblemDialog(this.targetPart.getSite().getShell(), list.toArray(new IProblem[list.size()]), resource).open();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }
}

