/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.util.gradle;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.internal.util.gradle.CompatEclipseProject;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.eclipse.EclipseProject;

public final class ModelUtils {
    private ModelUtils() {
    }

    public static EclipseProject createCompatibilityModel(EclipseProject model) {
        return new CompatEclipseProject(model);
    }

    static <T> DomainObjectSet<? extends T> asDomainObjectSet(Iterable<? extends T> result) {
        return ImmutableDomainObjectSet.of(result);
    }

    static <T> DomainObjectSet<? extends T> emptyDomainObjectSet() {
        return ImmutableDomainObjectSet.of(Collections.emptyList());
    }

    private static class ImmutableDomainObjectSet<T>
    extends AbstractSet<T>
    implements DomainObjectSet<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Set<T> elements = new LinkedHashSet<T>();

        public ImmutableDomainObjectSet(Iterable<? extends T> elements) {
            for (T element : elements) {
                this.elements.add(element);
            }
        }

        @Override
        public Iterator<T> iterator() {
            return this.elements.iterator();
        }

        @Override
        public int size() {
            return this.elements.size();
        }

        public T getAt(int index) throws IndexOutOfBoundsException {
            return this.getAll().get(index);
        }

        public List<T> getAll() {
            return new ArrayList<T>(this.elements);
        }

        public static <T> ImmutableDomainObjectSet<T> of(Iterable<? extends T> elements) {
            return new ImmutableDomainObjectSet<T>(elements);
        }
    }
}

