/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class MarkerUtils {
    public static List<EObject> getAllObjects(ResourceSet resourceSet, IMarker marker) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        result.add(MarkerUtils.getTargetObject(resourceSet, marker));
        result.addAll(MarkerUtils.getRelatedObjects(resourceSet, marker));
        return result;
    }

    public static List<EObject> getRelatedObjects(ResourceSet resourceSet, IMarker marker) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        String targetUri = marker.getAttribute("uri", null);
        String uriString = marker.getAttribute("relatedURIs", null);
        if (uriString != null) {
            String[] uris;
            String[] stringArray = uris = uriString.split(" ");
            int n = uris.length;
            int n2 = 0;
            while (n2 < n) {
                URI uri;
                EObject o;
                String s = stringArray[n2];
                if (!s.equals(targetUri) && !((o = resourceSet.getEObject(uri = URI.createURI((String)s), false)) instanceof EStructuralFeature)) {
                    result.add(o);
                }
                ++n2;
            }
        }
        return result;
    }

    public static EObject getTargetObject(ResourceSet resourceSet, IMarker marker) {
        URI uri;
        String uriString = marker.getAttribute("uri", null);
        URI uRI = uri = uriString == null ? null : URI.createURI((String)uriString);
        if (uri == null) {
            return null;
        }
        return resourceSet.getEObject(uri, false);
    }

    public static ContainerShape getContainerShape(IFeatureProvider fp, IMarker marker) {
        ResourceSet rs = fp.getDiagramTypeProvider().getDiagramBehavior().getEditingDomain().getResourceSet();
        for (EObject o : MarkerUtils.getAllObjects(rs, marker)) {
            PictogramElement[] pictogramElementArray = fp.getAllPictogramElementsForBusinessObject((Object)o);
            int n = pictogramElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                PictogramElement pe = pictogramElementArray[n2];
                if (pe instanceof ContainerShape) {
                    return (ContainerShape)pe;
                }
                ++n2;
            }
        }
        return null;
    }
}

