/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.runtime;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;

public class XMLConfigElement
implements IConfigurationElement {
    protected Object parent = null;
    protected String name = null;
    protected String value = null;
    protected boolean valid = true;
    protected Hashtable<String, String> attributes = new Hashtable();
    protected List<XMLConfigElement> children = new ArrayList<XMLConfigElement>();

    public XMLConfigElement(Object parent) {
        this(parent, "");
    }

    public XMLConfigElement(Object parent, String name) {
        this.parent = parent;
        if (parent instanceof XMLConfigElement) {
            ((XMLConfigElement)parent).children.add(this);
        }
        this.name = name;
    }

    public Object createExecutableExtension(String propertyName) throws CoreException {
        try {
            String className = this.attributes.get(propertyName);
            IProject project = this.getProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            String[] classPathEntries = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
            ArrayList<URL> urlList = new ArrayList<URL>();
            int i = 0;
            while (i < classPathEntries.length) {
                String entry = classPathEntries[i];
                Path path = new Path(entry);
                URL url = path.toFile().toURI().toURL();
                urlList.add(url);
                ++i;
            }
            ClassLoader parentClassLoader = javaProject.getClass().getClassLoader();
            URL[] urls = urlList.toArray(new URL[urlList.size()]);
            URLClassLoader classLoader = new URLClassLoader(urls, parentClassLoader);
            classLoader.getParent();
            Class<?> clazz = classLoader.loadClass(className);
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CoreException((IStatus)new Status(4, "org.eclipse.bpmn2.modeler.core", ex.getMessage()));
        }
    }

    private IProject getProject() {
        if (this.parent instanceof IProject) {
            return (IProject)this.parent;
        }
        if (this.parent instanceof XMLConfigElement) {
            return ((XMLConfigElement)this.parent).getProject();
        }
        return null;
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public String getAttribute(String name) throws InvalidRegistryObjectException {
        return this.attributes.get(name);
    }

    public String getAttribute(String attrName, String locale) throws InvalidRegistryObjectException {
        return this.getAttribute(attrName);
    }

    public String getAttributeAsIs(String name) throws InvalidRegistryObjectException {
        return this.getAttribute(name);
    }

    public String[] getAttributeNames() throws InvalidRegistryObjectException {
        return this.attributes.keySet().toArray(new String[this.attributes.keySet().size()]);
    }

    public IConfigurationElement[] getChildren() throws InvalidRegistryObjectException {
        return this.children.toArray(new XMLConfigElement[this.children.size()]);
    }

    public IConfigurationElement[] getChildren(String name) throws InvalidRegistryObjectException {
        ArrayList<XMLConfigElement> result = new ArrayList<XMLConfigElement>();
        for (XMLConfigElement e : this.children) {
            if (!name.equals(e.getName())) continue;
            result.add(e);
        }
        return result.toArray(new XMLConfigElement[result.size()]);
    }

    public IExtension getDeclaringExtension() throws InvalidRegistryObjectException {
        XMLConfigElement root = this;
        while (root.getParent() instanceof XMLConfigElement) {
            root = (XMLConfigElement)root.getParent();
        }
        return new XMLExtension(root);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() throws InvalidRegistryObjectException {
        return this.name;
    }

    public Object getParent() throws InvalidRegistryObjectException {
        return this.parent;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() throws InvalidRegistryObjectException {
        return this.value;
    }

    public String getValue(String locale) throws InvalidRegistryObjectException {
        return this.getValue();
    }

    public String getValueAsIs() throws InvalidRegistryObjectException {
        return this.getValue();
    }

    public String getNamespace() throws InvalidRegistryObjectException {
        return null;
    }

    public String getNamespaceIdentifier() throws InvalidRegistryObjectException {
        return null;
    }

    public IContributor getContributor() throws InvalidRegistryObjectException {
        return null;
    }

    public boolean isValid() {
        return this.valid;
    }

    public int getHandleId() {
        return 0;
    }

    public static class XMLExtension
    implements IExtension {
        XMLConfigElement root;

        public XMLExtension(XMLConfigElement root) {
            this.root = root;
        }

        public IConfigurationElement[] getConfigurationElements() throws InvalidRegistryObjectException {
            return this.root.getChildren();
        }

        public String getNamespace() throws InvalidRegistryObjectException {
            return null;
        }

        public String getNamespaceIdentifier() throws InvalidRegistryObjectException {
            return null;
        }

        public IContributor getContributor() throws InvalidRegistryObjectException {
            return null;
        }

        public String getExtensionPointUniqueIdentifier() throws InvalidRegistryObjectException {
            return null;
        }

        public String getLabel() throws InvalidRegistryObjectException {
            return null;
        }

        public String getLabel(String locale) throws InvalidRegistryObjectException {
            return null;
        }

        public String getSimpleIdentifier() throws InvalidRegistryObjectException {
            return null;
        }

        public String getUniqueIdentifier() throws InvalidRegistryObjectException {
            return null;
        }

        public boolean isValid() {
            return false;
        }

        public IPluginDescriptor getDeclaringPluginDescriptor() throws InvalidRegistryObjectException {
            return null;
        }
    }
}

