/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.Map;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.model.adapter.oda.IAmbiguousAttribute;
import org.eclipse.birt.report.model.adapter.oda.IAmbiguousParameterNode;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

class NameLabelProvider
extends ColumnLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    Map selectedStatusMap;

    public NameLabelProvider(Map isSelectedMap) {
        this.selectedStatusMap = isSelectedMap;
    }

    public Image getImage(Object element) {
        String symbolicName = "Checked";
        if (element instanceof IAmbiguousParameterNode) {
            if (this.selectedStatusMap.containsKey(element)) {
                Object obj = this.selectedStatusMap.get(element);
                if (obj != null && obj instanceof Boolean) {
                    symbolicName = ((Boolean)obj).booleanValue() ? "Checked" : "UnChecked";
                }
            } else {
                this.selectedStatusMap.put(element, Boolean.TRUE);
                symbolicName = "Checked";
            }
            return ReportPlatformUIImages.getImage((String)symbolicName);
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        String text = this.getStyledText(element).toString();
        return text;
    }

    public StyledString getStyledText(Object element) {
        String value = null;
        if (element instanceof IAmbiguousParameterNode) {
            value = ((IAmbiguousParameterNode)element).getOdaDataSetParameterHandle().getName();
        } else if (element instanceof IAmbiguousAttribute) {
            value = ((IAmbiguousAttribute)element).getAttributeName();
        }
        if (value == null) {
            value = "";
        }
        StyledString styledString = new StyledString();
        styledString.append(value);
        return styledString;
    }
}

