/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.node;

import java.util.Objects;

public class SourceSpan {
    private final int lineIndex;
    private final int columnIndex;
    private final int inputIndex;
    private final int length;

    public static SourceSpan of(int line, int col, int input, int length) {
        return new SourceSpan(line, col, input, length);
    }

    @Deprecated
    public static SourceSpan of(int lineIndex, int columnIndex, int length) {
        return SourceSpan.of(lineIndex, columnIndex, 0, length);
    }

    private SourceSpan(int lineIndex, int columnIndex, int inputIndex, int length) {
        if (lineIndex < 0) {
            throw new IllegalArgumentException("lineIndex " + lineIndex + " must be >= 0");
        }
        if (columnIndex < 0) {
            throw new IllegalArgumentException("columnIndex " + columnIndex + " must be >= 0");
        }
        if (inputIndex < 0) {
            throw new IllegalArgumentException("inputIndex " + inputIndex + " must be >= 0");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length " + length + " must be >= 0");
        }
        this.lineIndex = lineIndex;
        this.columnIndex = columnIndex;
        this.inputIndex = inputIndex;
        this.length = length;
    }

    public int getLineIndex() {
        return this.lineIndex;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public int getInputIndex() {
        return this.inputIndex;
    }

    public int getLength() {
        return this.length;
    }

    public SourceSpan subSpan(int beginIndex) {
        return this.subSpan(beginIndex, this.length);
    }

    public SourceSpan subSpan(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("beginIndex " + beginIndex + " + must be >= 0");
        }
        if (beginIndex > this.length) {
            throw new IndexOutOfBoundsException("beginIndex " + beginIndex + " must be <= length " + this.length);
        }
        if (endIndex < 0) {
            throw new IndexOutOfBoundsException("endIndex " + endIndex + " + must be >= 0");
        }
        if (endIndex > this.length) {
            throw new IndexOutOfBoundsException("endIndex " + endIndex + " must be <= length " + this.length);
        }
        if (beginIndex > endIndex) {
            throw new IndexOutOfBoundsException("beginIndex " + beginIndex + " must be <= endIndex " + endIndex);
        }
        if (beginIndex == 0 && endIndex == this.length) {
            return this;
        }
        return new SourceSpan(this.lineIndex, this.columnIndex + beginIndex, this.inputIndex + beginIndex, endIndex - beginIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceSpan that = (SourceSpan)o;
        return this.lineIndex == that.lineIndex && this.columnIndex == that.columnIndex && this.inputIndex == that.inputIndex && this.length == that.length;
    }

    public int hashCode() {
        return Objects.hash(this.lineIndex, this.columnIndex, this.inputIndex, this.length);
    }

    public String toString() {
        return "SourceSpan{line=" + this.lineIndex + ", column=" + this.columnIndex + ", input=" + this.inputIndex + ", length=" + this.length + "}";
    }
}

