/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.templates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableType;
import org.eclipse.jface.text.templates.TextTemplateMessages;

public class TemplateTranslator {
    private static final String IDENTIFIER = "(?:[\\p{javaJavaIdentifierPart}&&[^\\$]]++)";
    private static final String QUALIFIED_NAME = "(?:(?:[\\p{javaJavaIdentifierPart}&&[^\\$]]++)\\.)*+(?:[\\p{javaJavaIdentifierPart}&&[^\\$]]++)";
    private static final String ARGUMENT_TEXT = "'(?:(?:'')|(?:[^']))*+'";
    private static final String ARGUMENT = "(?:(?:(?:[\\p{javaJavaIdentifierPart}&&[^\\$]]++)\\.)*+(?:[\\p{javaJavaIdentifierPart}&&[^\\$]]++))|(?:'(?:(?:'')|(?:[^']))*+')";
    private static final String SPACES = "\\s*+";
    private static final Pattern PARAM_PATTERN = Pattern.compile("(?:(?:(?:[\\p{javaJavaIdentifierPart}&&[^\\$]]++)\\.)*+(?:[\\p{javaJavaIdentifierPart}&&[^\\$]]++))|(?:'(?:(?:'')|(?:[^']))*+')");
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("\\$\\$|\\$\\{\\s*+((?:[\\p{javaJavaIdentifierPart}&&[^\\$]]++)?+)\\s*+(?::\\s*+((?:(?:[\\p{javaJavaIdentifierPart}&&[^\\$]]++)\\.)*+(?:[\\p{javaJavaIdentifierPart}&&[^\\$]]++))\\s*+(?:\\(\\s*+((?:(?:(?:(?:(?:[\\p{javaJavaIdentifierPart}&&[^\\$]]++)\\.)*+(?:[\\p{javaJavaIdentifierPart}&&[^\\$]]++))|(?:'(?:(?:'')|(?:[^']))*+'))\\s*+,\\s*+)*+(?:(?:(?:(?:[\\p{javaJavaIdentifierPart}&&[^\\$]]++)\\.)*+(?:[\\p{javaJavaIdentifierPart}&&[^\\$]]++))|(?:'(?:(?:'')|(?:[^']))*+')))\\s*+\\))?\\s*+)?\\}|\\$");
    private String fErrorMessage;
    private TemplateVariableType fCurrentType;

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public TemplateBuffer translate(Template template) throws TemplateException {
        return this.parse(template.getPattern());
    }

    public TemplateBuffer translate(String string) throws TemplateException {
        return this.parse(string);
    }

    private TemplateBuffer parse(String string) throws TemplateException {
        this.fErrorMessage = null;
        StringBuilder buffer = new StringBuilder(string.length());
        Matcher matcher = ESCAPE_PATTERN.matcher(string);
        LinkedHashMap<String, VariableDescription> variables = new LinkedHashMap<String, VariableDescription>();
        int complete = 0;
        while (matcher.find()) {
            buffer.append(string.substring(complete, matcher.start()));
            switch (matcher.group()) {
                case "$": {
                    this.fail(TextTemplateMessages.getString("TemplateTranslator.error.incomplete.variable"));
                    break;
                }
                case "$$": {
                    buffer.append('$');
                    break;
                }
                default: {
                    String name = matcher.group(1);
                    String typeName = matcher.group(2);
                    String params = matcher.group(3);
                    TemplateVariableType type = this.createType(typeName, params);
                    this.updateOrCreateVariable(variables, name, type, buffer.length());
                    buffer.append(name);
                }
            }
            complete = matcher.end();
        }
        buffer.append(string.substring(complete));
        TemplateVariable[] vars = this.createVariables(variables);
        this.fixOffsetsAndBuffer(buffer, vars);
        return new TemplateBuffer(buffer.toString(), vars);
    }

    private void fixOffsetsAndBuffer(StringBuilder buffer, TemplateVariable[] vars) {
        TreeMap<Integer, TemplateVariable> varsByOffset = new TreeMap<Integer, TemplateVariable>();
        TemplateVariable[] templateVariableArray = vars;
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateVariable var = templateVariableArray[n2];
            int[] nArray = var.getOffsets();
            int n3 = nArray.length;
            int n4 = 0;
            while (n4 < n3) {
                int offset = nArray[n4];
                varsByOffset.put(offset, var);
                ++n4;
            }
            ++n2;
        }
        int totalOffsetDelta = 0;
        HashMap<TemplateVariable, Collection> fixedOffsets = new HashMap<TemplateVariable, Collection>(vars.length, 1.0f);
        for (Map.Entry entry : varsByOffset.entrySet()) {
            int initialOffset = (Integer)entry.getKey();
            TemplateVariable variable2 = (TemplateVariable)entry.getValue();
            int fixedOffset = initialOffset + totalOffsetDelta;
            fixedOffsets.computeIfAbsent(variable2, v -> new ArrayList(v.getOffsets().length)).add(fixedOffset);
            int currentOffsetDelta = variable2.getDefaultValue().length() - variable2.getName().length();
            buffer.replace(fixedOffset, fixedOffset + variable2.getName().length(), variable2.getDefaultValue());
            totalOffsetDelta += currentOffsetDelta;
        }
        fixedOffsets.forEach((variable, fixs) -> variable.setOffsets(fixs.stream().mapToInt(Integer::valueOf).toArray()));
    }

    private TemplateVariableType createType(String typeName, String paramString) {
        if (typeName == null) {
            return null;
        }
        if (paramString == null) {
            return new TemplateVariableType(typeName);
        }
        Matcher matcher = PARAM_PATTERN.matcher(paramString);
        ArrayList<String> params = new ArrayList<String>(5);
        while (matcher.find()) {
            String argument = matcher.group();
            if (argument.charAt(0) == '\'') {
                argument = argument.substring(1, argument.length() - 1).replace("''", "'");
            }
            params.add(argument);
        }
        return new TemplateVariableType(typeName, params.toArray(new String[params.size()]));
    }

    private void fail(String message) throws TemplateException {
        this.fErrorMessage = message;
        throw new TemplateException(message);
    }

    private VariableDescription updateOrCreateVariable(Map<String, VariableDescription> variables, String name, TemplateVariableType type, int offset) throws TemplateException {
        VariableDescription varDesc = variables.get(name);
        if (varDesc == null) {
            varDesc = new VariableDescription(name, type);
            variables.put(name, varDesc);
        } else {
            varDesc.mergeType(type);
        }
        varDesc.fOffsets.add(offset);
        return varDesc;
    }

    private TemplateVariable[] createVariables(Map<String, VariableDescription> variables) {
        TemplateVariable[] result = new TemplateVariable[variables.size()];
        int idx = 0;
        for (VariableDescription desc : variables.values()) {
            TemplateVariable var;
            TemplateVariableType type = desc.fType == null ? new TemplateVariableType(desc.fName) : desc.fType;
            int[] offsets = new int[desc.fOffsets.size()];
            int i = 0;
            for (Integer offset : desc.fOffsets) {
                offsets[i] = offset;
                ++i;
            }
            this.fCurrentType = type;
            result[idx] = var = this.createVariable(type.getName(), desc.fName, offsets);
            ++idx;
        }
        this.fCurrentType = null;
        return result;
    }

    @Deprecated
    protected TemplateVariable createVariable(String type, String name, int[] offsets) {
        return this.createVariable(this.fCurrentType, name, offsets);
    }

    protected TemplateVariable createVariable(TemplateVariableType type, String name, int[] offsets) {
        return new TemplateVariable(type, name, name, offsets);
    }

    private final class VariableDescription {
        final List<Integer> fOffsets = new ArrayList<Integer>(5);
        final String fName;
        TemplateVariableType fType;

        VariableDescription(String name, TemplateVariableType type) {
            this.fName = name;
            this.fType = type;
        }

        void mergeType(TemplateVariableType type) throws TemplateException {
            if (type == null) {
                return;
            }
            if (this.fType == null) {
                this.fType = type;
            }
            if (!type.equals(this.fType)) {
                TemplateTranslator.this.fail(TextTemplateMessages.getFormattedString("TemplateTranslator.error.incompatible.type", this.fName));
            }
        }
    }
}

