/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.commitgraph.ChangedPathFilter;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.StringUtils;

public class ChangedPathTreeFilter
extends TreeFilter {
    private TreeFilter pathFilter;
    private List<String> paths;
    private List<byte[]> rawPaths;

    public static ChangedPathTreeFilter create(String ... paths) {
        return new ChangedPathTreeFilter(paths);
    }

    private ChangedPathTreeFilter(String ... paths) {
        List filtered = Arrays.stream(paths).map(s -> StringUtils.trim(s, '/')).collect(Collectors.toList());
        if (filtered.size() == 0) {
            throw new IllegalArgumentException(JGitText.get().atLeastOnePathIsRequired);
        }
        if (filtered.stream().anyMatch(s -> s.isEmpty() || s.isBlank())) {
            throw new IllegalArgumentException(JGitText.get().emptyPathNotPermitted);
        }
        this.paths = filtered;
        this.rawPaths = this.paths.stream().map(Constants::encode).collect(Collectors.toList());
        this.pathFilter = filtered.size() == 1 ? PathFilter.create(paths[0]) : OrTreeFilter.create(Arrays.stream(paths).map(PathFilter::create).collect(Collectors.toList()));
    }

    @Override
    public boolean shouldTreeWalk(RevCommit c, RevWalk rw, TreeFilter.MutableBoolean cpfUsed) {
        ChangedPathFilter cpf = c.getChangedPathFilter(rw);
        if (cpf == null) {
            return true;
        }
        if (cpfUsed != null) {
            cpfUsed.orValue(true);
        }
        return this.rawPaths.stream().anyMatch(cpf::maybeContains);
    }

    @Override
    public boolean include(TreeWalk walker) throws IOException {
        return this.pathFilter.include(walker) && ANY_DIFF.include(walker);
    }

    @Override
    public boolean shouldBeRecursive() {
        return this.pathFilter.shouldBeRecursive() || ANY_DIFF.shouldBeRecursive();
    }

    @Override
    public ChangedPathTreeFilter clone() {
        return this;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    @Override
    public String toString() {
        return "(CHANGED_PATH(" + this.pathFilter.toString() + ") AND " + ANY_DIFF.toString() + ")";
    }
}

