/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring.rename;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceDescriptor;
import org.eclipse.ltk.internal.core.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.resource.ResourceModifications;
import org.eclipse.ltk.internal.core.refactoring.resource.ResourceProcessors;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.ui.refactoring.delete.Resources;
import org.eclipse.rcptt.ui.refactoring.rename.RenameContainerChange;
import org.eclipse.rcptt.ui.refactoring.rename.RenameNamedElementArguments;
import org.eclipse.rcptt.ui.refactoring.rename.RenameNamedElementChange;
import org.eclipse.rcptt.util.resources.ResourcesUtil;

public class Q7RenameProcessor
extends RenameProcessor {
    private final IResource fResource;
    private String fNewResourceName;
    private boolean fUpdateReferences;
    private RenameNamedElementArguments fRenameArguments;
    private IQ7NamedElement fElement;
    private String newElementName;

    public Q7RenameProcessor(IResource resource) {
        if (resource == null || !resource.exists()) {
            throw new IllegalArgumentException("resource must not be null and must exist");
        }
        this.fResource = resource;
        this.fRenameArguments = null;
        this.fUpdateReferences = true;
        this.setNewResourceName(resource.getName());
        if (resource instanceof IFile) {
            this.fElement = (IQ7NamedElement)RcpttCore.create((IResource)((IFile)resource));
        }
    }

    public String getNewElementName() {
        return this.newElementName;
    }

    public void setNewElementName(String newElementName) {
        this.newElementName = newElementName;
    }

    public IQ7NamedElement getNamedElement() {
        return this.fElement;
    }

    public IResource getResource() {
        return this.fResource;
    }

    public String getNewResourceName() {
        return this.fNewResourceName;
    }

    public void setNewResourceName(String newName) {
        Assert.isNotNull((Object)newName);
        this.fNewResourceName = newName;
    }

    public boolean isUpdateReferences() {
        return this.fUpdateReferences;
    }

    public void setUpdateReferences(boolean updateReferences) {
        this.fUpdateReferences = updateReferences;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        return RefactoringStatus.create((IStatus)Resources.checkInSync(this.fResource));
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        pm.beginTask("", 1);
        try {
            this.fRenameArguments = new RenameNamedElementArguments(this.getNewElementName(), this.getNewResourceName(), this.isUpdateReferences());
            ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
            IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
            ResourceModifications.buildMoveDelta((IResourceChangeDescriptionFactory)deltaFactory, (IResource)this.fResource, (RenameArguments)this.fRenameArguments);
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus validateNewElementName(String scenarioName, String newName) {
        Assert.isNotNull((Object)newName, (String)"new name");
        IContainer c = this.fResource.getParent();
        if (c == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameResourceProcessor_error_no_parent);
        }
        try {
            if (ResourcesUtil.getCaseInsensitiveChild((IContainer)c, (String)newName) != null) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameResourceProcessor_error_resource_already_exists);
            }
        }
        catch (CoreException e) {
            return RefactoringStatus.create((IStatus)e.getStatus());
        }
        if (scenarioName.trim().length() == 0) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameResourceProcessor_error_invalid_name);
        }
        if (!c.getFullPath().isValidSegment(newName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameResourceProcessor_error_invalid_name);
        }
        RefactoringStatus result = RefactoringStatus.create((IStatus)c.getWorkspace().validateName(newName, this.fResource.getType()));
        if (!result.hasFatalError()) {
            result.merge(RefactoringStatus.create((IStatus)c.getWorkspace().validatePath(this.createNewPath(newName), this.fResource.getType())));
        }
        return result;
    }

    protected RenameResourceDescriptor createDescriptor() {
        IResource resource = this.getResource();
        RenameResourceDescriptor descriptor = new RenameResourceDescriptor();
        descriptor.setProject(resource instanceof IProject ? null : resource.getProject().getName());
        descriptor.setDescription(Messages.format((String)RefactoringCoreMessages.RenameResourceProcessor_description, (Object)BasicElementLabels.getResourceName((IResource)resource)));
        descriptor.setComment(Messages.format((String)RefactoringCoreMessages.RenameResourceProcessor_comment, (Object[])new String[]{BasicElementLabels.getPathLabel((IPath)resource.getFullPath(), (boolean)false), BasicElementLabels.getResourceName((String)this.getNewResourceName())}));
        descriptor.setFlags(7);
        descriptor.setResourcePath(resource.getFullPath());
        descriptor.setNewName(this.getNewResourceName());
        descriptor.setUpdateReferences(this.isUpdateReferences());
        return descriptor;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        try {
            if (this.getNamedElement() != null) {
                RenameNamedElementChange change = new RenameNamedElementChange(this.fResource.getFullPath(), this.getNewResourceName(), this.getNewElementName());
                change.setDescriptor((ChangeDescriptor)new RefactoringChangeDescriptor((RefactoringDescriptor)this.createDescriptor()));
                RenameNamedElementChange renameNamedElementChange = change;
                return renameNamedElementChange;
            }
            if (this.getResource() instanceof IContainer) {
                RenameContainerChange change = new RenameContainerChange(this.fResource.getFullPath(), this.getNewResourceName());
                change.setDescriptor((ChangeDescriptor)new RefactoringChangeDescriptor((RefactoringDescriptor)this.createDescriptor()));
                RenameContainerChange renameContainerChange = change;
                return renameContainerChange;
            }
            RenameResourceChange change = new RenameResourceChange(this.fResource.getFullPath(), this.getNewResourceName());
            change.setDescriptor((ChangeDescriptor)new RefactoringChangeDescriptor((RefactoringDescriptor)this.createDescriptor()));
            RenameResourceChange renameResourceChange = change;
            return renameResourceChange;
        }
        finally {
            pm.done();
        }
    }

    private String createNewPath(String newName) {
        return this.fResource.getFullPath().removeLastSegments(1).append(newName).toString();
    }

    public Object[] getElements() {
        return new Object[]{this.fResource};
    }

    public String getIdentifier() {
        return "org.eclipse.ltk.core.refactoring.renameResourceProcessor";
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameResourceProcessor_processor_name;
    }

    public boolean isApplicable() {
        if (this.fResource == null) {
            return false;
        }
        if (!this.fResource.exists()) {
            return false;
        }
        return this.fResource.isAccessible();
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        String[] affectedNatures = ResourceProcessors.computeAffectedNatures((IResource)this.fResource);
        return ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)this.fResource, (RenameArguments)this.fRenameArguments, null, (String[])affectedNatures, (SharableParticipants)shared);
    }
}

