/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.ui.refactoring.resource;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.IRenameResourceProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.internal.core.refactoring.resource.RenameResourceProcessor;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RenameResourceWizard
extends RefactoringWizard {
    public RenameResourceWizard(IResource resource) {
        super((Refactoring)new RenameRefactoring((RenameProcessor)new RenameResourceProcessor(resource)), 4);
        this.setDefaultPageTitle(RefactoringUIMessages.RenameResourceWizard_page_title);
        this.setWindowTitle(RefactoringUIMessages.RenameResourceWizard_window_title);
    }

    public RenameResourceWizard(IResource resource, String newName) {
        this(resource);
        RenameResourceProcessor fRenameResourceProcessor = (RenameResourceProcessor)((RenameRefactoring)super.getRefactoring()).getProcessor();
        fRenameResourceProcessor.setNewResourceName(newName);
    }

    @Override
    protected void addUserInputPages() {
        this.addPage((IWizardPage)new RenameResourceRefactoringConfigurationPage(this.getProcessor()));
    }

    protected IRenameResourceProcessor getProcessor() {
        return (IRenameResourceProcessor)this.getRefactoring().getAdapter(RenameResourceProcessor.class);
    }

    public static class RenameResourceRefactoringConfigurationPage
    extends UserInputWizardPage {
        private final IRenameResourceProcessor fRefactoringProcessor;
        private Text fNameField;

        public RenameResourceRefactoringConfigurationPage(IRenameResourceProcessor processor) {
            super("RenameResourceRefactoringInputPage");
            this.fRefactoringProcessor = processor;
        }

        public RenameResourceRefactoringConfigurationPage(String name, IRenameResourceProcessor processor) {
            super(name);
            this.fRefactoringProcessor = processor;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setFont(parent.getFont());
            Label label = new Label(composite, 0);
            label.setText(RefactoringUIMessages.RenameResourceWizard_name_field_label);
            label.setLayoutData((Object)new GridData());
            this.fNameField = new Text(composite, 2048);
            String resourceName = this.fRefactoringProcessor.getNewResourceName();
            this.fNameField.setText(resourceName);
            this.fNameField.setFont(composite.getFont());
            this.fNameField.setLayoutData((Object)new GridData(4, 1, true, false));
            this.fNameField.addModifyListener(e -> this.validatePage());
            int lastIndexOfDot = resourceName.lastIndexOf(46);
            if (this.fRefactoringProcessor.getResource().getType() == 1 && lastIndexOfDot > 0) {
                this.fNameField.setSelection(0, lastIndexOfDot);
            } else {
                this.fNameField.selectAll();
            }
            this.setPageComplete(false);
            this.setControl((Control)composite);
        }

        @Override
        public void setVisible(boolean visible) {
            if (visible) {
                this.fNameField.setFocus();
            }
            super.setVisible(visible);
        }

        protected final void validatePage() {
            String text = this.fNameField.getText();
            RefactoringStatus status = this.fRefactoringProcessor.validateNewElementName(text);
            this.setPageComplete(status);
        }

        @Override
        protected boolean performFinish() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.performFinish();
        }

        @Override
        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.getNextPage();
        }

        protected void storeSettings() {
        }

        protected void initializeRefactoring() {
            this.fRefactoringProcessor.setNewResourceName(this.fNameField.getText());
        }

        protected IRenameResourceProcessor getProcessor() {
            return this.fRefactoringProcessor;
        }
    }
}

