/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.protocol;

import org.eclipse.rcptt.tesla.core.protocol.Click;
import org.eclipse.rcptt.tesla.core.protocol.ControlUIElement;
import org.eclipse.rcptt.tesla.core.protocol.CopyTextSelection;
import org.eclipse.rcptt.tesla.core.protocol.CutTextSelection;
import org.eclipse.rcptt.tesla.core.protocol.GetTextLine;
import org.eclipse.rcptt.tesla.core.protocol.GetTextLineLength;
import org.eclipse.rcptt.tesla.core.protocol.GetTextLineOffset;
import org.eclipse.rcptt.tesla.core.protocol.GetTextRange;
import org.eclipse.rcptt.tesla.core.protocol.GetTextResponse;
import org.eclipse.rcptt.tesla.core.protocol.GetTextSelection;
import org.eclipse.rcptt.tesla.core.protocol.GoToTextLine;
import org.eclipse.rcptt.tesla.core.protocol.HoverAtText;
import org.eclipse.rcptt.tesla.core.protocol.HoverAtTextOffset;
import org.eclipse.rcptt.tesla.core.protocol.IntResponse;
import org.eclipse.rcptt.tesla.core.protocol.OpenDeclaration;
import org.eclipse.rcptt.tesla.core.protocol.PasteTextSelection;
import org.eclipse.rcptt.tesla.core.protocol.ReplaceTextSelection;
import org.eclipse.rcptt.tesla.core.protocol.SelectTextLine;
import org.eclipse.rcptt.tesla.core.protocol.SetCursorOffset;
import org.eclipse.rcptt.tesla.core.protocol.SetSelection;
import org.eclipse.rcptt.tesla.core.protocol.SetText;
import org.eclipse.rcptt.tesla.core.protocol.SetTextOffset;
import org.eclipse.rcptt.tesla.core.protocol.SetTextSelection;
import org.eclipse.rcptt.tesla.core.protocol.SetTextSelection2;
import org.eclipse.rcptt.tesla.core.protocol.ShowContentAssist;
import org.eclipse.rcptt.tesla.core.protocol.ShowSelection;
import org.eclipse.rcptt.tesla.core.protocol.TextSelectionResponse;
import org.eclipse.rcptt.tesla.core.protocol.UIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.core.protocol.raw.ResponseStatus;
import org.eclipse.rcptt.tesla.core.utils.Cryptography;

public class TextUIElement
extends ControlUIElement {
    public TextUIElement(Element e, UIPlayer player) {
        super(e, player);
    }

    public void setText(String text) {
        SetText cmd = this.factory.createSetText();
        cmd.setElement(this.getElement());
        cmd.setValue(text);
        this.player.safeExecuteCommand(cmd);
    }

    public void setText(String text, boolean select, boolean hide) {
        SetText cmd = this.factory.createSetText();
        cmd.setElement(this.getElement());
        cmd.setValue(hide ? Cryptography.INSTANCE.encrypt(text) : text);
        cmd.setSelect(select);
        cmd.setHidden(hide);
        this.player.safeExecuteCommand(cmd);
    }

    public void select(String text) {
        SetSelection cmd = this.factory.createSetSelection();
        cmd.setElement(this.getElement());
        cmd.setPattern(text);
        this.player.safeExecuteCommand(cmd);
    }

    public void setSelection(int startLine, int startOffset, int endLine, int endOffset) {
        SetTextSelection cmd = this.factory.createSetTextSelection();
        cmd.setOffset(startOffset);
        cmd.setStartLine(startLine);
        cmd.setEndline(endLine);
        cmd.setEndoffset(endOffset);
        cmd.setElement(this.getElement());
        this.player.safeExecuteCommand(cmd);
    }

    public void setSelection2(int startLine, int startOffset, int endLine, int endOffset) {
        SetTextSelection2 cmd = this.factory.createSetTextSelection2();
        cmd.setStartOffset(startOffset);
        cmd.setStartLine(startLine);
        cmd.setEndLine(endLine);
        cmd.setEndOffset(endOffset);
        cmd.setElement(this.getElement());
        this.player.safeExecuteCommand(cmd);
    }

    public void setSelection(int offset, int length) {
        SetTextSelection cmd = this.factory.createSetTextSelection();
        cmd.setOffset(offset);
        cmd.setLength(length);
        cmd.setElement(this.getElement());
        this.player.safeExecuteCommand(cmd);
    }

    public void setTextOffset(int line, int offset) {
        SetTextOffset cmd = this.factory.createSetTextOffset();
        cmd.setOffset(offset);
        cmd.setLine(line);
        cmd.setElement(this.getElement());
        this.player.safeExecuteCommand(cmd);
    }

    public void setTextCursor(int line, int offset) {
        SetCursorOffset cmd = this.factory.createSetCursorOffset();
        cmd.setLine(line);
        cmd.setOffset(offset);
        cmd.setElement(this.getElement());
        this.player.safeExecuteCommand(cmd);
    }

    public void showSelection() {
        ShowSelection cmd = this.factory.createShowSelection();
        cmd.setElement(this.getElement());
        this.player.safeExecuteCommand(cmd);
    }

    public void gotoLine(int line) {
        GoToTextLine cmd = this.factory.createGoToTextLine();
        cmd.setLine(line);
        cmd.setElement(this.getElement());
        this.player.safeExecuteCommand(cmd);
    }

    public TextSelection getSelection() {
        GetTextSelection cmd = this.factory.createGetTextSelection();
        cmd.setElement(this.getElement());
        TextSelectionResponse response = (TextSelectionResponse)this.player.safeExecuteCommand(cmd);
        this.player.clearFailures();
        if (response == null) {
            return null;
        }
        if (!response.getStatus().equals((Object)ResponseStatus.OK)) {
            throw new RuntimeException("Failed to execute getSelection");
        }
        TextSelection selection = new TextSelection();
        selection.startOffset = response.getX();
        selection.endOffset = response.getY();
        selection.text = response.getText();
        return selection;
    }

    public int getLineOffset(int line) {
        GetTextLineOffset cmd = this.factory.createGetTextLineOffset();
        cmd.setElement(this.getElement());
        cmd.setLine(line);
        IntResponse response = (IntResponse)this.player.safeExecuteCommand(cmd);
        this.player.clearFailures();
        if (response == null) {
            return -1;
        }
        if (!response.getStatus().equals((Object)ResponseStatus.OK)) {
            throw new RuntimeException("Failed to execute getLineOffset");
        }
        return response.getResult();
    }

    public int getLineLength(int line) {
        GetTextLineLength cmd = this.factory.createGetTextLineLength();
        cmd.setElement(this.getElement());
        cmd.setLine(line);
        IntResponse response = (IntResponse)this.player.safeExecuteCommand(cmd);
        this.player.clearFailures();
        if (response == null) {
            return -1;
        }
        if (!response.getStatus().equals((Object)ResponseStatus.OK)) {
            throw new RuntimeException("Failed to execute getTextLineLength");
        }
        return response.getResult();
    }

    public void selectLine(int line) {
        SelectTextLine cmd = this.factory.createSelectTextLine();
        cmd.setElement(this.getElement());
        cmd.setLine(line);
        Response response = this.player.safeExecuteCommand(cmd);
        this.player.clearFailures();
        if (response == null) {
            return;
        }
        if (!response.getStatus().equals((Object)ResponseStatus.OK)) {
            throw new RuntimeException("Failed to execute selectLine");
        }
    }

    public String getLine(int line) {
        GetTextLine cmd = this.factory.createGetTextLine();
        cmd.setElement(this.getElement());
        cmd.setLine(line);
        GetTextResponse response = (GetTextResponse)this.player.safeExecuteCommand(cmd);
        this.player.clearFailures();
        if (response == null) {
            return null;
        }
        if (!response.getStatus().equals((Object)ResponseStatus.OK)) {
            throw new RuntimeException("Failed to execute getTextLine");
        }
        return response.getText();
    }

    public String getText(int startOffset, int endOffset) {
        GetTextRange cmd = this.factory.createGetTextRange();
        cmd.setElement(this.getElement());
        cmd.setStartOffset(startOffset);
        cmd.setEndOffset(endOffset);
        GetTextResponse response = (GetTextResponse)this.player.safeExecuteCommand(cmd);
        this.player.clearFailures();
        if (response == null) {
            return null;
        }
        if (!response.getStatus().equals((Object)ResponseStatus.OK)) {
            throw new RuntimeException("Failed to execute getTextRange");
        }
        return response.getText();
    }

    public void copy() {
        CopyTextSelection cmd = this.factory.createCopyTextSelection();
        cmd.setElement(this.getElement());
        Response response = this.player.safeExecuteCommand(cmd);
        this.player.clearFailures();
        if (response == null) {
            return;
        }
        if (!response.getStatus().equals((Object)ResponseStatus.OK)) {
            throw new RuntimeException("Failed to execute copy");
        }
    }

    public void cut() {
        CutTextSelection cmd = this.factory.createCutTextSelection();
        cmd.setElement(this.getElement());
        Response response = this.player.safeExecuteCommand(cmd);
        this.player.clearFailures();
        if (response == null) {
            return;
        }
        if (!response.getStatus().equals((Object)ResponseStatus.OK)) {
            throw new RuntimeException("Failed to execute cut");
        }
    }

    public void paste() {
        PasteTextSelection cmd = this.factory.createPasteTextSelection();
        cmd.setElement(this.getElement());
        Response response = this.player.safeExecuteCommand(cmd);
        if (response == null) {
            return;
        }
        if (!response.getStatus().equals((Object)ResponseStatus.OK)) {
            throw new RuntimeException("Failed to execute paste");
        }
    }

    public void replaceSelection(String text) {
        ReplaceTextSelection cmd = this.factory.createReplaceTextSelection();
        cmd.setElement(this.getElement());
        cmd.setText(text);
        Response response = this.player.safeExecuteCommand(cmd);
        this.player.clearFailures();
        if (response == null) {
            return;
        }
        if (!response.getStatus().equals((Object)ResponseStatus.OK)) {
            throw new RuntimeException("Failed to execute replace selection");
        }
    }

    public void defaultClick() {
        Click click = this.factory.createClick();
        click.setElement(this.getElement());
        click.setDefault(true);
        Response response = this.player.safeExecuteCommand(click);
        if (response == null) {
            return;
        }
    }

    @Override
    public void press(int code, int mask) {
        this.press(code, mask, (char)(code & 0xFF));
    }

    public void press(int code) {
        this.press(code, 0, (char)(code & 0xFF));
    }

    public void showContentAssist() {
        ShowContentAssist cmd = this.factory.createShowContentAssist();
        cmd.setElement(this.getElement());
        Response response = this.player.safeExecuteCommand(cmd);
        if (response == null) {
            return;
        }
        if (!response.getStatus().equals((Object)ResponseStatus.OK)) {
            throw new RuntimeException("Failed to execute show content assist");
        }
    }

    public void hoverAtOffset(int offset, int line) {
        HoverAtTextOffset hover = this.factory.createHoverAtTextOffset();
        hover.setElement(this.getElement());
        hover.setOffset(offset);
        hover.setLine(line);
        Response response = this.player.safeExecuteCommand(hover);
        if (response == null) {
            return;
        }
    }

    public void hoverAtText(int line, int offset, int stateMask) {
        HoverAtText hover = this.factory.createHoverAtText();
        hover.setElement(this.getElement());
        hover.setLine(line);
        hover.setOffset(offset);
        hover.setStateMask(stateMask);
        Response response = this.player.safeExecuteCommand(hover);
        if (response == null) {
            return;
        }
    }

    public void openDeclaration() {
        OpenDeclaration openDeclaration = this.factory.createOpenDeclaration();
        openDeclaration.setElement(this.getElement());
        Response response = this.player.safeExecuteCommand(openDeclaration);
        if (response == null) {
            return;
        }
    }

    public static class TextSelection {
        public int startOffset = 0;
        public int endOffset = 0;
        public String text = "";
    }
}

