/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.model.search;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.search.IIndexRequestor;
import org.eclipse.rcptt.core.model.search.ISearchPattern;
import org.eclipse.rcptt.core.model.search.SearchPattern;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.model.index.Index;
import org.eclipse.rcptt.internal.core.model.index.QueryResult;

public class AllTagQueryPattern
implements ISearchPattern {
    @Override
    public void findIndexMatches(Index index, IProgressMonitor monitor, IIndexRequestor requestor) {
        IPath path = index.getPath();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        List<QueryResult> list = index.query(new String[]{"tags"}, new SearchPattern.IKeyQuery(){

            @Override
            public boolean accept(String key, String value) {
                return true;
            }
        }, monitor);
        for (QueryResult queryResult : list) {
            Path fullPath = new Path(queryResult.path);
            IResource res = root.findMember(path.append((IPath)fullPath));
            if (!res.exists()) continue;
            IQ7Element q7Element = RcpttCore.create(res);
            requestor.acceptMatch(q7Element, queryResult.key, queryResult.value);
        }
    }
}

