/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.perf.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rcptt.ecl.perf.PerfCounter;
import org.eclipse.rcptt.ecl.perf.PerfFactory;
import org.eclipse.rcptt.ecl.perf.internal.EclPerfPlugin;

public class PerfService {
    private Map<String, Long> times = new HashMap<String, Long>();

    public synchronized void startTimeMeasure(String label) {
        if (this.times.containsKey(label)) {
            EclPerfPlugin.logWarn(String.format("Request to start time measure for %s which is already running", label));
        }
        this.times.put(label, System.currentTimeMillis());
    }

    public synchronized PerfCounter stopTimeMeasure(String label) {
        long endTime = System.currentTimeMillis();
        PerfCounter result = PerfFactory.eINSTANCE.createPerfCounter();
        result.setName(label);
        if (!this.times.containsKey(label)) {
            EclPerfPlugin.logWarn(String.format("Request to stop time measure for %s which has not been started", label));
            result.setDuration(0);
            return result;
        }
        result.setDuration((int)(endTime - this.times.get(label)));
        this.times.remove(label);
        return result;
    }
}

