/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ecl.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rcptt.reporting.core.ReportManager;
import org.eclipse.rcptt.sherlock.core.reporting.ReportBuilder;
import org.eclipse.rcptt.tesla.core.Q7WaitUtils;
import org.eclipse.rcptt.tesla.core.TeslaLimits;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.ecl.impl.TeslaBridge;
import org.eclipse.rcptt.tesla.ecl.impl.Utils;
import org.eclipse.rcptt.tesla.internal.core.queue.TeslaQClient;
import org.eclipse.rcptt.tesla.internal.ui.player.ReportScreenshotProvider;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.UIJobCollector;
import org.eclipse.rcptt.tesla.swt.events.ITeslaEventListener;
import org.eclipse.rcptt.tesla.swt.events.TeslaEventManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public abstract class UIRunnable<T> {
    private static final boolean DEBUG_PROCEED = "true".equals(Platform.getDebugOption((String)"org.eclipse.rcptt.tesla.ecl.impl/debug/proceed"));

    public static <T> T exec(UIRunnable<T> runnable) throws CoreException {
        AtomicBoolean cancelled = new AtomicBoolean(false);
        return UIRunnable.exec(runnable, UIRunnable.getTimeout(), cancelled::get);
    }

    public static <T> T exec(final UIRunnable<T> runnable, int timeout_ms, final BooleanSupplier isCancelled) throws CoreException {
        final AtomicReference<RunningState> processed = new AtomicReference<RunningState>(RunningState.Starting);
        final CompletableFuture result = new CompletableFuture();
        final UIJobCollector collector = new UIJobCollector();
        long start = System.currentTimeMillis();
        long stop = start + (long)timeout_ms;
        long halfWay = start + (long)(timeout_ms / 2);
        final Display display = PlatformUI.getWorkbench().getDisplay();
        if (Display.getCurrent() != null) {
            throw new IllegalStateException("Can't run in UI thread");
        }
        Job.getJobManager().addJobChangeListener((IJobChangeListener)collector);
        collector.enable();
        ITeslaEventListener listener = new ITeslaEventListener(){

            public synchronized boolean doProcessing(ContextManagement.Context currentContext) {
                if (isCancelled.getAsBoolean()) {
                    result.completeExceptionally((Throwable)new CoreException(Status.CANCEL_STATUS));
                    return false;
                }
                boolean tick = ((RunningState)((Object)processed.get())).equals((Object)RunningState.Starting) || ((RunningState)((Object)processed.get())).equals((Object)RunningState.Execution);
                Q7WaitInfoRoot info = TeslaBridge.getCurrentWaitInfo(tick);
                boolean resultValue = true;
                if (!PlatformUI.getWorkbench().getDisplay().equals(Display.getCurrent())) {
                    Q7WaitUtils.updateInfo((String)"display", (String)"instance", (Q7WaitInfoRoot)info);
                    UIRunnable.debugProceed("Wrong display");
                    resultValue = false;
                }
                if (SWTUIPlayer.hasTimers((Display)display, (Q7WaitInfoRoot)info)) {
                    Q7WaitUtils.updateInfo((String)"display", (String)"timers", (Q7WaitInfoRoot)info);
                    UIRunnable.debugProceed("Has timers");
                    resultValue = false;
                }
                if (SWTUIPlayer.hasRunnables((Display)display)) {
                    Q7WaitUtils.updateInfo((String)"display", (String)"runnables", (Q7WaitInfoRoot)info);
                    UIRunnable.debugProceed("Has runnables");
                    resultValue = false;
                }
                if (!collector.isEmpty(currentContext, info)) {
                    UIRunnable.debugProceed("Has jobs");
                    resultValue = false;
                }
                if (!resultValue) {
                    return false;
                }
                if (processed.compareAndSet(RunningState.Starting, RunningState.Execution)) {
                    UIRunnable.debugProceed("Starting");
                    try {
                        try {
                            result.complete(runnable.run());
                        }
                        catch (Throwable e) {
                            result.completeExceptionally(e);
                            collector.setNeedDisable();
                            processed.set(RunningState.Finished);
                            UIRunnable.debugProceed("Done");
                            return true;
                        }
                    }
                    finally {
                        UIRunnable.debugProceed("Done");
                    }
                    processed.set(RunningState.Done);
                    return true;
                }
                UIRunnable.debugProceed("Already executing");
                if (((RunningState)((Object)processed.get())).equals((Object)RunningState.Done)) {
                    collector.setNeedDisable();
                    processed.set(RunningState.Finished);
                    return true;
                }
                return false;
            }

            public void hasEvent(TeslaEventManager.HasEventKind kind, String run) {
            }
        };
        final IStatus[] dialogCloseStatus = new IStatus[1];
        try {
            TeslaEventManager.getManager().addEventListener(listener);
            while (!processed.get().equals((Object)RunningState.Finished)) {
                if (display.isDisposed()) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
                if (isCancelled.getAsBoolean()) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
                SWTUIPlayer.notifyUI((Display)display);
                try {
                    result.get(100L, TimeUnit.MILLISECONDS);
                    break;
                }
                catch (TimeoutException timeoutException) {
                    long time = System.currentTimeMillis();
                    if (time > halfWay && processed.get().equals((Object)RunningState.Starting)) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                dialogCloseStatus[0] = Utils.closeDialogs();
                            }
                        });
                        collector.clean();
                    }
                    if (time <= stop) continue;
                    UIRunnable.storeTimeoutInReport(display, collector);
                    MultiStatus status = new MultiStatus("org.eclipse.rcptt.tesla.ecl.impl", 123130, "Timeout during execution of " + String.valueOf(runnable), new RuntimeException()){
                        {
                            this.setSeverity(4);
                        }
                    };
                    if (dialogCloseStatus[0] != null) {
                        status.add(dialogCloseStatus[0]);
                    }
                    throw new CoreException((IStatus)status);
                }
            }
            if (!result.isCompletedExceptionally()) {
                while (true) {
                    Q7WaitInfoRoot info = TeslaBridge.getCurrentWaitInfo(true);
                    if (collector.isEmpty(ContextManagement.currentContext(), info)) break;
                    if (isCancelled.getAsBoolean()) {
                        throw new CoreException(Status.CANCEL_STATUS);
                    }
                    if (System.currentTimeMillis() > stop) {
                        UIRunnable.storeTimeoutInReport(display, collector);
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.tesla.ecl.impl", 123130, "Background jobs are running for too long", (Throwable)new RuntimeException()));
                    }
                    Thread.sleep(1L);
                }
            }
            Object t = result.get(1L, TimeUnit.MILLISECONDS);
            return t;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof CoreException) {
                throw (CoreException)e.getCause();
            }
            throw new CoreException(UIRunnable.createError(e.getCause()));
        }
        catch (TimeoutException e) {
            throw new CoreException(UIRunnable.createError(e));
        }
        finally {
            processed.set(RunningState.Done);
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)collector);
            TeslaEventManager.getManager().removeEventListener(listener);
        }
    }

    private static IStatus createError(Throwable exception) {
        return new Status(4, "org.eclipse.rcptt.tesla.ecl.impl", exception.getMessage(), exception);
    }

    private static int getTimeout() {
        return TeslaLimits.getContextRunnableTimeout();
    }

    private static void storeTimeoutInReport(final Display display, UIJobCollector collector) throws InterruptedException {
        ReportBuilder currentBuilder = ReportManager.getBuilder();
        boolean[] infoCollected = new boolean[1];
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                TeslaQClient client = TeslaBridge.getClient();
                if (client != null) {
                    client.collectLastFailureInformation();
                }
                ReportScreenshotProvider.takeScreenshot((Display)display, (boolean)true, (String)"timeout");
            }
        });
    }

    public abstract T run() throws CoreException;

    private static void debugProceed(String message) {
        if (DEBUG_PROCEED) {
            System.out.println("UIRunnable: " + message);
            System.out.flush();
        }
    }

    private static enum RunningState {
        Starting,
        Execution,
        Done,
        Finished;

    }
}

