/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.spy.sections;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.runtime.PDERuntimeMessages;
import org.eclipse.pde.internal.runtime.spy.SpyFormToolkit;
import org.eclipse.pde.internal.runtime.spy.sections.ISpySection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.handlers.HandlerUtil;

public class ActiveFormEditorSection
implements ISpySection {
    @Override
    public void build(ScrolledForm form, SpyFormToolkit toolkit, ExecutionEvent event) {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (!(part instanceof FormEditor)) {
            return;
        }
        FormEditor multiEditor = (FormEditor)part;
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        Object object = shell.getData();
        if (object == null) {
            return;
        }
        IFormPage activePage = multiEditor.getActivePageInstance();
        if (activePage == null) {
            return;
        }
        Section section = toolkit.createSection(form.getBody(), 256);
        section.setText(PDERuntimeMessages.ActiveFormEditorSection_Active_Form_Page);
        FormText text = toolkit.createFormText((Composite)section, true);
        section.setClient((Control)text);
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        StringBuilder buffer = new StringBuilder();
        buffer.append("<form>");
        buffer.append(toolkit.createClassSection(text, NLS.bind((String)PDERuntimeMessages.SpyDialog_activePart_desc, (Object)"editor tab"), activePage.getClass()));
        SectionPart activeSection = this.getActiveFormSection(activePage);
        if (activeSection != null) {
            buffer.append(toolkit.createClassSection(text, NLS.bind((String)PDERuntimeMessages.SpyDialog_activePart_desc, (Object)"form section"), activeSection.getClass()));
        }
        buffer.append("</form>");
        text.setText(buffer.toString(), true, false);
        text.requestLayout();
    }

    private SectionPart getActiveFormSection(IFormPage activePage) {
        Control focusedControl = Display.getCurrent().getFocusControl();
        if (focusedControl == null) {
            return null;
        }
        IManagedForm form = activePage.getManagedForm();
        if (form == null) {
            return null;
        }
        IFormPart[] iFormPartArray = form.getParts();
        int n = iFormPartArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPart formPart = iFormPartArray[n2];
            if (formPart instanceof SectionPart) {
                Control[] sectionWidgets;
                SectionPart formSection = (SectionPart)formPart;
                Control[] controlArray = sectionWidgets = formSection.getSection().getChildren();
                int n3 = sectionWidgets.length;
                int n4 = 0;
                while (n4 < n3) {
                    Control widget = controlArray[n4];
                    if (this.contains(widget, focusedControl)) {
                        return formSection;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    private boolean contains(Control whereToLook, Control whatToFind) {
        if (whereToLook == null || whatToFind == null) {
            return false;
        }
        if (whereToLook instanceof Composite) {
            Composite compositeWhereToLook = (Composite)whereToLook;
            Control[] controlArray = compositeWhereToLook.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (this.contains(child, whatToFind)) {
                    return true;
                }
                ++n2;
            }
        }
        return whereToLook == whatToFind;
    }
}

