/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.update.configurator;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.internal.core.update.configurator.Configuration;
import org.eclipse.pde.internal.core.update.configurator.ConfigurationParser;
import org.eclipse.pde.internal.core.update.configurator.IConfigurationConstants;
import org.eclipse.pde.internal.core.update.configurator.Messages;
import org.eclipse.pde.internal.core.update.configurator.SiteEntry;
import org.eclipse.pde.internal.core.update.configurator.Utils;

@Deprecated
public class PlatformConfiguration
implements IConfigurationConstants {
    private Configuration config;
    private static int defaultPolicy = 1;
    private static final String CONFIG_FILE_TEMP_SUFFIX = ".tmp";
    private static URL installURL;

    public PlatformConfiguration(URL url) throws Exception {
        URL installLocation = Utils.getInstallURL();
        try {
            if (url != null && url.getProtocol().equals("file") && url.getPath().endsWith("configuration/org.eclipse.update/platform.xml")) {
                installLocation = new Path(url.getPath()).removeLastSegments(3).toFile().toURL();
            }
        }
        catch (Exception exception) {}
        this.initialize(url, installLocation);
    }

    public static int getDefaultPolicy() {
        return defaultPolicy;
    }

    public SiteEntry[] getConfiguredSites() {
        if (this.config == null) {
            return new SiteEntry[0];
        }
        SiteEntry[] sites = this.config.getSites();
        ArrayList<SiteEntry> enabledSites = new ArrayList<SiteEntry>(sites.length);
        SiteEntry[] siteEntryArray = sites;
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            SiteEntry site = siteEntryArray[n2];
            if (site.isEnabled()) {
                enabledSites.add(site);
            }
            ++n2;
        }
        return enabledSites.toArray(new SiteEntry[enabledSites.size()]);
    }

    private synchronized void initialize(URL url, URL installLocation) throws Exception {
        if (url != null) {
            this.config = this.loadConfig(url, installLocation);
        }
        if (this.config == null) {
            this.config = new Configuration();
        }
        this.config.setURL(url);
        this.config.setInstallLocation(installLocation);
    }

    private Configuration loadConfig(URL url, URL installLocation) throws Exception {
        if (url == null) {
            throw new IOException(Messages.cfig_unableToLoad_noURL);
        }
        ConfigurationParser parser = null;
        try {
            parser = new ConfigurationParser();
        }
        catch (InvocationTargetException e) {
            throw (Exception)e.getTargetException();
        }
        this.config = null;
        Exception originalException = null;
        try {
            this.config = parser.parse(url, installLocation);
            if (this.config == null) {
                throw new Exception(Messages.PlatformConfiguration_cannotFindConfigFile);
            }
        }
        catch (Exception e1) {
            originalException = e1;
            try {
                URL tempURL = new URL(String.valueOf(url.toExternalForm()) + CONFIG_FILE_TEMP_SUFFIX);
                this.config = parser.parse(tempURL, installLocation);
                if (this.config == null) {
                    throw new Exception();
                }
                this.config.setDirty(true);
            }
            catch (Exception exception) {
                try {
                    File[] backups;
                    File cfigFile;
                    File workingDir;
                    if ("file".equals(url.getProtocol()) && (workingDir = (cfigFile = new File(url.getFile().replace('/', File.separatorChar))).getParentFile()) != null && workingDir.exists() && (backups = workingDir.listFiles(pathname -> pathname.isFile() && pathname.getName().endsWith(".xml"))) != null && backups.length > 0) {
                        URL backupUrl = backups[backups.length - 1].toURL();
                        this.config = parser.parse(backupUrl, installLocation);
                    }
                    if (this.config == null) {
                        throw originalException;
                    }
                    this.config.setDirty(true);
                }
                catch (IOException iOException) {
                    throw originalException;
                }
            }
        }
        return this.config;
    }

    public static boolean supportsDetection(URL url, URL installLocation) {
        String protocol = url.getProtocol();
        if (protocol.equals("file")) {
            return true;
        }
        if (protocol.equals("platform")) {
            URL resolved = null;
            try {
                resolved = PlatformConfiguration.resolvePlatformURL(url, installLocation);
            }
            catch (IOException iOException) {
                return false;
            }
            return resolved.getProtocol().equals("file");
        }
        return false;
    }

    public static URL resolvePlatformURL(URL url, URL base_path_Location) throws IOException {
        if (url.getProtocol().equals("platform")) {
            if (base_path_Location == null) {
                url = FileLocator.toFileURL((URL)url);
                File f = new File(url.getFile());
                url = f.toURL();
            } else {
                String toResolve = url.toExternalForm();
                url = toResolve.startsWith("platform:/base/") ? new URL(base_path_Location, toResolve.substring("platform:/base/".length())) : (toResolve.startsWith("platform:/config/") ? new URL(base_path_Location, toResolve.substring("platform:/config/".length())) : base_path_Location);
            }
        }
        return url;
    }

    public static URL getInstallURL() {
        return installURL;
    }

    public Configuration getConfiguration() {
        return this.config;
    }
}

