/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.CleanUpContextCore;
import org.eclipse.jdt.core.manipulation.CleanUpRequirementsCore;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.fix.SwitchFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUpCore;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;

public class SwitchCleanUpCore
extends AbstractCleanUpCore {
    public SwitchCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public SwitchCleanUpCore() {
    }

    @Override
    public CleanUpRequirementsCore getRequirementsCore() {
        return new CleanUpRequirementsCore(this.requireAST(), false, false, null);
    }

    public boolean requireAST() {
        return this.isEnabled("cleanup.switch");
    }

    @Override
    public ICleanUpFixCore createFixCore(CleanUpContextCore context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null) {
            return null;
        }
        boolean convertIfElseChainToSwitch = this.isEnabled("cleanup.switch");
        if (!convertIfElseChainToSwitch) {
            return null;
        }
        return SwitchFixCore.createCleanUp(compilationUnit);
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.switch")) {
            result.add(MultiFixMessages.CodeStyleCleanUp_Switch_description);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.switch")) {
            return "switch (number) {\ncase 0:\n  i = 0;\n  break;\ncase 1:\n  j = 10;\n  break;\ncase 2:\n  k = 20;\n  break;\ndefault:\n  m = -1;\n  break;\n}\n";
        }
        return "if (number == 0) {\n    i = 0;\n} else if (number == 1) {\n    j = 10;\n} else if (2 == number) {\n    k = 20;\n} else {\n    m = -1;\n}\n\n\n\n\n\n";
    }
}

