/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.site.BuildTimeFeature;
import org.osgi.framework.Version;

public class AssemblyInformation
implements IPDEBuildConstants {
    private final Map<Config, AssemblyLevelConfigInfo> assembleInformation = new HashMap<Config, AssemblyLevelConfigInfo>(8);
    private final Map<String, BundleDescription> bundleMap = new HashMap<String, BundleDescription>();
    private final Map<String, BuildTimeFeature> rootMap = new HashMap<String, BuildTimeFeature>();

    public AssemblyInformation() {
        for (Config config : AbstractScriptGenerator.getConfigInfos()) {
            this.assembleInformation.put(config, new AssemblyLevelConfigInfo());
        }
    }

    public void addFeature(Config config, BuildTimeFeature feature) {
        AssemblyLevelConfigInfo entry = this.assembleInformation.get(config);
        entry.addFeature(feature);
    }

    public void removeFeature(Config config, BuildTimeFeature feature) {
        AssemblyLevelConfigInfo entry = this.assembleInformation.get(config);
        entry.removeFeature(feature);
    }

    public void addPlugin(Config config, BundleDescription plugin) {
        AssemblyLevelConfigInfo entry = this.assembleInformation.get(config);
        entry.addPlugin(plugin);
        String id = plugin.getSymbolicName();
        BundleDescription existing = this.bundleMap.get(id);
        if (existing == null || existing.getVersion().compareTo(plugin.getVersion()) < 0) {
            this.bundleMap.put(id, plugin);
        }
        this.bundleMap.put(String.valueOf(id) + '_' + plugin.getVersion().toString(), plugin);
    }

    public BundleDescription getPlugin(String id, String version) {
        if (version != null && !"0.0.0".equals(version)) {
            return this.bundleMap.get(String.valueOf(id) + '_' + version);
        }
        return this.bundleMap.get(id);
    }

    public BuildTimeFeature getRootProvider(String id, String version) {
        if (version != null && !"0.0.0".equals(version)) {
            return this.rootMap.get(String.valueOf(id) + '_' + version);
        }
        return this.rootMap.get(id);
    }

    public Collection<BundleDescription> getPlugins(Config config) {
        return this.assembleInformation.get(config).getPlugins();
    }

    public Set<BundleDescription> getAllPlugins() {
        Collection<AssemblyLevelConfigInfo> pluginsByConfig = this.assembleInformation.values();
        LinkedHashSet<BundleDescription> result = new LinkedHashSet<BundleDescription>();
        for (AssemblyLevelConfigInfo assemblyLevelConfigInfo : pluginsByConfig) {
            Collection<BundleDescription> allPlugins = assemblyLevelConfigInfo.getPlugins();
            result.addAll(allPlugins);
        }
        return result;
    }

    public Collection<BundleDescription> getBinaryPlugins(Config config) {
        Collection<BundleDescription> allPlugins = this.getPlugins(config);
        LinkedHashSet<BundleDescription> result = new LinkedHashSet<BundleDescription>(allPlugins.size());
        for (BundleDescription bundle : allPlugins) {
            Properties bundleProperties = (Properties)bundle.getUserObject();
            if (bundleProperties != null && bundleProperties.get("isCompiler") != null && Boolean.FALSE != bundleProperties.get("isCompiler")) continue;
            result.add(bundle);
        }
        return result;
    }

    public Collection<BundleDescription> getCompiledPlugins(Config config) {
        Collection<BundleDescription> allPlugins = this.getPlugins(config);
        LinkedHashSet<BundleDescription> result = new LinkedHashSet<BundleDescription>(allPlugins.size());
        for (BundleDescription bundle : allPlugins) {
            Properties bundleProperties = (Properties)bundle.getUserObject();
            if (bundleProperties == null || Boolean.TRUE != bundleProperties.get("isCompiler")) continue;
            result.add(bundle);
        }
        return result;
    }

    public Set<BundleDescription> getAllCompiledPlugins() {
        Collection<AssemblyLevelConfigInfo> pluginsByConfig = this.assembleInformation.values();
        LinkedHashSet<BundleDescription> result = new LinkedHashSet<BundleDescription>();
        for (AssemblyLevelConfigInfo assemblyLevelConfigInfo : pluginsByConfig) {
            Collection<BundleDescription> allPlugins = assemblyLevelConfigInfo.getPlugins();
            for (BundleDescription bundle : allPlugins) {
                if (Utils.isBinary(bundle)) continue;
                result.add(bundle);
            }
        }
        return result;
    }

    public Collection<BuildTimeFeature> getCompiledFeatures(Config config) {
        ArrayList<BuildTimeFeature> allFeatures = this.getFeatures(config);
        ArrayList<BuildTimeFeature> result = new ArrayList<BuildTimeFeature>(allFeatures.size());
        for (BuildTimeFeature tmp : allFeatures) {
            if (tmp.isBinary()) continue;
            result.add(tmp);
        }
        return result;
    }

    public Collection<BuildTimeFeature> getBinaryFeatures(Config config) {
        ArrayList<BuildTimeFeature> allFeatures = this.getFeatures(config);
        ArrayList<BuildTimeFeature> result = new ArrayList<BuildTimeFeature>(allFeatures.size());
        for (BuildTimeFeature tmp : allFeatures) {
            if (!tmp.isBinary()) continue;
            result.add(tmp);
        }
        return result;
    }

    public ArrayList<BuildTimeFeature> getFeatures(Config config) {
        return this.assembleInformation.get(config).getFeatures();
    }

    public boolean copyRootFile(Config config) {
        return this.assembleInformation.get(config).hasRootFile();
    }

    public Collection<BuildTimeFeature> getRootFileProviders(Config config) {
        return this.assembleInformation.get(config).getRootFileProvider();
    }

    public void addRootFileProvider(Config config, BuildTimeFeature feature) {
        this.assembleInformation.get(config).addRootFileProvider(feature);
        String id = feature.getId();
        BuildTimeFeature existing = this.rootMap.get(id);
        if (existing == null || new Version(existing.getVersion()).compareTo(new Version(feature.getVersion())) < 0) {
            this.rootMap.put(id, feature);
        }
        this.rootMap.put(String.valueOf(id) + '_' + feature.getVersion(), feature);
    }

    protected static class AssemblyLevelConfigInfo {
        private final Collection<BundleDescription> plugins = new LinkedHashSet<BundleDescription>(20);
        private final ArrayList<BuildTimeFeature> features = new ArrayList(7);
        private final LinkedList<BuildTimeFeature> rootFileProviders = new LinkedList();

        protected AssemblyLevelConfigInfo() {
        }

        public void addRootFileProvider(BuildTimeFeature feature) {
            if (this.rootFileProviders.contains((Object)feature)) {
                return;
            }
            for (BuildTimeFeature featureDescriptor : this.rootFileProviders) {
                if (feature == featureDescriptor) {
                    return;
                }
                if (!feature.getId().equals(featureDescriptor.getId()) || !feature.getVersion().equals(featureDescriptor.getVersion())) continue;
                return;
            }
            this.rootFileProviders.add(feature);
        }

        public Collection<BuildTimeFeature> getRootFileProvider() {
            return this.rootFileProviders;
        }

        public boolean hasRootFile() {
            return this.rootFileProviders.size() > 0;
        }

        public ArrayList<BuildTimeFeature> getFeatures() {
            return this.features;
        }

        public Collection<BundleDescription> getPlugins() {
            return this.plugins;
        }

        public void addFeature(BuildTimeFeature feature) {
            for (BuildTimeFeature featureDescriptor : this.features) {
                if (!feature.getId().equals(featureDescriptor.getId()) || !feature.getVersion().equals(featureDescriptor.getVersion())) continue;
                return;
            }
            this.features.add(feature);
        }

        public void addPlugin(BundleDescription plugin) {
            this.plugins.add(plugin);
        }

        public void removeFeature(BuildTimeFeature feature) {
            for (BuildTimeFeature featureDescriptor : this.features) {
                if (!feature.getId().equals(featureDescriptor.getId()) || !feature.getVersion().equals(featureDescriptor.getVersion())) continue;
                this.features.remove((Object)featureDescriptor);
                return;
            }
        }
    }
}

