/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.io.File;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;

public class JarEntryFile
extends PlatformObject
implements IStorage {
    private ZipFile fZipFile;
    private String fEntryName;

    public JarEntryFile(ZipFile zipFile, String entryName) {
        this.fZipFile = zipFile;
        this.fEntryName = entryName;
    }

    public InputStream getContents() throws CoreException {
        try {
            ZipEntry zipEntry = this.fZipFile.getEntry(this.fEntryName);
            return this.fZipFile.getInputStream(zipEntry);
        }
        catch (Exception e) {
            throw new CoreException(Status.error((String)e.getMessage(), (Throwable)e));
        }
    }

    public IPath getFullPath() {
        return new Path(this.fEntryName);
    }

    public String getName() {
        return this.getFullPath().lastSegment();
    }

    public boolean isReadOnly() {
        return true;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.equals(ZipFile.class)) {
            return (T)this.fZipFile;
        }
        if (adapter.equals(File.class)) {
            return (T)new File(this.fZipFile.getName());
        }
        return (T)super.getAdapter(adapter);
    }

    public String toString() {
        return "JarEntryFile[" + this.fZipFile.getName() + "::" + this.fEntryName + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JarEntryFile)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

