/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.ext;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class OriginalOrderProperties
extends Properties {
    private static final long serialVersionUID = -8939534425662357037L;
    private List<Object> indexes = new ArrayList<Object>();
    private boolean addToBegining = false;

    @Override
    public synchronized Object put(Object key, Object value) {
        if (!this.indexes.contains(key)) {
            if (this.addToBegining) {
                this.indexes.add(0, key);
            } else {
                this.indexes.add(key);
            }
        }
        return super.put(key, value);
    }

    @Override
    public synchronized Object remove(Object key) {
        this.indexes.remove(key);
        return super.remove(key);
    }

    @Override
    public synchronized void clear() {
        this.indexes.clear();
        super.clear();
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        return Collections.enumeration(this.indexes);
    }

    public void setBeginAdd(boolean b) {
        this.addToBegining = b;
    }

    public static OriginalOrderProperties load(URL url) throws IOException {
        OriginalOrderProperties props = new OriginalOrderProperties();
        InputStream is = null;
        try {
            is = OriginalOrderProperties.getStream(url);
            props.load(is);
        }
        catch (Throwable throwable) {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return props;
    }

    private static InputStream getStream(URL location) throws IOException {
        File f;
        if ("file".equalsIgnoreCase(location.getProtocol()) && (f = new File(location.getPath())).exists()) {
            return new FileInputStream(f);
        }
        return location.openStream();
    }
}

