/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.junit.buildpath.BuildPathSupport;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.util.JUnitStubUtility;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.ClasspathFixProcessor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.swt.graphics.Image;

public class JUnitClasspathFixProcessor
extends ClasspathFixProcessor {
    private static final int JUNIT3 = 1;
    private static final int JUNIT4 = 2;
    private static final int JUNIT5 = 4;

    public ClasspathFixProcessor.ClasspathFixProposal[] getFixImportProposals(IJavaProject project, String missingType) throws CoreException {
        String s = missingType;
        int res = 0;
        if (s.startsWith("org.junit.jupiter") || s.startsWith("org.junit.platform")) {
            res = 4;
        } else if (s.startsWith("org.junit.")) {
            res = 2;
        } else if (s.equals("TestCase") || s.equals("TestSuite") || s.startsWith("junit.")) {
            res = 1;
        } else if (s.equals("Test")) {
            res = 7;
        } else if (s.equals("TestFactory") || s.equals("Testable") || s.equals("TestTemplate") || s.equals("ParameterizedTest") || s.equals("RepeatedTest")) {
            res = 4;
        } else if (s.equals("RunWith")) {
            res = 2;
        }
        if (res != 0) {
            ArrayList<JUnitClasspathFixProposal> proposals = new ArrayList<JUnitClasspathFixProposal>();
            if ((res & 4) != 0 && JUnitStubUtility.is18OrHigher(project)) {
                proposals.add(new JUnitClasspathFixProposal(project, 5, 15));
            }
            if ((res & 2) != 0 && JUnitStubUtility.is50OrHigher(project)) {
                proposals.add(new JUnitClasspathFixProposal(project, 4, 15));
            }
            if ((res & 1) != 0) {
                proposals.add(new JUnitClasspathFixProposal(project, 3, 15));
            }
            return proposals.toArray(new ClasspathFixProcessor.ClasspathFixProposal[proposals.size()]);
        }
        return null;
    }

    private static class JUnitClasspathFixProposal
    extends ClasspathFixProcessor.ClasspathFixProposal {
        private final int fJunitVersion;
        private final int fRelevance;
        private final IJavaProject fProject;

        public JUnitClasspathFixProposal(IJavaProject project, int junitVersion, int relevance) {
            this.fProject = project;
            this.fJunitVersion = junitVersion;
            this.fRelevance = relevance;
        }

        public String getAdditionalProposalInfo() {
            if (this.fJunitVersion == 5) {
                return JUnitMessages.JUnitAddLibraryProposal_junit5_info;
            }
            if (this.fJunitVersion == 4) {
                return JUnitMessages.JUnitAddLibraryProposal_junit4_info;
            }
            return JUnitMessages.JUnitAddLibraryProposal_info;
        }

        public Change createChange(IProgressMonitor monitor) throws CoreException {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(JUnitMessages.JUnitClasspathFixProcessor_progress_desc, 1);
            try {
                IClasspathEntry[] newCPEntries;
                Change newClasspathChange;
                IClasspathEntry entry = null;
                switch (this.fJunitVersion) {
                    case 5: {
                        entry = BuildPathSupport.getJUnit5ClasspathEntry();
                        break;
                    }
                    case 4: {
                        entry = BuildPathSupport.getJUnit4ClasspathEntry();
                        break;
                    }
                    default: {
                        entry = BuildPathSupport.getJUnit3ClasspathEntry();
                    }
                }
                IClasspathEntry[] oldEntries = this.fProject.getRawClasspath();
                ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>(oldEntries.length + 1);
                boolean added = false;
                IClasspathEntry[] iClasspathEntryArray = oldEntries;
                int n = oldEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath path;
                    IClasspathEntry curr = iClasspathEntryArray[n2];
                    if (curr.getEntryKind() == 5) {
                        path = curr.getPath();
                        if (path.equals((Object)entry.getPath())) {
                            NullChange nullChange = new NullChange();
                            return nullChange;
                        }
                        if (path.matchingFirstSegments(entry.getPath()) > 0) {
                            if (!added) {
                                curr = entry;
                                added = true;
                            } else {
                                curr = null;
                            }
                        }
                    } else if (curr.getEntryKind() == 4 && (path = curr.getPath()).segmentCount() > 0 && "JUNIT_HOME".equals(path.segment(0))) {
                        if (!added) {
                            curr = entry;
                            added = true;
                        } else {
                            curr = null;
                        }
                    }
                    if (curr != null) {
                        newEntries.add(curr);
                    }
                    ++n2;
                }
                if (!added) {
                    newEntries.add(entry);
                }
                if ((newClasspathChange = JUnitClasspathFixProposal.newClasspathChange((IJavaProject)this.fProject, (IClasspathEntry[])(newCPEntries = newEntries.toArray(new IClasspathEntry[newEntries.size()])), (IPath)this.fProject.getOutputLocation())) != null) {
                    Change change = newClasspathChange;
                    return change;
                }
            }
            finally {
                monitor.done();
            }
            return new NullChange();
        }

        public String getDisplayString() {
            if (this.fJunitVersion == 5) {
                return JUnitMessages.JUnitAddLibraryProposa_junit5_label;
            }
            if (this.fJunitVersion == 4) {
                return JUnitMessages.JUnitAddLibraryProposa_junit4_label;
            }
            return JUnitMessages.JUnitAddLibraryProposal_label;
        }

        public Image getImage() {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.library_obj.gif");
        }

        public int getRelevance() {
            return this.fRelevance;
        }
    }
}

