/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.pem;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.ProtocolException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.security.auth.login.CredentialException;
import javax.security.auth.login.FailedLoginException;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.loader.AbstractKeyPairResourceParser;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceParser;
import org.apache.sshd.common.config.keys.loader.PrivateKeyEncryptionContext;
import org.apache.sshd.common.config.keys.loader.PrivateKeyObfuscator;
import org.apache.sshd.common.config.keys.loader.pem.KeyPairPEMResourceParser;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;

public abstract class AbstractPEMResourceKeyPairParser
extends AbstractKeyPairResourceParser
implements KeyPairPEMResourceParser {
    private final String algo;
    private final String algId;

    protected AbstractPEMResourceKeyPairParser(String algo, String algId, List<String> beginners, List<String> enders) {
        super(beginners, enders);
        this.algo = ValidateUtils.checkNotNullAndNotEmpty(algo, "No encryption algorithm provided");
        this.algId = ValidateUtils.checkNotNullAndNotEmpty(algId, "No algorithm identifier provided");
    }

    @Override
    public String getAlgorithm() {
        return this.algo;
    }

    @Override
    public String getAlgorithmIdentifier() {
        return this.algId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<KeyPair> extractKeyPairs(SessionContext session, NamedResource resourceKey, String beginMarker, String endMarker, FilePasswordProvider passwordProvider, List<String> lines) throws IOException, GeneralSecurityException {
        if (GenericUtils.isEmpty(lines)) {
            return Collections.emptyList();
        }
        Boolean encrypted = null;
        byte[] initVector = null;
        String algInfo = null;
        int dataStartIndex = -1;
        for (int index = 0; index < lines.size(); ++index) {
            String line = GenericUtils.trimToEmpty(lines.get(index));
            if (GenericUtils.isEmpty(line)) continue;
            int headerPos = line.indexOf(58);
            if (headerPos < 0) {
                dataStartIndex = index;
                break;
            }
            if (line.startsWith("Proc-Type:")) {
                if (encrypted != null) {
                    throw new StreamCorruptedException("Multiple encryption indicators in " + resourceKey);
                }
                line = line.substring(headerPos + 1).trim();
                line = line.toUpperCase();
                encrypted = line.contains("ENCRYPTED");
                continue;
            }
            if (!line.startsWith("DEK-Info:")) continue;
            if (initVector != null || algInfo != null) {
                throw new StreamCorruptedException("Multiple encryption settings in " + resourceKey);
            }
            if ((headerPos = (line = line.substring(headerPos + 1).trim()).indexOf(44)) < 0) {
                throw new StreamCorruptedException(resourceKey + ": Missing encryption data values separator in line '" + line + "'");
            }
            algInfo = line.substring(0, headerPos).trim();
            String algInitVector = line.substring(headerPos + 1).trim();
            initVector = BufferUtils.decodeHex('\u0000', algInitVector);
        }
        if (dataStartIndex < 0) {
            throw new StreamCorruptedException("No data lines (only headers or empty) found in " + resourceKey);
        }
        List<String> dataLines = lines.subList(dataStartIndex, lines.size());
        if (encrypted != null || algInfo != null || initVector != null) {
            if (passwordProvider == null) {
                throw new CredentialException("Missing password provider for encrypted resource=" + resourceKey);
            }
            int retryIndex = 0;
            while (true) {
                block36: {
                    Collection<KeyPair> keys;
                    String password = passwordProvider.getPassword(session, resourceKey, retryIndex);
                    try {
                        if (GenericUtils.isEmpty(password)) {
                            throw new FailedLoginException("No password data for encrypted resource=" + resourceKey);
                        }
                        PrivateKeyEncryptionContext encContext = new PrivateKeyEncryptionContext(algInfo);
                        encContext.setPassword(password);
                        encContext.setInitVector(initVector);
                        byte[] encryptedData = GenericUtils.EMPTY_BYTE_ARRAY;
                        byte[] decodedData = GenericUtils.EMPTY_BYTE_ARRAY;
                        try {
                            encryptedData = KeyPairResourceParser.extractDataBytes(dataLines);
                            decodedData = this.applyPrivateKeyCipher(encryptedData, encContext, false);
                            try (ByteArrayInputStream bais = new ByteArrayInputStream(decodedData);){
                                keys = this.extractKeyPairs(session, resourceKey, beginMarker, endMarker, passwordProvider, bais);
                            }
                        }
                        finally {
                            Arrays.fill(encryptedData, (byte)0);
                            Arrays.fill(decodedData, (byte)0);
                        }
                    }
                    catch (IOException | RuntimeException | GeneralSecurityException e) {
                        FilePasswordProvider.ResourceDecodeResult result = passwordProvider.handleDecodeAttemptResult(session, resourceKey, retryIndex, password, e);
                        password = null;
                        if (result == null) {
                            result = FilePasswordProvider.ResourceDecodeResult.TERMINATE;
                        }
                        switch (result) {
                            case TERMINATE: {
                                throw e;
                            }
                            case RETRY: {
                                break block36;
                            }
                            case IGNORE: {
                                return Collections.emptyList();
                            }
                            default: {
                                throw new ProtocolException("Unsupported decode attempt result (" + (Object)((Object)result) + ") for " + resourceKey);
                            }
                        }
                    }
                    passwordProvider.handleDecodeAttemptResult(session, resourceKey, retryIndex, password, null);
                    password = null;
                    return keys;
                }
                ++retryIndex;
            }
        }
        return super.extractKeyPairs(session, resourceKey, beginMarker, endMarker, passwordProvider, dataLines);
    }

    protected byte[] applyPrivateKeyCipher(byte[] bytes, PrivateKeyEncryptionContext encContext, boolean encryptIt) throws GeneralSecurityException, IOException {
        String cipherName = encContext.getCipherName();
        PrivateKeyObfuscator o = encContext.resolvePrivateKeyObfuscator();
        if (o == null) {
            throw new NoSuchAlgorithmException("decryptPrivateKeyData(" + encContext + ")[encrypt=" + encryptIt + "] unknown cipher: " + cipherName);
        }
        if (encryptIt) {
            byte[] initVector = encContext.getInitVector();
            if (GenericUtils.isEmpty(new byte[][]{initVector})) {
                initVector = o.generateInitializationVector(encContext);
                encContext.setInitVector(initVector);
            }
        }
        return o.applyPrivateKeyCipher(bytes, encContext, encryptIt);
    }
}

