/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.internal.ui.wizards.exports.AbstractExportWizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class CrossPlatformExportPage
extends AbstractExportWizardPage {
    private static String CROSS_PLATFORM = "cross-platform";
    private PlatformPart fPlatformPart = new PlatformPart(PDEUIMessages.CrossPlatformExportPage_available, new String[]{PDEUIMessages.WizardCheckboxTablePart_selectAll, PDEUIMessages.WizardCheckboxTablePart_deselectAll});
    private IFeatureModel fModel;

    public CrossPlatformExportPage(String pageName, IFeatureModel model) {
        super(pageName);
        this.setTitle(PDEUIMessages.CrossPlatformExportPage_title);
        this.setDescription(PDEUIMessages.CrossPlatformExportPage_desc);
        this.fModel = model;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        this.fPlatformPart.createControl(container);
        CheckboxTableViewer viewer = this.fPlatformPart.getTableViewer();
        viewer.setContentProvider((IContentProvider)new ContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fPlatformPart.getTableViewer().setInput((Object)PDECore.getDefault().getFeatureModelManager());
        this.initialize();
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.cross_platform_export_page");
    }

    private void initialize() {
        String value = this.getDialogSettings().get(CROSS_PLATFORM);
        if (value != null) {
            TableItem[] items;
            HashSet<String> set = new HashSet<String>();
            StringTokenizer tok = new StringTokenizer(value, ",");
            while (tok.hasMoreTokens()) {
                set.add(tok.nextToken());
            }
            ArrayList<Configuration> selected = new ArrayList<Configuration>();
            TableItem[] tableItemArray = items = this.fPlatformPart.getTableViewer().getTable().getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                Configuration config = (Configuration)item.getData();
                if (set.contains(config.toString())) {
                    selected.add(config);
                }
                ++n2;
            }
            this.fPlatformPart.setSelection(selected.toArray());
        } else {
            TableItem[] items;
            Configuration config = new Configuration();
            config.ws = TargetPlatform.getWS();
            config.os = TargetPlatform.getOS();
            config.arch = TargetPlatform.getOSArch();
            TableItem[] tableItemArray = items = this.fPlatformPart.getTableViewer().getTable().getItems();
            int n = items.length;
            int n3 = 0;
            while (n3 < n) {
                TableItem item = tableItemArray[n3];
                Configuration c = (Configuration)item.getData();
                if (c.equals(config)) {
                    this.fPlatformPart.getTableViewer().setChecked((Object)c, true);
                    this.fPlatformPart.updateCounter(1);
                }
                ++n3;
            }
        }
        this.pageChanged();
    }

    @Override
    public void saveSettings(IDialogSettings settings) {
        Object[] objects = this.fPlatformPart.getSelection();
        StringBuilder buffer = new StringBuilder();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append(object.toString());
            ++n2;
        }
        settings.put(CROSS_PLATFORM, buffer.toString());
    }

    private Configuration[] getListElements() {
        File bin;
        ArrayList<Configuration> list = new ArrayList<Configuration>();
        if (this.fModel != null && (bin = new File(this.fModel.getInstallLocation(), "bin")).exists() && bin.isDirectory()) {
            File[] children;
            File[] fileArray = children = bin.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isDirectory()) {
                    this.getWS(list, child);
                }
                ++n2;
            }
        }
        return list.toArray(new Configuration[list.size()]);
    }

    private void getWS(ArrayList<Configuration> list, File file) {
        File[] children;
        File[] fileArray = children = file.listFiles();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (child.isDirectory()) {
                this.getOS(list, child, file.getName());
            }
            ++n2;
        }
    }

    private void getOS(ArrayList<Configuration> list, File file, String ws) {
        File[] children = file.listFiles();
        int i = 0;
        while (i < children.length) {
            if (children[i].isDirectory() && !"CVS".equalsIgnoreCase(children[i].getName())) {
                Configuration config = new Configuration();
                config.ws = ws;
                config.os = file.getName();
                config.arch = children[i].getName();
                list.add(config);
            }
            ++i;
        }
    }

    @Override
    protected void pageChanged() {
        this.setPageComplete(this.fPlatformPart.getSelectionCount() > 0);
    }

    public String[][] getTargets() {
        Object[] objects = this.fPlatformPart.getSelection();
        String[][] targets = new String[objects.length][4];
        int i = 0;
        while (i < objects.length) {
            Configuration config = (Configuration)objects[i];
            String[] combo = new String[]{config.os, config.ws, config.arch, ""};
            targets[i] = combo;
            ++i;
        }
        return targets;
    }

    class Configuration {
        String os;
        String ws;
        String arch;

        Configuration() {
        }

        public String toString() {
            return String.valueOf(this.os) + " (" + this.ws + "/" + this.arch + ")";
        }

        public boolean equals(Object obj) {
            if (obj instanceof Configuration) {
                Configuration config = (Configuration)obj;
                return this.os.equals(config.os) && this.ws.equals(config.ws) && this.arch.equals(config.arch);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.os.hashCode() + this.ws.hashCode() + this.arch.hashCode();
        }
    }

    class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return CrossPlatformExportPage.this.getListElements();
        }
    }

    class PlatformPart
    extends WizardCheckboxTablePart {
        public PlatformPart(String label, String[] buttonLabels) {
            super(label, buttonLabels);
        }

        @Override
        public void updateCounter(int count) {
            super.updateCounter(count);
            CrossPlatformExportPage.this.pageChanged();
        }

        @Override
        protected void buttonSelected(Button button, int index) {
            switch (index) {
                case 0: {
                    this.handleSelectAll(true);
                    break;
                }
                case 1: {
                    this.handleSelectAll(false);
                }
            }
        }
    }
}

