/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.CorePackage;
import org.eclipse.rcptt.ecl.core.Exec;
import org.eclipse.rcptt.ecl.core.ExecutableParameter;
import org.eclipse.rcptt.ecl.core.LiteralParameter;
import org.eclipse.rcptt.ecl.core.Parameter;
import org.eclipse.rcptt.ecl.core.ProcInstance;
import org.eclipse.rcptt.ecl.core.util.EclCommandNameConvention;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;
import org.eclipse.rcptt.ecl.internal.core.ParamConverterManager;
import org.eclipse.rcptt.ecl.internal.core.ProcService;
import org.eclipse.rcptt.ecl.runtime.CoreUtils;
import org.eclipse.rcptt.ecl.runtime.FQName;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IParamConverter;
import org.eclipse.rcptt.ecl.runtime.IPipe;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class ExecService
implements ICommandService {
    @Override
    public IStatus service(Command command, IProcess process) throws InterruptedException, CoreException {
        Exec exec = (Exec)command;
        List<Object> input = CoreUtils.readPipeContent(process.getInput());
        return this.exec(new FQName(null, EclCommandNameConvention.toScriptletName(exec.getName())), (List<Parameter>)exec.getParameters(), process, input, command);
    }

    private IStatus exec(FQName fqn, List<Parameter> params, IProcess process, List<Object> input, Command cmd) throws CoreException, InterruptedException {
        Command target;
        try {
            target = this.createCommand(fqn, process);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        ArrayList<Object> inputList = new ArrayList<Object>(input);
        IStatus status = this.evalParameters(target, params, process, inputList);
        if (!status.isOK()) {
            return status;
        }
        IPipe inputPipe = process.getSession().createPipe();
        for (Object e : inputList) {
            inputPipe.write(e);
        }
        inputPipe.close(Status.OK_STATUS);
        IProcess iProcess = process.getSession().execute(target, inputPipe, process.getOutput());
        IStatus s = iProcess.waitFor();
        return s;
    }

    private Command createCommand(FQName fqn, IProcess process) throws CoreException {
        try {
            return CoreUtils.createCommand(fqn.ns, fqn.name);
        }
        catch (CoreException coreException) {
            ProcInstance result = ProcService.getProcs(process).createCommand(fqn.name);
            if (result == null) {
                throw new CoreException(CorePlugin.err(String.format("Scriptlet %s not found", fqn.name)));
            }
            return result;
        }
    }

    private IStatus evalParameters(Command target, List<Parameter> params, IProcess process, List<Object> input) throws CoreException, InterruptedException {
        EClass targetClass = target.eClass();
        List<EStructuralFeature> features = CoreUtils.getFeatures(targetClass);
        int cmdCommandSize = 0;
        HashMap<String, EStructuralFeature> featuresByName = new HashMap<String, EStructuralFeature>();
        ArrayList<EStructuralFeature> orderedFeatures = new ArrayList<EStructuralFeature>();
        boolean hasNonLimited = false;
        for (EStructuralFeature feature : features) {
            if (this.isInternalFeature(feature)) continue;
            orderedFeatures.add(feature);
            String name = feature.getName();
            if (featuresByName.containsKey(name)) {
                return this.createErrorStatus(NLS.bind((String)"Duplicate parameter name: {0}", (Object)name));
            }
            featuresByName.put(name, feature);
            int upperBound = feature.getUpperBound();
            if (upperBound == -1) {
                hasNonLimited = true;
            }
            cmdCommandSize += upperBound;
        }
        int i = 0;
        boolean processUnnamed = this.canProcessUnnamed(targetClass);
        boolean fullSet = params.size() == cmdCommandSize && !hasNonLimited;
        boolean inputUsed = false;
        Iterator<Parameter> paramIterator = params.iterator();
        Parameter param = null;
        boolean peekParam = true;
        while (paramIterator.hasNext() || !peekParam) {
            EStructuralFeature feature;
            if (peekParam) {
                param = paramIterator.next();
            }
            peekParam = true;
            if (param.eIsSet((EStructuralFeature)CorePackage.eINSTANCE.getParameter_Name())) {
                processUnnamed = false;
            } else if (!processUnnamed) {
                return this.createErrorStatus("Unnamed parameters disallowed after named ones");
            }
            if (i >= orderedFeatures.size() && processUnnamed) {
                return this.createErrorStatus("Cannot match given parameters to declared parameters");
            }
            EStructuralFeature eStructuralFeature = feature = processUnnamed ? (EStructuralFeature)orderedFeatures.get(i++) : (EStructuralFeature)featuresByName.get(param.getName());
            if (feature == null) {
                return this.createErrorStatus(NLS.bind((String)"Invalid parameter name: {0}", (Object)param.getName()));
            }
            if (processUnnamed && this.isInputFeature(feature) && input.size() > 0 && !fullSet) {
                feature = (EStructuralFeature)orderedFeatures.get(i++);
            }
            int lowerBound = feature.getLowerBound();
            int upperBound = feature.getUpperBound();
            int setParamsCount = 0;
            if (upperBound == -1) {
                upperBound = Integer.MAX_VALUE;
            }
            String currentParamName = param.getName();
            while (setParamsCount < upperBound) {
                try {
                    Object value = this.calcParamValue(param, feature, process, input);
                    this.setFeatureValue(target, feature, value);
                }
                catch (CoreException e) {
                    if (e.getStatus().getCode() != 42 || !processUnnamed) {
                        return e.getStatus();
                    }
                    peekParam = false;
                    break;
                }
                peekParam = true;
                ++setParamsCount;
                if (!paramIterator.hasNext()) break;
                param = paramIterator.next();
                peekParam = false;
                String nextParamName = param.getName();
                if (currentParamName != null ? !currentParamName.equals(nextParamName) : nextParamName != null) break;
            }
            if (setParamsCount < lowerBound) {
                return this.createErrorStatus(String.format("Insuffitient parameter count for feature '%s'", feature.getName()));
            }
            if (!this.isInputFeature(feature)) continue;
            inputUsed = true;
        }
        if (inputUsed) {
            input.clear();
        }
        return Status.OK_STATUS;
    }

    private boolean isInternalFeature(EStructuralFeature feature) {
        return feature.getEAnnotation("http://www.eclipse.org/ecl/internal") != null;
    }

    private boolean isInputFeature(EStructuralFeature feature) {
        return feature.getEAnnotation("http://www.eclipse.org/ecl/input") != null;
    }

    private void setFeatureValue(Command target, EStructuralFeature feature, Object value) throws CoreException {
        try {
            if (feature.getUpperBound() == 1) {
                target.eSet(feature, value);
            } else {
                List list = (List)target.eGet(feature);
                if (value instanceof List) {
                    list.addAll((List)value);
                } else {
                    list.add(value);
                }
            }
        }
        catch (ClassCastException cce) {
            Status status = new Status(4, "org.eclipse.rcptt.ecl.core", 42, "Can't assign value " + value + " to parameter " + feature.getName(), (Throwable)cce);
            throw new CoreException((IStatus)status);
        }
    }

    private Object calcParamValue(Parameter param, EStructuralFeature feature, IProcess process, List<Object> input) throws CoreException, InterruptedException {
        Object value = null;
        Class instanceClass = feature.getEType().getInstanceClass();
        if (param instanceof LiteralParameter) {
            LiteralParameter literal = (LiteralParameter)param;
            List<String> allowedTypes = CoreUtils.getMetaTypeList(feature);
            try {
                if (feature.getEType() instanceof EEnum) {
                    value = this.processEnumValue(feature, literal);
                }
                if (value == null) {
                    value = this.convertValue(value, literal, instanceClass, allowedTypes);
                }
                if (value == null) {
                    value = this.getBoxedValue(literal, instanceClass, allowedTypes);
                }
                if (value == null && feature.getEType() instanceof EDataType) {
                    value = EcoreUtil.createFromString((EDataType)((EDataType)feature.getEType()), (String)literal.getLiteral());
                }
            }
            catch (Exception e) {
                if (e instanceof CoreException) {
                    throw (CoreException)((Object)e);
                }
                Status status = new Status(4, "org.eclipse.rcptt.ecl.core", 42, "Parameter conversion failed: " + e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
            if (value == null) {
                Status status = new Status(4, "org.eclipse.rcptt.ecl.core", 42, "Can't convert value " + literal.getLiteral() + " to type " + instanceClass.getSimpleName(), null);
                throw new CoreException((IStatus)status);
            }
        } else if (param instanceof ExecutableParameter) {
            value = this.processExecutableValue((ExecutableParameter)param, process, input);
        } else {
            throw new RuntimeException("Invalid parameter");
        }
        value = this.processBoxUnbox(feature, value);
        return value;
    }

    private Object processBoxUnbox(EStructuralFeature feature, Object value) {
        value = value instanceof List ? CoreUtils.convert((List)value, feature) : CoreUtils.convert(Arrays.asList(value), feature).get(0);
        return value;
    }

    private Object processExecutableValue(ExecutableParameter execParam, IProcess process, List<Object> input) throws CoreException, InterruptedException {
        IPipe childInput = process.getSession().createPipe();
        IPipe childOutput = process.getSession().createPipe();
        for (Object o : input) {
            childInput.write(o);
        }
        childInput.close(Status.OK_STATUS);
        IProcess childProcess = process.getSession().execute(execParam.getCommand(), childInput, childOutput);
        IStatus status = childProcess.waitFor();
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        List<Object> content = CoreUtils.readPipeContent(childOutput);
        Object value = content.size() == 1 ? content.get(0) : content;
        return value;
    }

    private Object convertValue(Object value, LiteralParameter literal, Class<?> instanceClass, List<String> allowedTypes) throws CoreException {
        IParamConverter<?> converter = ParamConverterManager.getInstance().getConverter(instanceClass);
        if (converter != null) {
            value = converter.convert(literal, allowedTypes);
        }
        return value;
    }

    private Object processEnumValue(EStructuralFeature feature, LiteralParameter literal) throws CoreException {
        EEnum en = (EEnum)feature.getEType();
        EEnumLiteral eEnumLiteral = en.getEEnumLiteral(literal.getLiteral());
        if (eEnumLiteral == null) {
            Status status = new Status(4, "org.eclipse.rcptt.ecl.core", "Invalid constant: " + literal.getLiteral());
            throw new CoreException((IStatus)status);
        }
        Enumerator value = eEnumLiteral.getInstance();
        return value;
    }

    private Object getBoxedValue(LiteralParameter literal, Class<?> instanceClass, List<String> allowedTypes) throws CoreException {
        if (!instanceClass.equals(EObject.class)) {
            return null;
        }
        Object val = literal.getLiteral();
        IParamConverter<Object> converter = ParamConverterManager.getInstance().getConverter(Object.class);
        if (converter != null) {
            val = converter.convert(literal, allowedTypes);
        }
        return val;
    }

    private boolean canProcessUnnamed(EClass targetClass) throws CoreException {
        boolean wasOptional = false;
        for (EStructuralFeature feature : targetClass.getEStructuralFeatures()) {
            int lower = feature.getLowerBound();
            int upper = feature.getUpperBound();
            this.checkBounds(lower, upper);
            if (lower == 0) {
                wasOptional = true;
                continue;
            }
            if (!wasOptional) continue;
            return false;
        }
        return true;
    }

    private void checkBounds(int lower, int upper) throws CoreException {
        if (lower < 0) {
            throw new CoreException((IStatus)this.createErrorStatus(NLS.bind((String)"Lower bounds is invalid: {0}", (Object)lower)));
        }
        if (upper == 0 || upper < -1) {
            throw new CoreException((IStatus)this.createErrorStatus(NLS.bind((String)"Upper bounds is invalid: {0}", (Object)upper)));
        }
    }

    private Status createErrorStatus(String message) {
        return new Status(4, "org.eclipse.rcptt.ecl.core", message);
    }
}

