/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.manipulation;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelComposerCore;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsMessages;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;

public final class JavaElementLabelsCore {
    public static final long M_PARAMETER_TYPES = 1L;
    public static final long M_PARAMETER_NAMES = 2L;
    public static final long M_PARAMETER_ANNOTATIONS = 0x10000000000000L;
    public static final long M_PRE_TYPE_PARAMETERS = 4L;
    public static final long M_APP_TYPE_PARAMETERS = 8L;
    public static final long M_EXCEPTIONS = 16L;
    public static final long M_APP_RETURNTYPE = 32L;
    public static final long M_PRE_RETURNTYPE = 64L;
    public static final long M_FULLY_QUALIFIED = 128L;
    public static final long M_POST_QUALIFIED = 256L;
    public static final long I_FULLY_QUALIFIED = 1024L;
    public static final long I_POST_QUALIFIED = 2048L;
    public static final long F_APP_TYPE_SIGNATURE = 16384L;
    public static final long F_PRE_TYPE_SIGNATURE = 32768L;
    public static final long F_FULLY_QUALIFIED = 65536L;
    public static final long F_POST_QUALIFIED = 131072L;
    public static final long T_FULLY_QUALIFIED = 262144L;
    public static final long T_CONTAINER_QUALIFIED = 524288L;
    public static final long T_POST_QUALIFIED = 0x100000L;
    public static final long T_TYPE_PARAMETERS = 0x200000L;
    public static final long TP_POST_QUALIFIED = 0x400000L;
    public static final long D_QUALIFIED = 0x1000000L;
    public static final long D_POST_QUALIFIED = 0x2000000L;
    public static final long CF_QUALIFIED = 0x8000000L;
    public static final long CF_POST_QUALIFIED = 0x10000000L;
    public static final long CU_QUALIFIED = 0x80000000L;
    public static final long CU_POST_QUALIFIED = 0x100000000L;
    public static final long P_QUALIFIED = 0x800000000L;
    public static final long P_POST_QUALIFIED = 0x1000000000L;
    public static final long P_COMPRESSED = 0x2000000000L;
    public static final long ROOT_VARIABLE = 0x10000000000L;
    public static final long ROOT_QUALIFIED = 0x20000000000L;
    public static final long ROOT_POST_QUALIFIED = 0x40000000000L;
    public static final long APPEND_ROOT_PATH = 0x80000000000L;
    public static final long PREPEND_ROOT_PATH = 0x100000000000L;
    public static final long REFERENCED_ROOT_POST_QUALIFIED = 0x200000000000L;
    public static final long USE_RESOLVED = 0x1000000000000L;
    public static final long COLORIZE = 0x80000000000000L;
    public static final long F_CATEGORY = 0x2000000000000L;
    public static final long M_CATEGORY = 0x4000000000000L;
    public static final long T_CATEGORY = 0x8000000000000L;
    public static final long MOD_CATEGORY = 0x10000000000000L;
    public static final long ALL_CATEGORY = 0x1E000000000000L;
    public static final long ALL_FULLY_QUALIFIED = new Long(2235681801344L);
    public static final long ALL_POST_QUALIFIED = new Long(4471368321280L);
    public static final long ALL_DEFAULT = new Long(0x200009L);
    public static final long DEFAULT_QUALIFIED = new Long(2298807424L);
    public static final long DEFAULT_POST_QUALIFIED = new Long(4602333440L);
    public static final String CONCAT_STRING = JavaElementLabelsMessages.JavaElementLabels_concat_string;
    public static final String COMMA_STRING = JavaElementLabelsMessages.JavaElementLabels_comma_string;
    public static final String DECL_STRING = JavaElementLabelsMessages.JavaElementLabels_declseparator_string;
    public static final String CATEGORY_SEPARATOR_STRING = JavaElementLabelsMessages.JavaElementLabels_category_separator_string;
    public static final String ELLIPSIS_STRING = "...";
    public static final String DEFAULT_PACKAGE = JavaElementLabelsMessages.JavaElementLabels_default_package;

    private JavaElementLabelsCore() {
    }

    public static String getTextLabel(Object obj, long flags) {
        if (obj instanceof IJavaElement) {
            return JavaElementLabelsCore.getElementLabel((IJavaElement)obj, flags);
        }
        if (obj instanceof IResource) {
            return BasicElementLabels.getResourceName((IResource)obj);
        }
        if (obj instanceof IStorage) {
            return BasicElementLabels.getResourceName(((IStorage)obj).getName());
        }
        return "";
    }

    public static String getElementLabel(IJavaElement element, long flags) {
        StringBuffer result = new StringBuffer();
        JavaElementLabelsCore.getElementLabel(element, flags, result);
        return Strings.markJavaElementLabelLTR(result.toString());
    }

    public static void getElementLabel(IJavaElement element, long flags, StringBuffer buffer) {
        new JavaElementLabelComposerCore(buffer).appendElementLabel(element, flags);
    }

    public static void getMethodLabel(IMethod method, long flags, StringBuffer buffer) {
        new JavaElementLabelComposerCore(buffer).appendMethodLabel(method, flags);
    }

    public static void getFieldLabel(IField field, long flags, StringBuffer buffer) {
        new JavaElementLabelComposerCore(buffer).appendFieldLabel(field, flags);
    }

    public static void getLocalVariableLabel(ILocalVariable localVariable, long flags, StringBuffer buffer) {
        new JavaElementLabelComposerCore(buffer).appendLocalVariableLabel(localVariable, flags);
    }

    public static void getInitializerLabel(IInitializer initializer, long flags, StringBuffer buffer) {
        new JavaElementLabelComposerCore(buffer).appendInitializerLabel(initializer, flags);
    }

    public static void getTypeLabel(IType type, long flags, StringBuffer buffer) {
        new JavaElementLabelComposerCore(buffer).appendTypeLabel(type, flags);
    }

    public static void getTypeParameterLabel(ITypeParameter typeParameter, long flags, StringBuffer buffer) {
        new JavaElementLabelComposerCore(buffer).appendTypeParameterLabel(typeParameter, flags);
    }

    public static void getDeclarationLabel(IJavaElement declaration, long flags, StringBuffer buffer) {
        new JavaElementLabelComposerCore(buffer).appendDeclarationLabel(declaration, flags);
    }

    public static void getClassFileLabel(IClassFile classFile, long flags, StringBuffer buffer) {
        new JavaElementLabelComposerCore(buffer).appendClassFileLabel(classFile, flags);
    }

    public static void getCompilationUnitLabel(ICompilationUnit cu, long flags, StringBuffer buffer) {
        new JavaElementLabelComposerCore(buffer).appendCompilationUnitLabel(cu, flags);
    }

    public static void getPackageFragmentLabel(IPackageFragment pack, long flags, StringBuffer buffer) {
        new JavaElementLabelComposerCore(buffer).appendPackageFragmentLabel(pack, flags);
    }

    public static void getPackageFragmentRootLabel(IPackageFragmentRoot root, long flags, StringBuffer buffer) {
        new JavaElementLabelComposerCore(buffer).appendPackageFragmentRootLabel(root, flags);
    }

    public static String getContainerEntryLabel(IPath containerPath, IJavaProject project) throws JavaModelException {
        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)project);
        if (container != null) {
            return Strings.markLTR(container.getDescription());
        }
        ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)containerPath.segment(0));
        if (initializer != null) {
            return Strings.markLTR(initializer.getDescription(containerPath, project));
        }
        return BasicElementLabels.getPathLabel(containerPath, false);
    }
}

