/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.pem;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.loader.pem.AbstractPEMResourceKeyPairParser;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.io.NoCloseInputStream;
import org.apache.sshd.common.util.io.der.ASN1Object;
import org.apache.sshd.common.util.io.der.ASN1Type;
import org.apache.sshd.common.util.io.der.DERParser;
import org.apache.sshd.common.util.security.SecurityUtils;

public class RSAPEMResourceKeyPairParser
extends AbstractPEMResourceKeyPairParser {
    public static final String BEGIN_MARKER = "BEGIN RSA PRIVATE KEY";
    public static final List<String> BEGINNERS = Collections.unmodifiableList(Collections.singletonList("BEGIN RSA PRIVATE KEY"));
    public static final String END_MARKER = "END RSA PRIVATE KEY";
    public static final List<String> ENDERS = Collections.unmodifiableList(Collections.singletonList("END RSA PRIVATE KEY"));
    public static final String RSA_OID = "1.2.840.113549.1.1.1";
    public static final RSAPEMResourceKeyPairParser INSTANCE = new RSAPEMResourceKeyPairParser();

    public RSAPEMResourceKeyPairParser() {
        super("RSA", RSA_OID, BEGINNERS, ENDERS);
    }

    @Override
    public Collection<KeyPair> extractKeyPairs(SessionContext session, NamedResource resourceKey, String beginMarker, String endMarker, FilePasswordProvider passwordProvider, InputStream stream) throws IOException, GeneralSecurityException {
        KeyPair kp = RSAPEMResourceKeyPairParser.decodeRSAKeyPair(SecurityUtils.getKeyFactory("RSA"), stream, false);
        return Collections.singletonList(kp);
    }

    public static KeyPair decodeRSAKeyPair(KeyFactory kf, InputStream s, boolean okToClose) throws IOException, GeneralSecurityException {
        ASN1Object sequence;
        try (DERParser parser = new DERParser(NoCloseInputStream.resolveInputStream(s, okToClose));){
            sequence = parser.readObject();
        }
        if (!ASN1Type.SEQUENCE.equals((Object)sequence.getObjType())) {
            throw new IOException("Invalid DER: not a sequence: " + (Object)((Object)sequence.getObjType()));
        }
        parser = sequence.createParser();
        var5_4 = null;
        try {
            ASN1Object versionObject = parser.readObject();
            if (versionObject == null) {
                throw new StreamCorruptedException("No version");
            }
            BigInteger version = versionObject.asInteger();
            if (!BigInteger.ZERO.equals(version)) {
                throw new StreamCorruptedException("Multi-primes N/A");
            }
            BigInteger modulus = parser.readObject().asInteger();
            BigInteger publicExp = parser.readObject().asInteger();
            PublicKey pubKey = kf.generatePublic(new RSAPublicKeySpec(modulus, publicExp));
            BigInteger privateExp = parser.readObject().asInteger();
            BigInteger primeP = parser.readObject().asInteger();
            BigInteger primeQ = parser.readObject().asInteger();
            BigInteger primeExponentP = parser.readObject().asInteger();
            BigInteger primeExponentQ = parser.readObject().asInteger();
            BigInteger crtCoef = parser.readObject().asInteger();
            RSAPrivateCrtKeySpec prvSpec = new RSAPrivateCrtKeySpec(modulus, publicExp, privateExp, primeP, primeQ, primeExponentP, primeExponentQ, crtCoef);
            PrivateKey prvKey = kf.generatePrivate(prvSpec);
            KeyPair keyPair = new KeyPair(pubKey, prvKey);
            return keyPair;
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        finally {
            if (parser != null) {
                if (var5_4 != null) {
                    try {
                        parser.close();
                    }
                    catch (Throwable throwable) {
                        var5_4.addSuppressed(throwable);
                    }
                } else {
                    parser.close();
                }
            }
        }
    }
}

