/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.gef;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeListener;

public class EditPartChangeCollector
implements EditPartListener,
NodeListener {
    private Set<EditPart> added = new HashSet<EditPart>();
    private Set<EditPart> removed = new HashSet<EditPart>();
    private Set<ConnectionEditPart> connectionAdded = new HashSet<ConnectionEditPart>();
    private Set<ConnectionEditPart> connectionRemoved = new HashSet<ConnectionEditPart>();
    private Set<EditPart> associatedWith = new HashSet<EditPart>();

    public void childAdded(EditPart child, int index) {
        EditPart e = child;
        boolean needAdd = true;
        while (e != null) {
            if (this.added.contains(e)) {
                needAdd = false;
            }
            e = e.getParent();
        }
        if (needAdd) {
            this.added.add(child);
        }
        this.associate(child);
    }

    public void partActivated(EditPart editpart) {
    }

    public void partDeactivated(EditPart editpart) {
    }

    public void removingChild(EditPart child, int index) {
        this.removed.add(child);
        this.deAssociate(child);
    }

    public void selectedStateChanged(EditPart editpart) {
    }

    public List<EditPart> getAddedParts() {
        return new ArrayList<EditPart>(this.added);
    }

    public void associate(EditPart p) {
        if (!this.associatedWith.contains(p)) {
            this.associatedWith.add(p);
            p.addEditPartListener((EditPartListener)this);
        }
        List children = p.getChildren();
        for (Object object : children) {
            if (!(object instanceof EditPart)) continue;
            this.associate((EditPart)object);
        }
        if (p instanceof GraphicalEditPart) {
            GraphicalEditPart gp = (GraphicalEditPart)p;
            gp.addNodeListener((NodeListener)this);
        }
    }

    private void deAssociate(EditPart p) {
        if (this.associatedWith.contains(p)) {
            this.associatedWith.add(p);
            p.removeEditPartListener((EditPartListener)this);
        }
        List children = p.getChildren();
        for (Object object : children) {
            if (!(object instanceof EditPart)) continue;
            this.deAssociate((EditPart)object);
        }
        if (p instanceof GraphicalEditPart) {
            GraphicalEditPart gp = (GraphicalEditPart)p;
            gp.removeNodeListener((NodeListener)this);
        }
    }

    public void deAssociate() {
        while (!this.associatedWith.isEmpty()) {
            EditPart next = this.associatedWith.iterator().next();
            this.associatedWith.remove(next);
            this.deAssociate(next);
        }
    }

    public void removingSourceConnection(ConnectionEditPart connection, int index) {
        this.connectionRemoved.add(connection);
    }

    public void removingTargetConnection(ConnectionEditPart connection, int index) {
        this.connectionRemoved.add(connection);
    }

    public void sourceConnectionAdded(ConnectionEditPart connection, int index) {
        this.connectionAdded.add(connection);
    }

    public void targetConnectionAdded(ConnectionEditPart connection, int index) {
        this.connectionAdded.add(connection);
    }

    public List<ConnectionEditPart> getAddedConnections() {
        return new ArrayList<ConnectionEditPart>(this.connectionAdded);
    }
}

