/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.ZipFile;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.hookregistry.ActivatorHookFactory;
import org.eclipse.osgi.internal.hookregistry.BundleFileWrapperFactoryHook;
import org.eclipse.osgi.internal.hookregistry.HookConfigurator;
import org.eclipse.osgi.internal.hookregistry.HookRegistry;
import org.eclipse.osgi.internal.service.security.KeyStoreTrustEngine;
import org.eclipse.osgi.internal.signedcontent.SignedBundleFile;
import org.eclipse.osgi.internal.signedcontent.SignedContentConstants;
import org.eclipse.osgi.internal.signedcontent.SignedContentFile;
import org.eclipse.osgi.internal.signedcontent.SignedContentImpl;
import org.eclipse.osgi.internal.signedcontent.SignedContentMessages;
import org.eclipse.osgi.internal.signedcontent.SignedStorageHook;
import org.eclipse.osgi.internal.signedcontent.SignerInfoImpl;
import org.eclipse.osgi.internal.signedcontent.TrustEngineListener;
import org.eclipse.osgi.service.security.TrustEngine;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.osgi.storage.bundlefile.BundleFileWrapper;
import org.eclipse.osgi.storage.bundlefile.DirBundleFile;
import org.eclipse.osgi.storage.bundlefile.ZipBundleFile;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class SignedBundleHook
implements ActivatorHookFactory,
BundleFileWrapperFactoryHook,
HookConfigurator,
SignedContentFactory {
    static final SecureAction secureAction = AccessController.doPrivileged(SecureAction.createSecureAction());
    static final int VERIFY_CERTIFICATE = 1;
    static final int VERIFY_TRUST = 2;
    static final int VERIFY_RUNTIME = 4;
    static final int VERIFY_ALL = 7;
    private static final String SUPPORT_CERTIFICATE = "certificate";
    private static final String SUPPORT_TRUST = "trust";
    private static final String SUPPORT_RUNTIME = "runtime";
    private static final String SUPPORT_ALL = "all";
    private static final String SUPPORT_TRUE = "true";
    private static final String CACERTS_PATH = String.valueOf(System.getProperty("java.home")) + File.separatorChar + "lib" + File.separatorChar + "security" + File.separatorChar + "cacerts";
    private static final String CACERTS_TYPE = "JKS";
    private static final String SIGNED_BUNDLE_SUPPORT = "osgi.support.signature.verify";
    private static final String SIGNED_CONTENT_SUPPORT = "osgi.signedcontent.support";
    private static final String OSGI_KEYSTORE = "osgi.framework.keystore";
    private int supportSignedBundles;
    TrustEngineListener trustEngineListener;
    private String trustEngineNameProp;
    private ServiceRegistration<?> signedContentFactoryReg;
    private ServiceRegistration<?> systemTrustEngineReg;
    private List<ServiceRegistration<?>> osgiTrustEngineReg;
    private ServiceTracker<TrustEngine, TrustEngine> trustEngineTracker;
    private BundleContext context;
    private EquinoxContainer container;

    @Override
    public BundleActivator createActivator() {
        return new BundleActivator(){

            @Override
            public void start(BundleContext bc) throws Exception {
                SignedBundleHook.this.frameworkStart(bc);
            }

            @Override
            public void stop(BundleContext bc) throws Exception {
                SignedBundleHook.this.frameworkStop(bc);
            }
        };
    }

    BundleContext getContext() {
        return this.context;
    }

    void frameworkStart(BundleContext bc) {
        this.context = bc;
        if ((this.supportSignedBundles & 2) != 0) {
            this.trustEngineListener = new TrustEngineListener(this.context, this);
        }
        Hashtable<String, Object> trustEngineProps = new Hashtable<String, Object>(7);
        ((Dictionary)trustEngineProps).put("service.ranking", Integer.MIN_VALUE);
        ((Dictionary)trustEngineProps).put("osgi.signedcontent.trust.engine", SignedContentConstants.DEFAULT_TRUST_ENGINE);
        KeyStoreTrustEngine systemTrustEngine = new KeyStoreTrustEngine(CACERTS_PATH, CACERTS_TYPE, null, "System", this);
        this.systemTrustEngineReg = this.context.registerService(TrustEngine.class.getName(), (Object)systemTrustEngine, trustEngineProps);
        String osgiTrustPath = this.context.getProperty(OSGI_KEYSTORE);
        if (osgiTrustPath != null) {
            try {
                URL url = new URL(osgiTrustPath);
                if ("file".equals(url.getProtocol())) {
                    ((Dictionary)trustEngineProps).put("osgi.signedcontent.trust.engine", OSGI_KEYSTORE);
                    String path = url.getPath();
                    this.osgiTrustEngineReg = new ArrayList(1);
                    this.osgiTrustEngineReg.add(this.context.registerService(TrustEngine.class.getName(), (Object)new KeyStoreTrustEngine(path, CACERTS_TYPE, null, OSGI_KEYSTORE, this), trustEngineProps));
                }
            }
            catch (MalformedURLException e) {
                this.log("Invalid setting for osgi.framework.keystore", 2, e);
            }
        } else {
            String osgiTrustRepoPaths = this.context.getProperty("org.osgi.framework.trust.repositories");
            if (osgiTrustRepoPaths != null) {
                ((Dictionary)trustEngineProps).put("osgi.signedcontent.trust.engine", "org.osgi.framework.trust.repositories");
                StringTokenizer st = new StringTokenizer(osgiTrustRepoPaths, File.pathSeparator);
                this.osgiTrustEngineReg = new ArrayList(1);
                while (st.hasMoreTokens()) {
                    String trustRepoPath = st.nextToken();
                    this.osgiTrustEngineReg.add(this.context.registerService(TrustEngine.class.getName(), (Object)new KeyStoreTrustEngine(trustRepoPath, CACERTS_TYPE, null, OSGI_KEYSTORE, this), trustEngineProps));
                }
            }
        }
        this.signedContentFactoryReg = this.context.registerService(SignedContentFactory.class.getName(), (Object)this, null);
    }

    void frameworkStop(BundleContext bc) {
        if (this.signedContentFactoryReg != null) {
            this.signedContentFactoryReg.unregister();
            this.signedContentFactoryReg = null;
        }
        if (this.systemTrustEngineReg != null) {
            this.systemTrustEngineReg.unregister();
            this.systemTrustEngineReg = null;
        }
        if (this.osgiTrustEngineReg != null) {
            Iterator<ServiceRegistration<?>> it = this.osgiTrustEngineReg.iterator();
            while (it.hasNext()) {
                it.next().unregister();
            }
            this.osgiTrustEngineReg = null;
        }
        if (this.trustEngineTracker != null) {
            this.trustEngineTracker.close();
            this.trustEngineTracker = null;
        }
    }

    @Override
    public BundleFileWrapper wrapBundleFile(BundleFile bundleFile, BundleInfo.Generation generation, boolean base) {
        try {
            if (bundleFile != null) {
                SignedContentImpl signedContent;
                SignedBundleFile signedBaseFile;
                SignedStorageHook.StorageHookImpl hook = (SignedStorageHook.StorageHookImpl)generation.getStorageHook(SignedStorageHook.class);
                if (base && hook != null) {
                    signedBaseFile = new SignedBundleFile(bundleFile, hook.signedContent, this.supportSignedBundles, this);
                    if (hook.signedContent == null) {
                        signedBaseFile.initializeSignedContent();
                        signedContent = signedBaseFile.getSignedContent();
                        hook.signedContent = signedContent != null && signedContent.isSigned() ? signedContent : null;
                    }
                } else {
                    signedBaseFile = new SignedBundleFile(bundleFile, null, this.supportSignedBundles, this);
                }
                signedBaseFile.initializeSignedContent();
                signedContent = signedBaseFile.getSignedContent();
                if (signedContent != null && signedContent.isSigned()) {
                    signedContent.setContent(signedBaseFile);
                    return new BundleFileWrapper(signedBaseFile);
                }
            }
        }
        catch (IOException e) {
            this.log("Bad bundle file: " + bundleFile.getBaseFile(), 2, e);
        }
        catch (GeneralSecurityException e) {
            this.log("Bad bundle file: " + bundleFile.getBaseFile(), 2, e);
        }
        return null;
    }

    @Override
    public void addHooks(HookRegistry hookRegistry) {
        this.container = hookRegistry.getContainer();
        hookRegistry.addActivatorHookFactory(this);
        String[] support = ManifestElement.getArrayFromList(hookRegistry.getConfiguration().getConfiguration(SIGNED_CONTENT_SUPPORT, hookRegistry.getConfiguration().getConfiguration(SIGNED_BUNDLE_SUPPORT)), ",");
        int i = 0;
        while (i < support.length) {
            if (SUPPORT_CERTIFICATE.equals(support[i])) {
                this.supportSignedBundles |= 1;
            } else if (SUPPORT_TRUST.equals(support[i])) {
                this.supportSignedBundles |= 3;
            } else if (SUPPORT_RUNTIME.equals(support[i])) {
                this.supportSignedBundles |= 5;
            } else if (SUPPORT_TRUE.equals(support[i]) || SUPPORT_ALL.equals(support[i])) {
                this.supportSignedBundles |= 7;
            }
            ++i;
        }
        this.trustEngineNameProp = hookRegistry.getConfiguration().getConfiguration("osgi.signedcontent.trust.engine");
        if ((this.supportSignedBundles & 1) != 0) {
            hookRegistry.addStorageHookFactory(new SignedStorageHook());
            hookRegistry.addBundleFileWrapperFactoryHook(this);
        }
    }

    @Override
    public SignedContent getSignedContent(File content) throws IOException, InvalidKeyException, SignatureException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        BundleFile contentBundleFile;
        if (content == null) {
            throw new IllegalArgumentException("null content");
        }
        if (content.isDirectory()) {
            contentBundleFile = new DirBundleFile(content, false);
        } else {
            ZipFile temp = secureAction.getZipFile(content);
            temp.close();
            contentBundleFile = new ZipBundleFile(content, null, null, this.container.getConfiguration().getDebug());
        }
        SignedBundleFile result = new SignedBundleFile(contentBundleFile, null, 7, this);
        try {
            result.initializeSignedContent();
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeyException(NLS.bind(SignedContentMessages.Factory_SignedContent_Error, content), e);
        }
        catch (SignatureException e) {
            throw new SignatureException(NLS.bind(SignedContentMessages.Factory_SignedContent_Error, content), e);
        }
        catch (CertificateException e) {
            throw new CertificateException(NLS.bind(SignedContentMessages.Factory_SignedContent_Error, content), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException(NLS.bind(SignedContentMessages.Factory_SignedContent_Error, content), e);
        }
        catch (NoSuchProviderException e) {
            throw (NoSuchProviderException)new NoSuchProviderException(NLS.bind(SignedContentMessages.Factory_SignedContent_Error, content)).initCause(e);
        }
        return new SignedContentFile(result.getSignedContent());
    }

    @Override
    public SignedContent getSignedContent(Bundle bundle) throws IOException, InvalidKeyException, SignatureException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException, IllegalArgumentException {
        SignedContentImpl result;
        final BundleInfo.Generation generation = (BundleInfo.Generation)((EquinoxBundle)bundle).getModule().getCurrentRevision().getRevisionInfo();
        SignedStorageHook.StorageHookImpl hook = (SignedStorageHook.StorageHookImpl)generation.getStorageHook(SignedStorageHook.class);
        SignedContentImpl signedContentImpl = result = hook != null ? hook.signedContent : null;
        if (result != null) {
            return result;
        }
        if (System.getSecurityManager() == null) {
            return this.getSignedContent(generation.getBundleFile().getBaseFile());
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<SignedContent>(){

                @Override
                public SignedContent run() throws Exception {
                    return SignedBundleHook.this.getSignedContent(generation.getBundleFile().getBaseFile());
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            if (e.getException() instanceof InvalidKeyException) {
                throw (InvalidKeyException)e.getException();
            }
            if (e.getException() instanceof SignatureException) {
                throw (SignatureException)e.getException();
            }
            if (e.getException() instanceof CertificateException) {
                throw (CertificateException)e.getException();
            }
            if (e.getException() instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)e.getException();
            }
            if (e.getException() instanceof NoSuchProviderException) {
                throw (NoSuchProviderException)e.getException();
            }
            throw new RuntimeException("Unknown error.", e.getException());
        }
    }

    public void log(String msg, int severity, Throwable t) {
        this.container.getLogServices().log("org.eclipse.osgi", severity, msg, t);
    }

    private TrustEngine[] getTrustEngines() {
        Object[] services;
        if (this.context == null) {
            return new TrustEngine[0];
        }
        if (this.trustEngineTracker == null) {
            Filter filter = null;
            if (this.trustEngineNameProp != null) {
                try {
                    filter = this.context.createFilter("(&(objectClass=" + TrustEngine.class.getName() + ")(" + "osgi.signedcontent.trust.engine" + "=" + this.trustEngineNameProp + "))");
                }
                catch (InvalidSyntaxException e) {
                    this.log("Invalid trust engine filter", 2, e);
                }
            }
            this.trustEngineTracker = filter != null ? new ServiceTracker<TrustEngine, TrustEngine>(this.context, filter, new TrustEngineCustomizer()) : new ServiceTracker<TrustEngine, TrustEngine>(this.context, TrustEngine.class.getName(), new TrustEngineCustomizer());
            this.trustEngineTracker.open();
        }
        if ((services = this.trustEngineTracker.getServices()) != null) {
            TrustEngine[] engines = new TrustEngine[services.length];
            System.arraycopy(services, 0, engines, 0, services.length);
            return engines;
        }
        return new TrustEngine[0];
    }

    void determineTrust(SignedContentImpl trustedContent, int supportFlags) {
        TrustEngine[] engines = null;
        SignerInfo[] signers = trustedContent.getSignerInfos();
        int i = 0;
        while (i < signers.length) {
            if (signers[i].getTrustAnchor() == null) {
                if (engines == null) {
                    engines = this.getTrustEngines();
                }
                Certificate[] signerCerts = signers[i].getCertificateChain();
                ((SignerInfoImpl)signers[i]).setTrustAnchor(this.findTrustAnchor(signerCerts, engines, supportFlags));
                SignerInfo tsaSignerInfo = trustedContent.getTSASignerInfo(signers[i]);
                if (tsaSignerInfo != null) {
                    Certificate[] tsaCerts = tsaSignerInfo.getCertificateChain();
                    ((SignerInfoImpl)tsaSignerInfo).setTrustAnchor(this.findTrustAnchor(tsaCerts, engines, supportFlags));
                }
            }
            ++i;
        }
    }

    private Certificate findTrustAnchor(Certificate[] certs, TrustEngine[] engines, int supportFlags) {
        if ((supportFlags & 2) == 0) {
            return certs != null && certs.length > 0 ? certs[certs.length - 1] : null;
        }
        int i = 0;
        while (i < engines.length) {
            try {
                Certificate anchor = engines[i].findTrustAnchor(certs);
                if (anchor != null) {
                    return anchor;
                }
            }
            catch (IOException e) {
                this.log("TrustEngine failure: " + engines[i].getName(), 2, e);
            }
            ++i;
        }
        return null;
    }

    class TrustEngineCustomizer
    implements ServiceTrackerCustomizer<TrustEngine, TrustEngine> {
        TrustEngineCustomizer() {
        }

        @Override
        public TrustEngine addingService(ServiceReference<TrustEngine> reference) {
            TrustEngine engine = SignedBundleHook.this.getContext().getService(reference);
            if (engine != null) {
                try {
                    Field trustEngineListenerField = TrustEngine.class.getDeclaredField("trustEngineListener");
                    trustEngineListenerField.setAccessible(true);
                    trustEngineListenerField.set(engine, SignedBundleHook.this.trustEngineListener);
                }
                catch (Exception e) {
                    SignedBundleHook.this.log("Unable to set the trust engine listener.", 4, e);
                }
            }
            return engine;
        }

        @Override
        public void modifiedService(ServiceReference<TrustEngine> reference, TrustEngine service) {
        }

        @Override
        public void removedService(ServiceReference<TrustEngine> reference, TrustEngine service) {
        }
    }
}

