/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.data;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetManager;
import org.eclipse.ui.internal.cheatsheets.views.CoreItem;
import org.eclipse.ui.internal.cheatsheets.views.SubItemCompositeHolder;
import org.eclipse.ui.internal.cheatsheets.views.ViewItem;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.InputSource;

public class CheatSheetSaveHelper {
    protected IPath savePath = CheatSheetPlugin.getPlugin().getStateLocation();
    private static final String DOT_XML = ".xml";

    public Properties createProperties(int currentItemNum, ArrayList<ViewItem> items, boolean buttonIsDown, ArrayList expandRestoreStates, String csID, String contentPath) {
        Properties props = new Properties();
        Hashtable<String, String> subcompletedTable = new Hashtable<String, String>(10);
        Hashtable<String, String> subskippedTable = new Hashtable<String, String>(10);
        int buttonState = 0;
        if (buttonIsDown) {
            buttonState = 1;
        }
        props.put("id", csID);
        props.put("current", Integer.toString(currentItemNum));
        if (contentPath != null) {
            props.put("contentURL", contentPath);
        }
        ArrayList<String> completedList = new ArrayList<String>();
        ArrayList<String> expandedList = new ArrayList<String>();
        if (expandRestoreStates == null) {
            expandRestoreStates = new ArrayList();
        }
        int i = 0;
        while (i < items.size()) {
            CoreItem withsubs;
            ArrayList<SubItemCompositeHolder> compList;
            ViewItem item = items.get(i);
            if (item.isCompleted()) {
                completedList.add(Integer.toString(i));
            }
            if (item.isExpanded()) {
                expandedList.add(Integer.toString(i));
            }
            if (item instanceof CoreItem && (compList = (withsubs = (CoreItem)item).getListOfSubItemCompositeHolders()) != null) {
                StringBuilder skippedsubItems = new StringBuilder();
                StringBuilder completedsubItems = new StringBuilder();
                int j = 0;
                while (j < compList.size()) {
                    SubItemCompositeHolder sch = compList.get(j);
                    if (sch.isCompleted()) {
                        completedsubItems.append(String.valueOf(Integer.toString(j)) + ",");
                    }
                    if (sch.isSkipped()) {
                        skippedsubItems.append(String.valueOf(Integer.toString(j)) + ",");
                    }
                    ++j;
                }
                if (completedsubItems.toString().length() > 0) {
                    String csi = completedsubItems.toString();
                    if (csi.endsWith(",")) {
                        csi = csi.substring(0, csi.length() - 1);
                    }
                    subcompletedTable.put(Integer.toString(i), csi);
                }
                if (skippedsubItems.toString().length() > 0) {
                    String csi = skippedsubItems.toString();
                    if (csi.endsWith(",")) {
                        csi = csi.substring(0, csi.length() - 1);
                    }
                    subskippedTable.put(Integer.toString(i), csi);
                }
            }
            ++i;
        }
        props.put("completed", completedList);
        props.put("expanded", expandedList);
        props.put("expandRestore", expandRestoreStates);
        props.put("button", Integer.toString(buttonState));
        if (subcompletedTable != null) {
            props.put("subitemcompleted", subcompletedTable);
        }
        if (subskippedTable != null) {
            props.put("subitemskipped", subskippedTable);
        }
        return props;
    }

    protected String getAttributeWithName(NamedNodeMap map, String name) {
        try {
            return map.getNamedItem(name).getNodeValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Path getStateFile(String csID) {
        return this.getStateFile(csID, this.savePath);
    }

    protected Path getStateFile(String csID, IPath rootPath) {
        return new Path(rootPath.append(String.valueOf(csID) + DOT_XML).toOSString());
    }

    /*
     * Loose catch block
     */
    protected Document readXMLFile(URL url) {
        InputStream is = null;
        InputSource source = null;
        try {
            is = url.openStream();
            if (is != null) {
                source = new InputSource(is);
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (source == null) {
            return null;
        }
        DocumentBuilder documentBuilder = CheatSheetPlugin.getPlugin().getDocumentBuilder();
        Document document = documentBuilder.parse(source);
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {}
        return document;
        catch (Exception exception) {
            try {}
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public IStatus saveState(Properties properties, CheatSheetManager csm) {
        String csID = (String)properties.get("id");
        XMLMemento writeMemento = XMLMemento.createWriteRoot((String)"cheatsheetState");
        IStatus status = this.saveToMemento(properties, csm, (IMemento)writeMemento);
        if (!status.isOK()) {
            return status;
        }
        return CheatSheetPlugin.getPlugin().saveMemento(writeMemento, String.valueOf(csID) + DOT_XML);
    }

    public IStatus saveToMemento(Properties properties, CheatSheetManager csm, IMemento writeMemento) {
        String csID = (String)properties.get("id");
        try {
            writeMemento.putString("buttonstate", (String)properties.get("button"));
            writeMemento.putString("item", (String)properties.get("current"));
            writeMemento.putString("id", (String)properties.get("id"));
            String contentPath = (String)properties.get("contentURL");
            if (contentPath != null) {
                writeMemento.putString("contentURL", contentPath);
            }
            this.addListOfStringsToMemento(writeMemento, properties, "completed");
            this.addListOfStringsToMemento(writeMemento, properties, "expanded");
            this.addListOfStringsToMemento(writeMemento, properties, "expandRestore");
            this.addMapToMemento(writeMemento, csm.getData(), "CSMData");
            this.addMapToMemento(writeMemento, (Map)properties.get("subitemcompleted"), "subitemcompleted");
            this.addMapToMemento(writeMemento, (Map)properties.get("subitemskipped"), "subitemskipped");
        }
        catch (Exception e) {
            String message = NLS.bind((String)Messages.ERROR_SAVING_STATEFILE_URL, (Object[])new Object[]{csID});
            Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
            return status;
        }
        return Status.OK_STATUS;
    }

    public Properties loadState(String csID) {
        XMLMemento readMemento = CheatSheetPlugin.getPlugin().readMemento(String.valueOf(csID) + DOT_XML);
        if (readMemento == null) {
            return null;
        }
        return this.loadFromMemento((IMemento)readMemento);
    }

    public Properties loadFromMemento(IMemento memento) {
        Properties properties = new Properties();
        properties.put("button", memento.getString("buttonstate"));
        properties.put("current", memento.getString("item"));
        properties.put("id", memento.getString("id"));
        String contentURL = memento.getString("contentURL");
        if (contentURL != null) {
            properties.put("contentURL", contentURL);
        }
        this.getListOfStringsFromMemento(memento, properties, "completed");
        this.getListOfStringsFromMemento(memento, properties, "expanded");
        this.getListOfStringsFromMemento(memento, properties, "expandRestore");
        this.getMapFromMemento(memento, properties, "subitemcompleted");
        this.getMapFromMemento(memento, properties, "subitemskipped");
        this.getMapFromMemento(memento, properties, "CSMData");
        return properties;
    }

    private void addListOfStringsToMemento(IMemento memento, Properties properties, String key) {
        List list = (List)properties.get(key);
        if (list == null) {
            return;
        }
        for (String string : list) {
            IMemento childMemento = memento.createChild(key);
            childMemento.putString("item", string);
        }
    }

    private void addMapToMemento(IMemento memento, Map<String, String> map, String mapName) {
        if (map == null) {
            return;
        }
        for (String itemKey : map.keySet()) {
            IMemento childMemento = memento.createChild(mapName);
            childMemento.putString("key", itemKey);
            childMemento.putString("value", map.get(itemKey));
        }
    }

    private void getMapFromMemento(IMemento memento, Properties properties, String mapName) {
        IMemento[] children = memento.getChildren(mapName);
        Hashtable<String, String> map = new Hashtable<String, String>();
        IMemento[] iMementoArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento element = iMementoArray[n2];
            map.put(element.getString("key"), element.getString("value"));
            ++n2;
        }
        properties.put(mapName, map);
    }

    private void getListOfStringsFromMemento(IMemento memento, Properties properties, String key) {
        IMemento[] children = memento.getChildren(key);
        ArrayList<String> list = new ArrayList<String>();
        IMemento[] iMementoArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento element = iMementoArray[n2];
            list.add(element.getString("item"));
            ++n2;
        }
        properties.put(key, list);
    }
}

