/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.subsystem.sftp;

import java.util.Collections;
import java.util.Map;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.LoggingUtils;

public final class SftpConstants {
    public static final String SFTP_SUBSYSTEM_NAME = "sftp";
    public static final int SSH_FXP_INIT = 1;
    public static final int SSH_FXP_VERSION = 2;
    public static final int SSH_FXP_OPEN = 3;
    public static final int SSH_FXP_CLOSE = 4;
    public static final int SSH_FXP_READ = 5;
    public static final int SSH_FXP_WRITE = 6;
    public static final int SSH_FXP_LSTAT = 7;
    public static final int SSH_FXP_FSTAT = 8;
    public static final int SSH_FXP_SETSTAT = 9;
    public static final int SSH_FXP_FSETSTAT = 10;
    public static final int SSH_FXP_OPENDIR = 11;
    public static final int SSH_FXP_READDIR = 12;
    public static final int SSH_FXP_REMOVE = 13;
    public static final int SSH_FXP_MKDIR = 14;
    public static final int SSH_FXP_RMDIR = 15;
    public static final int SSH_FXP_REALPATH = 16;
    public static final int SSH_FXP_STAT = 17;
    public static final int SSH_FXP_RENAME = 18;
    public static final int SSH_FXP_READLINK = 19;
    public static final int SSH_FXP_SYMLINK = 20;
    public static final int SSH_FXP_LINK = 21;
    public static final int SSH_FXP_BLOCK = 22;
    public static final int SSH_FXP_UNBLOCK = 23;
    public static final int SSH_FXP_STATUS = 101;
    public static final int SSH_FXP_HANDLE = 102;
    public static final int SSH_FXP_DATA = 103;
    public static final int SSH_FXP_NAME = 104;
    public static final int SSH_FXP_ATTRS = 105;
    public static final int SSH_FXP_EXTENDED = 200;
    public static final int SSH_FXP_EXTENDED_REPLY = 201;
    public static final int SSH_FX_OK = 0;
    public static final int SSH_FX_EOF = 1;
    public static final int SSH_FX_NO_SUCH_FILE = 2;
    public static final int SSH_FX_PERMISSION_DENIED = 3;
    public static final int SSH_FX_FAILURE = 4;
    public static final int SSH_FX_BAD_MESSAGE = 5;
    public static final int SSH_FX_NO_CONNECTION = 6;
    public static final int SSH_FX_CONNECTION_LOST = 7;
    public static final int SSH_FX_OP_UNSUPPORTED = 8;
    public static final int SSH_FX_INVALID_HANDLE = 9;
    public static final int SSH_FX_NO_SUCH_PATH = 10;
    public static final int SSH_FX_FILE_ALREADY_EXISTS = 11;
    public static final int SSH_FX_WRITE_PROTECT = 12;
    public static final int SSH_FX_NO_MEDIA = 13;
    public static final int SSH_FX_NO_SPACE_ON_FILESYSTEM = 14;
    public static final int SSH_FX_QUOTA_EXCEEDED = 15;
    public static final int SSH_FX_UNKNOWN_PRINCIPAL = 16;
    public static final int SSH_FX_LOCK_CONFLICT = 17;
    public static final int SSH_FX_DIR_NOT_EMPTY = 18;
    public static final int SSH_FX_NOT_A_DIRECTORY = 19;
    public static final int SSH_FX_INVALID_FILENAME = 20;
    public static final int SSH_FX_LINK_LOOP = 21;
    public static final int SSH_FX_CANNOT_DELETE = 22;
    public static final int SSH_FX_INVALID_PARAMETER = 23;
    public static final int SSH_FX_FILE_IS_A_DIRECTORY = 24;
    public static final int SSH_FX_BYTE_RANGE_LOCK_CONFLICT = 25;
    public static final int SSH_FX_BYTE_RANGE_LOCK_REFUSED = 26;
    public static final int SSH_FX_DELETE_PENDING = 27;
    public static final int SSH_FX_FILE_CORRUPT = 28;
    public static final int SSH_FX_OWNER_INVALID = 29;
    public static final int SSH_FX_GROUP_INVALID = 30;
    public static final int SSH_FX_NO_MATCHING_BYTE_RANGE_LOCK = 31;
    public static final int SSH_FILEXFER_ATTR_SIZE = 1;
    public static final int SSH_FILEXFER_ATTR_UIDGID = 2;
    public static final int SSH_FILEXFER_ATTR_PERMISSIONS = 4;
    public static final int SSH_FILEXFER_ATTR_ACMODTIME = 8;
    public static final int SSH_FILEXFER_ATTR_ACCESSTIME = 8;
    public static final int SSH_FILEXFER_ATTR_CREATETIME = 16;
    public static final int SSH_FILEXFER_ATTR_MODIFYTIME = 32;
    public static final int SSH_FILEXFER_ATTR_ACL = 64;
    public static final int SSH_FILEXFER_ATTR_OWNERGROUP = 128;
    public static final int SSH_FILEXFER_ATTR_SUBSECOND_TIMES = 256;
    public static final int SSH_FILEXFER_ATTR_BITS = 512;
    public static final int SSH_FILEXFER_ATTR_ALLOCATION_SIZE = 1024;
    public static final int SSH_FILEXFER_ATTR_TEXT_HINT = 2048;
    public static final int SSH_FILEXFER_ATTR_MIME_TYPE = 4096;
    public static final int SSH_FILEXFER_ATTR_LINK_COUNT = 8192;
    public static final int SSH_FILEXFER_ATTR_UNTRANSLATED_NAME = 16384;
    public static final int SSH_FILEXFER_ATTR_CTIME = 32768;
    public static final int SSH_FILEXFER_ATTR_EXTENDED = Integer.MIN_VALUE;
    public static final int SSH_FILEXFER_ATTR_ALL = 65535;
    public static final int SSH_FILEXFER_ATTR_FLAGS_READONLY = 1;
    public static final int SSH_FILEXFER_ATTR_FLAGS_SYSTEM = 2;
    public static final int SSH_FILEXFER_ATTR_FLAGS_HIDDEN = 4;
    public static final int SSH_FILEXFER_ATTR_FLAGS_CASE_INSENSITIVE = 8;
    public static final int SSH_FILEXFER_ATTR_FLAGS_ARCHIVE = 16;
    public static final int SSH_FILEXFER_ATTR_FLAGS_ENCRYPTED = 32;
    public static final int SSH_FILEXFER_ATTR_FLAGS_COMPRESSED = 64;
    public static final int SSH_FILEXFER_ATTR_FLAGS_SPARSE = 128;
    public static final int SSH_FILEXFER_ATTR_FLAGS_APPEND_ONLY = 256;
    public static final int SSH_FILEXFER_ATTR_FLAGS_IMMUTABLE = 512;
    public static final int SSH_FILEXFER_ATTR_FLAGS_SYNC = 1024;
    public static final int SSH_FILEXFER_TYPE_REGULAR = 1;
    public static final int SSH_FILEXFER_TYPE_DIRECTORY = 2;
    public static final int SSH_FILEXFER_TYPE_SYMLINK = 3;
    public static final int SSH_FILEXFER_TYPE_SPECIAL = 4;
    public static final int SSH_FILEXFER_TYPE_UNKNOWN = 5;
    public static final int SSH_FILEXFER_TYPE_SOCKET = 6;
    public static final int SSH_FILEXFER_TYPE_CHAR_DEVICE = 7;
    public static final int SSH_FILEXFER_TYPE_BLOCK_DEVICE = 8;
    public static final int SSH_FILEXFER_TYPE_FIFO = 9;
    public static final int SSH_FXF_READ = 1;
    public static final int SSH_FXF_WRITE = 2;
    public static final int SSH_FXF_APPEND = 4;
    public static final int SSH_FXF_CREAT = 8;
    public static final int SSH_FXF_TRUNC = 16;
    public static final int SSH_FXF_EXCL = 32;
    public static final int SSH_FXF_TEXT = 64;
    public static final int SSH_FXF_ACCESS_DISPOSITION = 7;
    public static final int SSH_FXF_CREATE_NEW = 0;
    public static final int SSH_FXF_CREATE_TRUNCATE = 1;
    public static final int SSH_FXF_OPEN_EXISTING = 2;
    public static final int SSH_FXF_OPEN_OR_CREATE = 3;
    public static final int SSH_FXF_TRUNCATE_EXISTING = 4;
    public static final int SSH_FXF_APPEND_DATA = 8;
    public static final int SSH_FXF_APPEND_DATA_ATOMIC = 16;
    public static final int SSH_FXF_TEXT_MODE = 32;
    public static final int SSH_FXF_READ_LOCK = 64;
    public static final int SSH_FXF_WRITE_LOCK = 128;
    public static final int SSH_FXF_DELETE_LOCK = 256;
    public static final int SSH_FXF_BLOCK_ADVISORY = 512;
    public static final int SSH_FXF_NOFOLLOW = 1024;
    public static final int SSH_FXF_DELETE_ON_CLOSE = 2048;
    public static final int SSH_FXF_ACCESS_AUDIT_ALARM_INFO = 4096;
    public static final int SSH_FXF_ACCESS_BACKUP = 8192;
    public static final int SSH_FXF_BACKUP_STREAM = 16384;
    public static final int SSH_FXF_OVERRIDE_OWNER = 32768;
    public static final int SSH_FXP_RENAME_OVERWRITE = 1;
    public static final int SSH_FXP_RENAME_ATOMIC = 2;
    public static final int SSH_FXP_RENAME_NATIVE = 4;
    public static final int SSH_FXP_REALPATH_NO_CHECK = 1;
    public static final int SSH_FXP_REALPATH_STAT_IF = 2;
    public static final int SSH_FXP_REALPATH_STAT_ALWAYS = 3;
    public static final int SSH_FXF_RENAME_OVERWRITE = 1;
    public static final int SSH_FXF_RENAME_ATOMIC = 2;
    public static final int SSH_FXF_RENAME_NATIVE = 4;
    public static final int SFX_ACL_CONTROL_INCLUDED = 1;
    public static final int SFX_ACL_CONTROL_PRESENT = 2;
    public static final int SFX_ACL_CONTROL_INHERITED = 4;
    public static final int SFX_ACL_AUDIT_ALARM_INCLUDED = 16;
    public static final int SFX_ACL_AUDIT_ALARM_INHERITED = 32;
    public static final int ACE4_ACCESS_ALLOWED_ACE_TYPE = 0;
    public static final int ACE4_ACCESS_DENIED_ACE_TYPE = 1;
    public static final int ACE4_SYSTEM_AUDIT_ACE_TYPE = 2;
    public static final int ACE4_SYSTEM_ALARM_ACE_TYPE = 3;
    public static final int ACE4_FILE_INHERIT_ACE = 1;
    public static final int ACE4_DIRECTORY_INHERIT_ACE = 2;
    public static final int ACE4_NO_PROPAGATE_INHERIT_ACE = 4;
    public static final int ACE4_INHERIT_ONLY_ACE = 8;
    public static final int ACE4_SUCCESSFUL_ACCESS_ACE_FLAG = 16;
    public static final int ACE4_FAILED_ACCESS_ACE_FLAG = 32;
    public static final int ACE4_IDENTIFIER_GROUP = 64;
    public static final int ACE4_READ_DATA = 1;
    public static final int ACE4_LIST_DIRECTORY = 1;
    public static final int ACE4_WRITE_DATA = 2;
    public static final int ACE4_ADD_FILE = 2;
    public static final int ACE4_APPEND_DATA = 4;
    public static final int ACE4_ADD_SUBDIRECTORY = 4;
    public static final int ACE4_READ_NAMED_ATTRS = 8;
    public static final int ACE4_WRITE_NAMED_ATTRS = 16;
    public static final int ACE4_EXECUTE = 32;
    public static final int ACE4_DELETE_CHILD = 64;
    public static final int ACE4_READ_ATTRIBUTES = 128;
    public static final int ACE4_WRITE_ATTRIBUTES = 256;
    public static final int ACE4_DELETE = 65536;
    public static final int ACE4_READ_ACL = 131072;
    public static final int ACE4_WRITE_ACL = 262144;
    public static final int ACE4_WRITE_OWNER = 524288;
    public static final int ACE4_SYNCHRONIZE = 0x100000;
    public static final int S_IFMT = 61440;
    public static final int S_IFSOCK = 49152;
    public static final int S_IFLNK = 40960;
    public static final int S_IFREG = 32768;
    public static final int S_IFBLK = 24576;
    public static final int S_IFDIR = 16384;
    public static final int S_IFCHR = 8192;
    public static final int S_IFIFO = 4096;
    public static final int S_ISUID = 2048;
    public static final int S_ISGID = 1024;
    public static final int S_ISVTX = 512;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;
    public static final int SFTP_V3 = 3;
    public static final int SFTP_V4 = 4;
    public static final int SFTP_V5 = 5;
    public static final int SFTP_V6 = 6;
    public static final String EXT_VERSIONS = "versions";
    public static final String EXT_NEWLINE = "newline";
    public static final String EXT_VENDOR_ID = "vendor-id";
    public static final String EXT_SUPPORTED = "supported";
    public static final String EXT_SUPPORTED2 = "supported2";
    public static final String EXT_TEXT_SEEK = "text-seek";
    public static final String EXT_VERSION_SELECT = "version-select";
    public static final String EXT_COPY_FILE = "copy-file";
    public static final String EXT_MD5_HASH = "md5-hash";
    public static final String EXT_MD5_HASH_HANDLE = "md5-hash-handle";
    public static final int MD5_QUICK_HASH_SIZE = 2048;
    public static final String EXT_CHECK_FILE_HANDLE = "check-file-handle";
    public static final String EXT_CHECK_FILE_NAME = "check-file-name";
    public static final int MIN_CHKFILE_BLOCKSIZE = 256;
    public static final String EXT_CHECK_FILE = "check-file";
    public static final String EXT_COPY_DATA = "copy-data";
    public static final String EXT_SPACE_AVAILABLE = "space-available";
    public static final String EXT_ACL_SUPPORTED = "acl-supported";
    public static final int SSH_ACL_CAP_ALLOW = 1;
    public static final int SSH_ACL_CAP_DENY = 2;
    public static final int SSH_ACL_CAP_AUDIT = 4;
    public static final int SSH_ACL_CAP_ALARM = 8;
    public static final int SSH_ACL_CAP_INHERIT_ACCESS = 16;
    public static final int SSH_ACL_CAP_INHERIT_AUDIT_ALARM = 32;

    private SftpConstants() {
        throw new UnsupportedOperationException("No instance");
    }

    public static String getCommandMessageName(int cmd) {
        String name = (String)LazyCommandNameHolder.NAMES_MAP.get(cmd);
        if (GenericUtils.isEmpty((CharSequence)name)) {
            return Integer.toString(cmd);
        }
        return name;
    }

    public static String getStatusName(int status) {
        String name = (String)LazyStatusNameHolder.STATUS_MAP.get(status);
        if (GenericUtils.isEmpty((CharSequence)name)) {
            return Integer.toString(status);
        }
        return name;
    }

    private static class LazyCommandNameHolder {
        private static final Map<Integer, String> NAMES_MAP = Collections.unmodifiableMap(LoggingUtils.generateMnemonicMap(SftpConstants.class, f -> {
            String name = f.getName();
            return name.startsWith("SSH_FXP_") && !name.startsWith("SSH_FXP_RENAME_") && !name.startsWith("SSH_FXP_REALPATH_");
        }));

        private LazyCommandNameHolder() {
        }
    }

    private static class LazyStatusNameHolder {
        private static final Map<Integer, String> STATUS_MAP = Collections.unmodifiableMap(LoggingUtils.generateMnemonicMap(SftpConstants.class, (String)"SSH_FX_"));

        private LazyStatusNameHolder() {
        }
    }
}

