/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source.inlined;

import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.inlined.AbstractInlinedAnnotation;
import org.eclipse.jface.text.source.inlined.LineContentAnnotation;
import org.eclipse.jface.text.source.inlined.LineHeaderAnnotation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

class InlinedAnnotationDrawingStrategy
implements AnnotationPainter.IDrawingStrategy {
    InlinedAnnotationDrawingStrategy() {
    }

    @Override
    public void draw(Annotation annotation, GC gc, StyledText textWidget, int widgetoffset, int length, Color color) {
        if (!(annotation instanceof AbstractInlinedAnnotation)) {
            return;
        }
        if (!((AbstractInlinedAnnotation)annotation).isInVisibleLines()) {
            return;
        }
        InlinedAnnotationDrawingStrategy.draw((AbstractInlinedAnnotation)annotation, gc, textWidget, widgetoffset, length, color);
    }

    public static void draw(AbstractInlinedAnnotation annotation, GC gc, StyledText textWidget, int widgetOffset, int length, Color color) {
        if (annotation instanceof LineHeaderAnnotation) {
            InlinedAnnotationDrawingStrategy.draw((LineHeaderAnnotation)annotation, gc, textWidget, widgetOffset, length, color);
        } else {
            InlinedAnnotationDrawingStrategy.draw((LineContentAnnotation)annotation, gc, textWidget, widgetOffset, length, color);
        }
    }

    private static void draw(LineHeaderAnnotation annotation, GC gc, StyledText textWidget, int offset, int length, Color color) {
        int line = textWidget.getLineAtOffset(offset);
        if (InlinedAnnotationDrawingStrategy.isDeleted(annotation)) {
            if (textWidget.getLineVerticalIndent(line) > 0) {
                textWidget.setLineVerticalIndent(line, 0);
            }
            return;
        }
        if (gc != null) {
            Rectangle bounds = textWidget.getTextBounds(offset, offset);
            int x = bounds.x;
            int y = bounds.y;
            gc.setBackground(textWidget.getBackground());
            annotation.setLocation(x, y);
            annotation.draw(gc, textWidget, offset, length, color, x, y);
            int height = annotation.getHeight();
            if (height != 0) {
                if (height != textWidget.getLineVerticalIndent(line)) {
                    if (annotation.oldLine != -1 && annotation.oldLine < textWidget.getLineCount()) {
                        textWidget.setLineVerticalIndent(annotation.oldLine, 0);
                    }
                    textWidget.setLineVerticalIndent(line, height);
                }
                annotation.oldLine = line;
                return;
            }
            if (textWidget.getLineVerticalIndent(line) > 0) {
                textWidget.setLineVerticalIndent(line, 0);
            }
        } else if (textWidget.getLineVerticalIndent(line) > 0) {
            Rectangle bounds = textWidget.getTextBounds(offset, offset);
            Rectangle client = textWidget.getClientArea();
            textWidget.redraw(0, bounds.y, client.width, bounds.height, false);
        } else {
            textWidget.redrawRange(offset, length, true);
        }
    }

    private static void draw(LineContentAnnotation annotation, GC gc, StyledText textWidget, int widgetOffset, int length, Color color) {
        if (annotation.drawRightToPreviousChar(widgetOffset)) {
            InlinedAnnotationDrawingStrategy.drawAsRightOfPreviousCharacter(annotation, gc, textWidget, widgetOffset, length, color);
        } else {
            InlinedAnnotationDrawingStrategy.drawAsLeftOf1stCharacter(annotation, gc, textWidget, widgetOffset, length, color);
        }
    }

    protected static void drawAsLeftOf1stCharacter(LineContentAnnotation annotation, GC gc, StyledText textWidget, int widgetOffset, int length, Color color) {
        StyleRange style = null;
        try {
            style = textWidget.getStyleRangeAtOffset(widgetOffset);
        }
        catch (Exception exception) {
            return;
        }
        if (InlinedAnnotationDrawingStrategy.isDeleted(annotation)) {
            if (style != null && style.metrics != null) {
                style.metrics = null;
                textWidget.setStyleRange(style);
            }
            return;
        }
        if (gc != null) {
            String s = textWidget.getText(widgetOffset, widgetOffset);
            boolean isEndOfLine = "\r".equals(s) || "\n".equals(s);
            Rectangle bounds = textWidget.getTextBounds(widgetOffset, widgetOffset);
            int x = bounds.x + (isEndOfLine ? bounds.width * 2 : 0);
            int y = bounds.y;
            annotation.setLocation(x, y += bounds.height - textWidget.getLineHeight());
            annotation.draw(gc, textWidget, widgetOffset, length, color, x, y);
            int width = annotation.getWidth();
            if (width != 0) {
                if (isEndOfLine) {
                    if (!gc.getClipping().contains(x, y)) {
                        Rectangle client = textWidget.getClientArea();
                        textWidget.redraw(x, y, client.width, bounds.height, false);
                    }
                } else {
                    Point charBounds = gc.stringExtent(s);
                    int charWidth = charBounds.x;
                    annotation.setRedrawnCharacterWidth(charWidth);
                    StyleRange newStyle = annotation.updateStyle(style);
                    if (newStyle != null) {
                        textWidget.setStyleRange(newStyle);
                        return;
                    }
                    int charX = x + bounds.width - charWidth;
                    int charY = y;
                    if (style != null) {
                        if (style.background != null) {
                            gc.setBackground(style.background);
                            gc.fillRectangle(charX, charY, charWidth + 1, bounds.height);
                        }
                        if (style.foreground != null) {
                            gc.setForeground(style.foreground);
                        } else {
                            gc.setForeground(textWidget.getForeground());
                        }
                        gc.setFont(annotation.getFont(style.fontStyle));
                    }
                    gc.drawString(s, charX, charY, true);
                }
            } else if (style != null && style.metrics != null && style.metrics.width != 0) {
                style.metrics = null;
                textWidget.setStyleRange(style);
            }
        } else {
            textWidget.redrawRange(widgetOffset, length, true);
        }
    }

    protected static void drawAsRightOfPreviousCharacter(LineContentAnnotation annotation, GC gc, StyledText textWidget, int offset, int length, Color color) {
        StyleRange style = null;
        try {
            style = textWidget.getStyleRangeAtOffset(offset - 1);
        }
        catch (Exception exception) {
            return;
        }
        if (InlinedAnnotationDrawingStrategy.isDeleted(annotation)) {
            if (style != null && style.metrics != null) {
                style.metrics = null;
                textWidget.setStyleRange(style);
            }
            return;
        }
        if (gc != null) {
            String s = textWidget.getText(offset - 1, offset - 1);
            int charWidth = gc.stringExtent((String)s).x;
            Rectangle charBounds = textWidget.getTextBounds(offset - 1, offset - 1);
            Rectangle annotationBounds = new Rectangle(charBounds.x + charWidth, charBounds.y, annotation.getWidth(), charBounds.height);
            annotationBounds.y += charBounds.height - textWidget.getLineHeight();
            annotation.setLocation(annotationBounds.x, annotationBounds.y);
            annotation.draw(gc, textWidget, offset, length, color, annotationBounds.x, annotationBounds.y);
            int width = annotation.getWidth();
            if (width != 0) {
                annotation.setRedrawnCharacterWidth(charWidth);
                StyleRange newStyle = annotation.updateStyle(style);
                if (newStyle != null) {
                    textWidget.setStyleRange(newStyle);
                    return;
                }
                if (style != null) {
                    if (style.background != null) {
                        gc.setBackground(style.background);
                        gc.fillRectangle(charBounds.x, charBounds.y, charWidth, charBounds.height);
                    }
                    if (style.foreground != null) {
                        gc.setForeground(style.foreground);
                    } else {
                        gc.setForeground(textWidget.getForeground());
                    }
                    gc.setFont(annotation.getFont(style.fontStyle));
                }
                gc.drawString(s, charBounds.x, charBounds.y, true);
            } else if (style != null && style.metrics != null && style.metrics.width != 0) {
                style.metrics = null;
                textWidget.setStyleRange(style);
            }
        } else {
            textWidget.redrawRange(offset, length, true);
        }
    }

    private static boolean isDeleted(AbstractInlinedAnnotation annotation) {
        return annotation.isMarkedDeleted() || annotation.getPosition().isDeleted() || annotation.getPosition().getLength() == 0;
    }
}

