/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.bindings.internal.BindingTableManager;
import org.eclipse.e4.ui.bindings.internal.ContextSet;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.window.Window;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.quickaccess.ActionProvider;
import org.eclipse.ui.internal.quickaccess.CommandProvider;
import org.eclipse.ui.internal.quickaccess.EditorProvider;
import org.eclipse.ui.internal.quickaccess.PerspectiveProvider;
import org.eclipse.ui.internal.quickaccess.PreferenceProvider;
import org.eclipse.ui.internal.quickaccess.PreviousPicksProvider;
import org.eclipse.ui.internal.quickaccess.PropertiesProvider;
import org.eclipse.ui.internal.quickaccess.QuickAccessContents;
import org.eclipse.ui.internal.quickaccess.QuickAccessExtensionManager;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.ViewProvider;
import org.eclipse.ui.internal.quickaccess.WizardProvider;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.quickaccess.QuickAccessElement;
import org.eclipse.ui.quickaccess.QuickAccessProvider;
import org.eclipse.ui.swt.IFocusService;

public class SearchField {
    private static final String QUICK_ACCESS_COMMAND_ID = "org.eclipse.ui.window.quickAccess";
    private static final String TEXT_ARRAY = "textArray";
    private static final String TEXT_ENTRIES = "textEntries";
    private static final String ORDERED_PROVIDERS = "orderedProviders";
    private static final String ORDERED_ELEMENTS = "orderedElements";
    private static final int MAXIMUM_NUMBER_OF_ELEMENTS = 60;
    private static final int MAXIMUM_NUMBER_OF_TEXT_ENTRIES_PER_ELEMENT = 3;
    private static final String DIALOG_HEIGHT = "dialogHeight";
    private static final String DIALOG_WIDTH = "dialogWidth";
    private static final int MINIMUM_DIALOG_HEIGHT = 50;
    private static final int MINIMUM_DIALOG_WIDTH = 150;
    private MApplication application;
    private MWindow window;
    private Text txtQuickAccess;
    Shell shell;
    private Table table;
    private QuickAccessContents quickAccessContents;
    private Map<String, QuickAccessElement> elementMap = Collections.synchronizedMap(new HashMap());
    private Map<QuickAccessElement, ArrayList<String>> textMap = Collections.synchronizedMap(new HashMap());
    private List<QuickAccessElement> previousPicksList = Collections.synchronizedList(new LinkedList());
    private int dialogHeight = -1;
    private int dialogWidth = -1;
    private Control previousFocusControl;
    boolean activated = false;
    private String selectedString = "";
    private AccessibleAdapter accessibleListener;
    @Inject
    private IBindingService bindingService;
    @Inject
    private EPartService partService;
    private TriggerSequence triggerSequence = null;
    private volatile boolean isLoadingPreviousElements;
    private Job restoreDialogEntriesJob;
    private UIJob refreshQuickAccessContents;
    @Inject
    private BindingTableManager manager;
    @Inject
    private ECommandService eCommandService;
    @Inject
    private IContextService contextService;
    private static final ISchedulingRule RESTORE_DIALOG_ENTRIES_SCHEDULING_RULE = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule rule) {
            return RESTORE_DIALOG_ENTRIES_SCHEDULING_RULE == rule;
        }

        public boolean contains(ISchedulingRule rule) {
            return RESTORE_DIALOG_ENTRIES_SCHEDULING_RULE == rule;
        }
    };

    @PostConstruct
    void createControls(Composite parent, MApplication application, MWindow window) {
        this.window = window;
        this.application = application;
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        this.txtQuickAccess = this.createText(comp);
        this.updateQuickAccessText();
        parent.getShell().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                this.closeDropDown();
            }

            public void controlMoved(ControlEvent e) {
                this.closeDropDown();
            }

            private void closeDropDown() {
                if (SearchField.this.shell == null || SearchField.this.shell.isDisposed() || SearchField.this.txtQuickAccess.isDisposed() || !SearchField.this.shell.isVisible()) {
                    return;
                }
                SearchField.this.quickAccessContents.doClose();
            }
        });
        this.hookUpSelectAll();
        this.txtQuickAccess.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                SearchField.this.showList();
            }
        });
        this.txtQuickAccess.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (SearchField.this.table != null) {
                    SearchField.this.table.getDisplay().asyncExec(() -> SearchField.this.checkFocusLost(SearchField.this.table, SearchField.this.txtQuickAccess));
                }
                SearchField.this.activated = false;
            }

            public void focusGained(FocusEvent e) {
                SearchField.this.previousFocusControl = (Control)e.getSource();
                SearchField.this.activated = true;
            }
        });
        this.txtQuickAccess.addModifyListener(e -> this.showList());
        this.txtQuickAccess.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    SearchField.this.activated = false;
                    SearchField.this.txtQuickAccess.setText("");
                    if (SearchField.this.txtQuickAccess == SearchField.this.previousFocusControl) {
                        SearchField.this.txtQuickAccess.getShell().forceFocus();
                    } else if (SearchField.this.previousFocusControl != null && !SearchField.this.previousFocusControl.isDisposed()) {
                        SearchField.this.previousFocusControl.setFocus();
                    }
                } else if (e.keyCode == 0x1000001) {
                    e.doit = false;
                } else if (e.keyCode == 0x1000002) {
                    e.doit = false;
                }
                if (!e.doit) {
                    SearchField.this.notifyAccessibleTextChanged();
                }
            }
        });
    }

    private void createContentsAndTable() {
        if (this.quickAccessContents != null) {
            return;
        }
        final CommandProvider commandProvider = new CommandProvider();
        this.txtQuickAccess.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                IHandlerService hs = (IHandlerService)SearchField.this.window.getContext().get(IHandlerService.class);
                if (commandProvider.getContextSnapshot() == null) {
                    commandProvider.setSnapshot(hs.createContextSnapshot(true));
                }
            }
        });
        ArrayList<QuickAccessProvider> providers = new ArrayList<QuickAccessProvider>();
        providers.add(new PreviousPicksProvider(this.previousPicksList));
        providers.add(new EditorProvider());
        providers.add(new ViewProvider(this.application, this.window));
        providers.add(new PerspectiveProvider());
        providers.add(commandProvider);
        providers.add(new ActionProvider());
        providers.add(new WizardProvider());
        providers.add(new PreferenceProvider());
        providers.add(new PropertiesProvider());
        providers.addAll(QuickAccessExtensionManager.getProviders());
        this.quickAccessContents = new QuickAccessContents(providers.toArray(new QuickAccessProvider[providers.size()])){

            @Override
            protected void updateFeedback(boolean filterTextEmpty, boolean showAllMatches) {
            }

            @Override
            protected void doClose() {
                SearchField.this.txtQuickAccess.setText("");
                this.resetProviders();
                SearchField.this.dialogHeight = SearchField.this.shell.getSize().y;
                SearchField.this.dialogWidth = SearchField.this.shell.getSize().x;
                SearchField.this.shell.setVisible(false);
                SearchField.this.removeAccessibleListener();
            }

            @Override
            protected QuickAccessElement getPerfectMatch(String filter) {
                return (QuickAccessElement)SearchField.this.elementMap.get(filter);
            }

            @Override
            protected void handleElementSelected(String string, Object selectedElement) {
                if (selectedElement instanceof QuickAccessElement) {
                    MPart activePart;
                    QuickAccessElement element = (QuickAccessElement)selectedElement;
                    SearchField.this.addPreviousPick(string, element);
                    SearchField.this.txtQuickAccess.setText("");
                    element.execute();
                    if (SearchField.this.txtQuickAccess.isDisposed()) {
                        return;
                    }
                    if (SearchField.this.txtQuickAccess.isFocusControl() && (activePart = SearchField.this.partService.getActivePart()) != null) {
                        IPresentationEngine pe = (IPresentationEngine)activePart.getContext().get(IPresentationEngine.class);
                        pe.focusGui((MUIElement)activePart);
                    }
                    if (SearchField.this.shell.isVisible()) {
                        SearchField.this.quickAccessContents.doClose();
                    }
                }
            }

            @Override
            public void refresh(String filter) {
                super.refresh(filter);
                if (SearchField.this.isLoadingPreviousElements) {
                    this.showHintText(QuickAccessMessages.QuickAccessContents_RestoringPreviousChoicesLabel, null);
                }
            }
        };
        this.restoreDialog();
        this.quickAccessContents.hookFilterText(this.txtQuickAccess);
        this.shell = new Shell(this.txtQuickAccess.getShell(), 16400);
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setMinimumSize(new Point(150, 50));
        this.shell.setText(QuickAccessMessages.QuickAccess_EnterSearch);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.shell);
        this.quickAccessContents.createHintText((Composite)this.shell, Window.getDefaultOrientation());
        this.table = this.quickAccessContents.createTable((Composite)this.shell, Window.getDefaultOrientation());
        this.table.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SearchField.this.table.getDisplay().asyncExec(() -> SearchField.this.checkFocusLost(SearchField.this.table, SearchField.this.txtQuickAccess));
            }
        });
        this.quickAccessContents.createInfoLabel((Composite)this.shell);
    }

    @Inject
    @Optional
    protected void keybindingPreferencesChanged(@Preference(nodePath="org.eclipse.ui.workbench", value="org.eclipse.ui.commands") String preferenceValue) {
        if (preferenceValue != null) {
            this.updateQuickAccessText();
        }
    }

    private void showList() {
        boolean nowVisible;
        boolean wasVisible = this.shell != null && this.shell.getVisible();
        boolean bl = nowVisible = this.txtQuickAccess.getText().length() > 0 || this.activated;
        if (!wasVisible && nowVisible) {
            this.createContentsAndTable();
            this.layoutShell();
            this.addAccessibleListener();
            this.quickAccessContents.preOpen();
        }
        if (wasVisible && !nowVisible) {
            this.removeAccessibleListener();
        }
        if (nowVisible) {
            this.notifyAccessibleTextChanged();
        }
        this.shell.setVisible(nowVisible);
    }

    protected void updateQuickAccessTriggerSequence() {
        this.triggerSequence = this.bindingService.getBestActiveBindingFor(QUICK_ACCESS_COMMAND_ID);
        if (this.triggerSequence == null) {
            ParameterizedCommand cmd = this.eCommandService.createCommand(QUICK_ACCESS_COMMAND_ID, null);
            ContextSet contextSet = this.manager.createContextSet(Arrays.asList(this.contextService.getDefinedContexts()));
            Binding binding = this.manager.getBestSequenceFor(contextSet, cmd);
            this.triggerSequence = binding == null ? null : binding.getTriggerSequence();
        }
    }

    private Text createText(Composite parent) {
        Text text = new Text(parent, 384);
        text.setMessage(QuickAccessMessages.QuickAccess_EnterSearch);
        return text;
    }

    private void updateQuickAccessText() {
        if (this.txtQuickAccess == null || this.txtQuickAccess.isDisposed()) {
            return;
        }
        this.updateQuickAccessTriggerSequence();
        if (this.triggerSequence != null) {
            this.txtQuickAccess.setToolTipText(NLS.bind((String)QuickAccessMessages.QuickAccess_TooltipDescription, (Object)this.triggerSequence.format()));
        } else {
            this.txtQuickAccess.setToolTipText(QuickAccessMessages.QuickAccess_TooltipDescription_Empty);
        }
        GC gc = new GC((Drawable)this.txtQuickAccess);
        if (Util.isWin32() || Util.isGtk()) {
            FontMetrics fm = gc.getFontMetrics();
            int wHint = QuickAccessMessages.QuickAccess_EnterSearch.length() * fm.getAverageCharWidth();
            int hHint = fm.getHeight();
            gc.dispose();
            this.txtQuickAccess.setSize(this.txtQuickAccess.computeSize(wHint, hHint));
        } else {
            Point p = gc.textExtent(QuickAccessMessages.QuickAccess_EnterSearch);
            Rectangle r = this.txtQuickAccess.computeTrim(0, 0, p.x, p.y);
            gc.dispose();
            GridDataFactory.fillDefaults().hint(r.width - r.x, -1).applyTo((Control)this.txtQuickAccess);
        }
        this.txtQuickAccess.requestLayout();
    }

    private void hookUpSelectAll() {
        IEclipseContext windowContext = this.window.getContext();
        IFocusService focus = (IFocusService)windowContext.get(IFocusService.class);
        focus.addFocusTracker((Control)this.txtQuickAccess, SearchField.class.getName());
        Expression focusExpr = new Expression(){

            public void collectExpressionInfo(ExpressionInfo info) {
                info.addVariableNameAccess("activeFocusControlId");
            }

            public EvaluationResult evaluate(IEvaluationContext context) {
                return EvaluationResult.valueOf((boolean)SearchField.class.getName().equals(context.getVariable("activeFocusControlId")));
            }
        };
        IHandlerService whService = (IHandlerService)windowContext.get(IHandlerService.class);
        whService.activateHandler("org.eclipse.ui.edit.selectAll", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                SearchField.this.txtQuickAccess.selectAll();
                return null;
            }
        }, focusExpr);
        whService.activateHandler("org.eclipse.ui.edit.cut", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                SearchField.this.txtQuickAccess.cut();
                return null;
            }
        }, focusExpr);
        whService.activateHandler("org.eclipse.ui.edit.copy", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                SearchField.this.txtQuickAccess.copy();
                return null;
            }
        }, focusExpr);
        whService.activateHandler("org.eclipse.ui.edit.paste", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                SearchField.this.txtQuickAccess.paste();
                return null;
            }
        }, focusExpr);
    }

    private Rectangle getConstrainedShellBounds(Display display, Rectangle preferredSize) {
        Rectangle result = new Rectangle(preferredSize.x, preferredSize.y, preferredSize.width, preferredSize.height);
        Point topLeft = new Point(preferredSize.x, preferredSize.y);
        Monitor mon = Util.getClosestMonitor((Display)display, (Point)topLeft);
        Rectangle bounds = mon.getClientArea();
        if (result.height > bounds.height) {
            result.height = bounds.height;
        }
        if (result.width > bounds.width) {
            result.width = bounds.width;
        }
        result.x = Math.max(bounds.x, Math.min(result.x, bounds.x + bounds.width - result.width));
        result.y = Math.max(bounds.y, Math.min(result.y, bounds.y + bounds.height - result.height));
        return result;
    }

    void layoutShell() {
        Display display = this.txtQuickAccess.getDisplay();
        Rectangle tempBounds = this.txtQuickAccess.getBounds();
        Rectangle compBounds = display.map((Control)this.txtQuickAccess, null, tempBounds);
        Rectangle shellBounds = this.txtQuickAccess.getShell().getBounds();
        int preferredWidth = Math.max(150, this.dialogWidth == -1 ? (int)((double)shellBounds.width * 0.6) : this.dialogWidth);
        int width = Math.max(preferredWidth, compBounds.width);
        int height = Math.max(50, this.dialogHeight == -1 ? (int)((double)shellBounds.height * 0.9) : this.dialogHeight);
        if (compBounds.x + width > shellBounds.x + shellBounds.width) {
            compBounds.x = Math.max(shellBounds.x, compBounds.x + compBounds.width - width);
        }
        this.shell.setBounds(this.getConstrainedShellBounds(display, new Rectangle(compBounds.x, compBounds.y + compBounds.height, width, height)));
        this.shell.layout();
    }

    public void activate(Control previousFocusControl) {
        this.previousFocusControl = previousFocusControl;
        this.createContentsAndTable();
        if (!this.shell.isVisible()) {
            this.layoutShell();
            this.quickAccessContents.preOpen();
            this.shell.setVisible(true);
            this.addAccessibleListener();
            this.quickAccessContents.refresh(this.txtQuickAccess.getText().toLowerCase());
        } else {
            this.quickAccessContents.setShowAllMatches(!this.quickAccessContents.getShowAllMatches());
        }
    }

    protected void checkFocusLost(Table table, Text text) {
        if (this.shell == null) {
            return;
        }
        if (!(this.shell.isDisposed() || table.isDisposed() || text.isDisposed())) {
            if (table.getDisplay().getActiveShell() == table.getShell()) {
                text.setFocus();
                return;
            }
            if (!(this.shell.isFocusControl() || table.isFocusControl() || text.isFocusControl())) {
                this.quickAccessContents.doClose();
            }
        }
    }

    private void addAccessibleListener() {
        if (this.accessibleListener == null) {
            this.accessibleListener = new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = SearchField.this.selectedString;
                }
            };
            this.txtQuickAccess.getAccessible().addAccessibleListener((AccessibleListener)this.accessibleListener);
        }
    }

    private void removeAccessibleListener() {
        if (this.accessibleListener != null) {
            this.txtQuickAccess.getAccessible().removeAccessibleListener((AccessibleListener)this.accessibleListener);
            this.accessibleListener = null;
        }
        this.selectedString = "";
    }

    private void notifyAccessibleTextChanged() {
        if (this.table.getSelection().length == 0) {
            return;
        }
        TableItem item = this.table.getSelection()[0];
        this.selectedString = NLS.bind((String)QuickAccessMessages.QuickAccess_SelectedString, (Object)item.getText(0), (Object)item.getText(1));
        this.txtQuickAccess.getAccessible().sendEvent(32780, null);
    }

    private void restoreDialog() {
        final IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null) {
            try {
                this.dialogHeight = dialogSettings.getInt(DIALOG_HEIGHT);
                this.dialogWidth = dialogSettings.getInt(DIALOG_WIDTH);
            }
            catch (NumberFormatException numberFormatException) {
                this.dialogHeight = -1;
                this.dialogWidth = -1;
            }
            String[] orderedProviders = dialogSettings.getArray(ORDERED_PROVIDERS);
            if (orderedProviders != null) {
                this.previousPicksList.addAll(Arrays.asList(new QuickAccessElement[orderedProviders.length]));
            }
            this.isLoadingPreviousElements = true;
            this.refreshQuickAccessContents = new WorkbenchJob("Finish restoring quick access elements"){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        if (SearchField.this.txtQuickAccess.isDisposed()) {
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        SearchField.this.restoreDialogEntries(dialogSettings, true, monitor);
                        SearchField.this.quickAccessContents.refresh(SearchField.this.txtQuickAccess.getText());
                        List previousPicks = SearchField.this.getLoadedPreviousPicks();
                        SearchField.this.previousPicksList.clear();
                        SearchField.this.previousPicksList.addAll(previousPicks);
                    }
                    finally {
                        SearchField.this.isLoadingPreviousElements = false;
                    }
                    return Status.OK_STATUS;
                }
            };
            this.refreshQuickAccessContents.setRule(RESTORE_DIALOG_ENTRIES_SCHEDULING_RULE);
            this.refreshQuickAccessContents.setSystem(true);
            this.restoreDialogEntriesJob = Job.createSystem((String)"Restore quick access elements", monitor -> {
                if (this.txtQuickAccess.isDisposed()) {
                    this.isLoadingPreviousElements = false;
                    return;
                }
                try {
                    try {
                        this.restoreDialogEntries(dialogSettings, false, monitor);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        this.refreshQuickAccessContents.schedule();
                    }
                }
                finally {
                    this.refreshQuickAccessContents.schedule();
                }
            });
            this.restoreDialogEntriesJob.setRule(RESTORE_DIALOG_ENTRIES_SCHEDULING_RULE);
            this.restoreDialogEntriesJob.schedule();
        }
    }

    private void restoreDialogEntries(IDialogSettings dialogSettings, boolean restoreUiElements, IProgressMonitor monitor) throws OperationCanceledException {
        String[] orderedElements = dialogSettings.getArray(ORDERED_ELEMENTS);
        String[] orderedProviders = dialogSettings.getArray(ORDERED_PROVIDERS);
        String[] textEntries = dialogSettings.getArray(TEXT_ENTRIES);
        String[] textArray = dialogSettings.getArray(TEXT_ARRAY);
        if (orderedElements != null && orderedProviders != null && textEntries != null && textArray != null) {
            int arrayIndex = 0;
            int elementCount = orderedElements.length;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Restoring quick access elements.", (int)elementCount);
            int i = 0;
            while (i < elementCount) {
                QuickAccessElement quickAccessElement;
                QuickAccessProvider quickAccessProvider = this.quickAccessContents.getProvider(orderedProviders[i]);
                int numTexts = Integer.parseInt(textEntries[i]);
                subMonitor.split(1).setTaskName("Restoring quick access element \"" + orderedElements[i] + "\".");
                if (quickAccessProvider != null && restoreUiElements == quickAccessProvider.requiresUiAccess() && (quickAccessElement = quickAccessProvider.getElementForId(orderedElements[i])) != null) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    int j = arrayIndex;
                    while (j < arrayIndex + numTexts) {
                        String text = textArray[j];
                        if (text.length() > 0) {
                            arrayList.add(text);
                            this.elementMap.put(text, quickAccessElement);
                        }
                        ++j;
                    }
                    this.textMap.put(quickAccessElement, arrayList);
                    this.previousPicksList.set(i, quickAccessElement);
                }
                arrayIndex += numTexts;
                ++i;
            }
        }
    }

    @PreDestroy
    void dispose() {
        if (this.restoreDialogEntriesJob != null) {
            this.restoreDialogEntriesJob.cancel();
        }
        if (this.refreshQuickAccessContents != null) {
            this.refreshQuickAccessContents.cancel();
        }
        this.storeDialog();
        this.elementMap.clear();
        this.previousPicksList.clear();
        this.textMap.clear();
        this.partService = null;
    }

    private void storeDialog() {
        List<QuickAccessElement> previousPicks = this.getLoadedPreviousPicks();
        String[] orderedElements = new String[previousPicks.size()];
        String[] orderedProviders = new String[previousPicks.size()];
        String[] textEntries = new String[previousPicks.size()];
        ArrayList<String> arrayList = new ArrayList<String>();
        int i = 0;
        while (i < orderedElements.length) {
            QuickAccessElement quickAccessElement = previousPicks.get(i);
            ArrayList<String> elementText = this.textMap.get(quickAccessElement);
            Assert.isNotNull(elementText);
            orderedElements[i] = quickAccessElement.getId();
            orderedProviders[i] = quickAccessElement.getProvider().getId();
            arrayList.addAll(elementText);
            textEntries[i] = String.valueOf(elementText.size());
            ++i;
        }
        String[] textArray = arrayList.toArray(new String[arrayList.size()]);
        IDialogSettings dialogSettings = this.getDialogSettings();
        dialogSettings.put(ORDERED_ELEMENTS, orderedElements);
        dialogSettings.put(ORDERED_PROVIDERS, orderedProviders);
        dialogSettings.put(TEXT_ENTRIES, textEntries);
        dialogSettings.put(TEXT_ARRAY, textArray);
        dialogSettings.put(DIALOG_HEIGHT, this.dialogHeight);
        dialogSettings.put(DIALOG_WIDTH, this.dialogWidth);
    }

    private List<QuickAccessElement> getLoadedPreviousPicks() {
        List<QuickAccessElement> previousPicks = this.previousPicksList.stream().filter(Objects::nonNull).collect(Collectors.toList());
        return previousPicks;
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings workbenchDialogSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings result = workbenchDialogSettings.getSection(this.getId());
        if (result == null) {
            result = workbenchDialogSettings.addNewSection(this.getId());
        }
        return result;
    }

    private String getId() {
        return "org.eclipse.ui.internal.QuickAccess";
    }

    private void addPreviousPick(String text, QuickAccessElement element) {
        this.previousPicksList.remove(element);
        if (this.previousPicksList.size() == 60) {
            QuickAccessElement removedElement = this.previousPicksList.remove(this.previousPicksList.size() - 1);
            ArrayList<String> removedList = this.textMap.remove(removedElement);
            int i = 0;
            while (i < removedList.size()) {
                this.elementMap.remove(removedList.get(i));
                ++i;
            }
        }
        this.previousPicksList.add(0, element);
        ArrayList<String> textList = this.textMap.get(element);
        if (textList == null) {
            textList = new ArrayList();
            this.textMap.put(element, textList);
        }
        textList.remove(text);
        if (textList.size() == 3) {
            String removedText = textList.remove(0);
            this.elementMap.remove(removedText);
        }
        if (text.length() > 0) {
            textList.add(text);
            QuickAccessElement replacedElement = this.elementMap.put(text, element);
            if (replacedElement != null && !replacedElement.equals(element) && (textList = this.textMap.get(replacedElement)) != null) {
                textList.remove(text);
                if (textList.isEmpty()) {
                    this.textMap.remove(replacedElement);
                    this.previousPicksList.remove(replacedElement);
                }
            }
        }
    }

    public Shell getQuickAccessShell() {
        this.createContentsAndTable();
        return this.shell;
    }

    public Text getQuickAccessSearchText() {
        return this.txtQuickAccess;
    }

    public Table getQuickAccessTable() {
        this.createContentsAndTable();
        return this.table;
    }
}

