/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.MementoUpdate;
import org.eclipse.debug.internal.ui.viewers.model.TreeModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.ViewerStateTracker;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;

class ElementMementoRequest
extends MementoUpdate
implements IElementMementoRequest {
    private ViewerStateTracker.IElementMementoCollector fManager;
    private ModelDelta fDelta;

    public ElementMementoRequest(TreeModelContentProvider provider, Object viewerInput, ViewerStateTracker.IElementMementoCollector collector, Object element, TreePath elementPath, IMemento memento, ModelDelta delta) {
        super(provider, viewerInput, provider.getPresentationContext(), element, elementPath, memento);
        this.fManager = collector;
        this.fDelta = delta;
    }

    public void done() {
        IInternalTreeModelViewer viewer = this.getContentProvider().getViewer();
        if (viewer == null) {
            return;
        }
        Display display = viewer.getDisplay();
        if (display != null) {
            if (display.getThread() == Thread.currentThread()) {
                this.doComplete();
            } else {
                display.asyncExec(this::doComplete);
            }
        }
    }

    private void doComplete() {
        if (this.getContentProvider().isDisposed()) {
            return;
        }
        if (!this.isCanceled() && (this.getStatus() == null || this.getStatus().isOK())) {
            this.fDelta.setElement(this.getMemento());
        }
        this.fManager.requestComplete(this);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("IElementMementoRequest: ");
        buf.append(this.getElement());
        return buf.toString();
    }
}

