/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.model.elements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IErrorReportingExpression;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.model.elements.VariableContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.ViewerAdapterService;
import org.eclipse.debug.internal.ui.viewers.model.ViewerUpdateMonitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.FontData;

public class ExpressionContentProvider
extends VariableContentProvider {
    @Override
    public void update(IChildrenCountUpdate[] updates) {
        HashMap<IElementContentProvider, List<IViewerUpdate>> delegateMap = new HashMap<IElementContentProvider, List<IViewerUpdate>>();
        ArrayList<IViewerUpdate> notDelegated = new ArrayList<IViewerUpdate>();
        this.findDelegates(delegateMap, notDelegated, updates);
        for (IElementContentProvider delegate : delegateMap.keySet()) {
            List updateList = (List)delegateMap.get(delegate);
            delegate.update(updateList.toArray(new IChildrenCountUpdate[updateList.size()]));
        }
        if (notDelegated.size() > 0) {
            super.update(notDelegated.toArray(new IChildrenCountUpdate[notDelegated.size()]));
        }
    }

    @Override
    public void update(IHasChildrenUpdate[] updates) {
        HashMap<IElementContentProvider, List<IViewerUpdate>> delegateMap = new HashMap<IElementContentProvider, List<IViewerUpdate>>();
        ArrayList<IViewerUpdate> notDelegated = new ArrayList<IViewerUpdate>();
        this.findDelegates(delegateMap, notDelegated, updates);
        for (IElementContentProvider delegate : delegateMap.keySet()) {
            List updateList = (List)delegateMap.get(delegate);
            delegate.update(updateList.toArray(new IHasChildrenUpdate[updateList.size()]));
        }
        if (notDelegated.size() > 0) {
            super.update(notDelegated.toArray(new IHasChildrenUpdate[notDelegated.size()]));
        }
    }

    @Override
    public void update(IChildrenUpdate[] updates) {
        HashMap<IElementContentProvider, List<IViewerUpdate>> delegateMap = new HashMap<IElementContentProvider, List<IViewerUpdate>>();
        ArrayList<IViewerUpdate> notDelegated = new ArrayList<IViewerUpdate>();
        this.findDelegates(delegateMap, notDelegated, updates);
        for (IElementContentProvider delegate : delegateMap.keySet()) {
            List updateList = (List)delegateMap.get(delegate);
            delegate.update(updateList.toArray(new IChildrenUpdate[updateList.size()]));
        }
        if (notDelegated.size() > 0) {
            super.update(notDelegated.toArray(new IChildrenUpdate[notDelegated.size()]));
        }
    }

    private void findDelegates(Map<IElementContentProvider, List<IViewerUpdate>> delegateMap, List<IViewerUpdate> notDelegated, IViewerUpdate[] updates) {
        int i = 0;
        while (i < updates.length) {
            IElementContentProvider delegate;
            if (updates[i] instanceof ViewerUpdateMonitor && !((ViewerUpdateMonitor)updates[i]).isDelegated() && updates[i].getElement() instanceof IExpression && (delegate = ViewerAdapterService.getContentProvider(((IExpression)updates[i].getElement()).getValue())) != null) {
                List<IViewerUpdate> updateList = delegateMap.get(delegate);
                if (updateList == null) {
                    updateList = new ArrayList<IViewerUpdate>();
                    delegateMap.put(delegate, updateList);
                }
                ((ViewerUpdateMonitor)updates[i]).setDelegated(true);
                updateList.add(updates[i]);
            } else {
                notDelegated.add(updates[i]);
            }
            ++i;
        }
    }

    @Override
    protected Object[] getAllChildren(Object parent, IPresentationContext context) throws CoreException {
        IValue value;
        IErrorReportingExpression expression;
        if (parent instanceof IErrorReportingExpression && (expression = (IErrorReportingExpression)parent).hasErrors()) {
            String[] messages = expression.getErrorMessages();
            LinkedHashSet<ErrorMessageElement> set = new LinkedHashSet<ErrorMessageElement>(messages.length);
            int i = 0;
            while (i < messages.length) {
                set.add(new ErrorMessageElement(messages[i]));
                ++i;
            }
            return set.toArray();
        }
        if (parent instanceof IExpression && (value = (expression = (IExpression)parent).getValue()) != null) {
            return this.getValueChildren((IDebugElement)expression, value, context);
        }
        return EMPTY;
    }

    @Override
    protected boolean hasChildren(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        IErrorReportingExpression expression;
        if (element instanceof IErrorReportingExpression && (expression = (IErrorReportingExpression)element).hasErrors()) {
            return true;
        }
        if (element instanceof IExpression) {
            IValue value = ((IExpression)element).getValue();
            if (value == null) {
                return false;
            }
            return value.hasVariables();
        }
        return false;
    }

    private static class ErrorMessageElement
    implements IElementLabelProvider {
        private final String fMessage;

        public ErrorMessageElement(String message) {
            this.fMessage = message;
        }

        @Override
        public void update(ILabelUpdate[] updates) {
            int i = 0;
            while (i < updates.length) {
                String[] columnIds = updates[i].getColumnIds();
                if (columnIds == null) {
                    this.updateLabel(updates[i], 0);
                } else {
                    int j = 0;
                    while (j < columnIds.length) {
                        if ("org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_NAME".equals(columnIds[j])) {
                            this.updateLabel(updates[i], j);
                        } else {
                            updates[i].setLabel("", j);
                        }
                        ++j;
                    }
                }
                updates[i].done();
                ++i;
            }
        }

        private void updateLabel(ILabelUpdate update, int columnIndex) {
            update.setLabel(this.fMessage, columnIndex);
            FontData fontData = JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.VariableTextFont").getFontData()[0];
            fontData.setStyle(2);
        }
    }
}

