/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.participants;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.mapping.ResourceChangeValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.IConditionChecker;

public class ResourceChangeChecker
implements IConditionChecker {
    private IResourceChangeDescriptionFactory fDeltaFactory = ResourceChangeValidator.getValidator().createDeltaFactory();

    public static RefactoringStatus checkFilesToBeChanged(IFile[] files, IProgressMonitor monitor) throws CoreException {
        ResourceChangeChecker checker = new ResourceChangeChecker();
        int i = 0;
        while (i < files.length) {
            checker.getDeltaFactory().change(files[i]);
            ++i;
        }
        return checker.check(monitor);
    }

    public IResourceChangeDescriptionFactory getDeltaFactory() {
        return this.fDeltaFactory;
    }

    @Override
    public RefactoringStatus check(IProgressMonitor monitor) throws CoreException {
        IStatus status = ResourceChangeValidator.getValidator().validateChange(this.fDeltaFactory.getDelta(), monitor);
        return ResourceChangeChecker.createFrom(status);
    }

    IFile[] getChangedFiles() throws CoreException {
        IResourceDelta root = this.fDeltaFactory.getDelta();
        final ArrayList result = new ArrayList();
        root.accept(new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                IResource resource = delta.getResource();
                if (resource.getType() == 1) {
                    int kind = delta.getKind();
                    if (ResourceChangeChecker.isSet(kind, 4)) {
                        result.add((IFile)resource);
                    } else if (ResourceChangeChecker.isSet(kind, 1) && ResourceChangeChecker.isSet(delta.getFlags(), 4352)) {
                        IFile movedFrom = resource.getWorkspace().getRoot().getFile(delta.getMovedFromPath());
                        result.add(movedFrom);
                    }
                }
                return true;
            }
        });
        return result.toArray(new IFile[result.size()]);
    }

    private static final boolean isSet(int flags, int flag) {
        return (flags & flag) == flag;
    }

    private static RefactoringStatus createFrom(IStatus status) {
        if (status.isOK()) {
            return new RefactoringStatus();
        }
        if (!status.isMultiStatus()) {
            switch (status.getSeverity()) {
                case 0: {
                    return new RefactoringStatus();
                }
                case 1: {
                    return RefactoringStatus.createInfoStatus(status.getMessage());
                }
                case 2: {
                    return RefactoringStatus.createWarningStatus(status.getMessage());
                }
                case 4: {
                    return RefactoringStatus.createErrorStatus(status.getMessage());
                }
                case 8: {
                    return RefactoringStatus.createFatalErrorStatus(status.getMessage());
                }
            }
            return RefactoringStatus.createFatalErrorStatus(status.getMessage());
        }
        IStatus[] children = status.getChildren();
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < children.length) {
            result.merge(ResourceChangeChecker.createFrom(children[i]));
            ++i;
        }
        return result;
    }
}

