/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class JarSelectionValidator
implements ISelectionStatusValidator {
    private Class<?>[] fAcceptedTypes;
    private boolean fAllowMultipleSelection;

    public JarSelectionValidator(Class<?>[] acceptedTypes, boolean allowMultipleSelection) {
        Assert.isNotNull(acceptedTypes);
        this.fAcceptedTypes = acceptedTypes;
        this.fAllowMultipleSelection = allowMultipleSelection;
    }

    public IStatus validate(Object[] elements) {
        if (this.isValidSelection(elements)) {
            return new Status(0, PDEPlugin.getPluginId(), 0, "", null);
        }
        return new Status(4, PDEPlugin.getPluginId(), 4, "", null);
    }

    private boolean isValidSelection(Object[] selection) {
        if (selection.length == 0) {
            return false;
        }
        if (!this.fAllowMultipleSelection && selection.length != 1) {
            return false;
        }
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (!this.isValid(o)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isValid(Object element) {
        Class<?>[] classArray = this.fAcceptedTypes;
        int n = this.fAcceptedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> acceptedType = classArray[n2];
            if (acceptedType.isInstance(element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

