/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.browse;

import java.io.File;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.filetransfer.IRemoteFile;
import org.eclipse.ecf.filetransfer.IRemoteFileAttributes;
import org.eclipse.ecf.filetransfer.IRemoteFileInfo;
import org.eclipse.ecf.filetransfer.identity.FileIDFactory;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.internal.provider.filetransfer.Activator;
import org.eclipse.ecf.provider.filetransfer.browse.LocalRemoteFileAttributes;
import org.eclipse.ecf.provider.filetransfer.identity.FileTransferNamespace;

public class LocalRemoteFile
implements IRemoteFile {
    File file = null;
    IRemoteFileInfo info;

    public LocalRemoteFile(File file) {
        this.file = file;
        Assert.isNotNull((Object)file);
        this.info = new IRemoteFileInfo(){
            IRemoteFileAttributes attributes;
            {
                this.attributes = new LocalRemoteFileAttributes(LocalRemoteFile.this.file);
            }

            public IRemoteFileAttributes getAttributes() {
                return this.attributes;
            }

            public long getLastModified() {
                return LocalRemoteFile.this.file.lastModified();
            }

            public long getLength() {
                return LocalRemoteFile.this.file.length();
            }

            public String getName() {
                return LocalRemoteFile.this.file.getName();
            }

            public boolean isDirectory() {
                return LocalRemoteFile.this.file.isDirectory();
            }

            public void setAttributes(IRemoteFileAttributes attributes) {
            }

            public void setLastModified(long time) {
            }

            public void setName(String name) {
            }
        };
    }

    public IFileID getID() {
        try {
            return FileIDFactory.getDefault().createFileID(IDFactory.getDefault().getNamespaceByName(FileTransferNamespace.PROTOCOL), this.file.toURL());
        }
        catch (Exception e) {
            return null;
        }
    }

    public IRemoteFileInfo getInfo() {
        return this.info;
    }

    public Object getAdapter(Class adapter) {
        IAdapterManager adapterManager = Activator.getDefault().getAdapterManager();
        if (adapterManager == null) {
            return null;
        }
        return adapterManager.loadAdapter((Object)this, adapter.getName());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("LocalRemoteFile[");
        buf.append("id=").append(this.getID()).append(";");
        buf.append("name=").append(this.getInfo().getName()).append(";");
        buf.append("isDir=").append(this.getInfo().isDirectory()).append(";");
        buf.append("length=").append(this.getInfo().getLength()).append(";");
        buf.append("lastMod=").append(this.getInfo().getLastModified()).append(";");
        buf.append("attr=").append(this.getInfo().getAttributes()).append("]");
        return buf.toString();
    }
}

