/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.debug.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DebugType implements Enumerator
{
    SUSPEND(0, "Suspend", "Suspend"),
    RESUME(1, "Resume", "Resume"),
    STEP(2, "Step", "Step"),
    STEP_OVER(3, "StepOver", "StepOver"),
    BREAKPOINT_ADD(4, "BreakpointAdd", "BreakpointAdd"),
    BREAKPOINT_REMOVE(5, "BreakpointRemove", "BreakpointRemove"),
    SKIP_ALL(6, "SkipAll", "SkipAll"),
    RESOLVE_VARIABLE(7, "ResolveVariable", "ResolveVariable"),
    STEP_RETURN(8, "StepReturn", "StepReturn");

    public static final int SUSPEND_VALUE = 0;
    public static final int RESUME_VALUE = 1;
    public static final int STEP_VALUE = 2;
    public static final int STEP_OVER_VALUE = 3;
    public static final int BREAKPOINT_ADD_VALUE = 4;
    public static final int BREAKPOINT_REMOVE_VALUE = 5;
    public static final int SKIP_ALL_VALUE = 6;
    public static final int RESOLVE_VARIABLE_VALUE = 7;
    public static final int STEP_RETURN_VALUE = 8;
    private static final DebugType[] VALUES_ARRAY;
    public static final List<DebugType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DebugType[]{SUSPEND, RESUME, STEP, STEP_OVER, BREAKPOINT_ADD, BREAKPOINT_REMOVE, SKIP_ALL, RESOLVE_VARIABLE, STEP_RETURN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DebugType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DebugType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DebugType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DebugType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DebugType get(int value) {
        switch (value) {
            case 0: {
                return SUSPEND;
            }
            case 1: {
                return RESUME;
            }
            case 2: {
                return STEP;
            }
            case 3: {
                return STEP_OVER;
            }
            case 4: {
                return BREAKPOINT_ADD;
            }
            case 5: {
                return BREAKPOINT_REMOVE;
            }
            case 6: {
                return SKIP_ALL;
            }
            case 7: {
                return RESOLVE_VARIABLE;
            }
            case 8: {
                return STEP_RETURN;
            }
        }
        return null;
    }

    private DebugType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

