/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.core.target;

import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.EclipseHomeInitializer;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.TargetPlatformService;

public class LoadTargetDefinitionJob
extends WorkspaceJob {
    private static final String JOB_FAMILY_ID = "LoadTargetDefinitionJob";
    private ITargetDefinition fTarget;
    private boolean fNone = false;

    public static void load(ITargetDefinition target) {
        LoadTargetDefinitionJob.load(target, null);
    }

    public static void load(ITargetDefinition target, IJobChangeListener listener) {
        Job.getJobManager().cancel((Object)JOB_FAMILY_ID);
        LoadTargetDefinitionJob job = new LoadTargetDefinitionJob(target);
        job.setUser(true);
        if (listener != null) {
            job.addJobChangeListener(listener);
        }
        job.schedule();
    }

    public LoadTargetDefinitionJob(ITargetDefinition target) {
        super(Messages.LoadTargetDefinitionJob_0);
        this.fTarget = target;
        if (target == null) {
            this.fNone = true;
            ITargetPlatformService service = PDECore.getDefault().acquireService(ITargetPlatformService.class);
            this.fTarget = service.newTarget();
        }
    }

    public boolean belongsTo(Object family) {
        return JOB_FAMILY_ID.equals(family);
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LoadTargetOperation_mainTaskName, (int)40);
        try {
            if (subMon.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            if (!this.fTarget.isResolved()) {
                this.fTarget.resolve((IProgressMonitor)subMon.split(20));
            }
            subMon.setWorkRemaining(20);
            if (subMon.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            PDEPreferencesManager preferences = PDECore.getDefault().getPreferencesManager();
            ((TargetPlatformService)TargetPlatformService.getDefault()).setWorkspaceTargetDefinition(this.fTarget);
            String memento = this.fTarget.getHandle().getMemento();
            if (this.fNone) {
                memento = "NO_TARGET";
            }
            if (memento.equals(preferences.getString("workspace_target_handle"))) {
                preferences.setValue("workspace_target_handle", "");
            }
            preferences.setValue("workspace_target_handle", memento);
            if (subMon.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.clearDeprecatedPreferences(preferences, (IProgressMonitor)subMon.split(3));
            if (subMon.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.loadJRE((IProgressMonitor)subMon.split(3));
            if (subMon.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            PDECore.getDefault().getPreferencesManager().savePluginPreferences();
            this.resetPlatform((IProgressMonitor)subMon.split(14));
            if (subMon.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
        }
        finally {
            subMon.done();
            if (monitor != null) {
                monitor.done();
            }
        }
        return Status.OK_STATUS;
    }

    private void clearDeprecatedPreferences(PDEPreferencesManager pref, IProgressMonitor monitor) {
        String empty = "";
        pref.setValue("org.eclipse.pde.ui.arch", empty);
        pref.setValue("org.eclipse.pde.ui.nl", empty);
        pref.setValue("org.eclipse.pde.ui.os", empty);
        pref.setValue("org.eclipse.pde.ui.ws", empty);
        pref.setValue("program_args", empty);
        pref.setValue("vm_args", empty);
        pref.setValue("target_mode", empty);
        pref.setValue("checkedPlugins", empty);
        pref.setValue("checkedVersionPlugins", empty);
        pref.setValue("vm_launcher_ini", empty);
        pref.setValue("implicit_dependencies", empty);
        pref.setValue("additional_locations", empty);
        pref.setValue("target_platform_realization", empty);
        pref.setValue("pooled_bundles", empty);
        pref.setValue("pooled_urls", empty);
        pref.setValue("external_features", empty);
        pref.setValue("target.profile", empty);
    }

    private void loadJRE(IProgressMonitor monitor) {
        IVMInstall def;
        IVMInstall jre;
        IPath container = this.fTarget.getJREContainer();
        monitor.beginTask(Messages.LoadTargetOperation_jreTaskName, 1);
        if (container != null && (jre = JavaRuntime.getVMInstall((IPath)container)) != null && !jre.equals(def = JavaRuntime.getDefaultVMInstall())) {
            try {
                JavaRuntime.setDefaultVMInstall((IVMInstall)jre, null);
            }
            catch (CoreException coreException) {}
        }
        monitor.done();
    }

    private void resetPlatform(IProgressMonitor monitor) {
        EclipseHomeInitializer.resetEclipseHomeVariable();
        PDECore.getDefault().getSourceLocationManager().reset();
        PDECore.getDefault().getJavadocLocationManager().reset();
        PDECore.getDefault().getExtensionsRegistry().targetReloaded();
        PDECore.getDefault().getModelManager().targetReloaded(monitor);
        PDECore.getDefault().getFeatureModelManager().targetReloaded();
    }
}

