/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.model;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryService;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryWizard;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.IMergeContext;

public abstract class RefactoringHistoryMergeWizard
extends RefactoringHistoryWizard {
    private final Set<IResource> fAddedFiles = new HashSet<IResource>();
    private final Set<IResource> fChangedFiles = new HashSet<IResource>();
    private final IResourceChangeListener fListener = new WorkspaceChangeListener();
    private final Set<IResource> fRemovedFiles = new HashSet<IResource>();

    protected RefactoringHistoryMergeWizard(String caption, String title, String description) {
        super(caption, title, description);
    }

    @Override
    protected RefactoringStatus aboutToPerformHistory(IProgressMonitor monitor) {
        this.fAddedFiles.clear();
        this.fRemovedFiles.clear();
        this.fChangedFiles.clear();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fListener, 1);
        return super.aboutToPerformHistory(monitor);
    }

    @Override
    protected RefactoringStatus aboutToPerformRefactoring(Refactoring refactoring, RefactoringDescriptor descriptor, IProgressMonitor monitor) {
        Assert.isNotNull((Object)descriptor);
        long stamp = descriptor.getTimeStamp();
        if (stamp >= 0L) {
            RefactoringHistoryService.getInstance().setOverrideTimeStamp(stamp);
        }
        return super.aboutToPerformRefactoring(refactoring, descriptor, monitor);
    }

    public Set<IResource> getAddedFiles() {
        return this.fAddedFiles;
    }

    public Set<IResource> getChangedFiles() {
        return this.fChangedFiles;
    }

    public Set<IResource> getRemovedFiles() {
        return this.fRemovedFiles;
    }

    @Override
    protected RefactoringStatus historyPerformed(IProgressMonitor monitor) {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fListener);
        RefactoringHistoryService.getInstance().setOverrideTimeStamp(-1L);
        return super.historyPerformed(monitor);
    }

    @Override
    protected RefactoringStatus refactoringPerformed(Refactoring refactoring, IProgressMonitor monitor) {
        RefactoringHistoryService.getInstance().setOverrideTimeStamp(-1L);
        return super.refactoringPerformed(refactoring, monitor);
    }

    public void resolveConflicts(IMergeContext context) {
        IDiff diff;
        Assert.isNotNull((Object)context);
        for (IResource resource : this.fChangedFiles) {
            diff = context.getDiffTree().getDiff(resource);
            if (diff == null) continue;
            try {
                context.markAsMerged(diff, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException exception) {
                RefactoringUIPlugin.log(exception);
            }
        }
        for (IResource resource : this.fAddedFiles) {
            diff = context.getDiffTree().getDiff(resource);
            if (diff == null) continue;
            try {
                context.markAsMerged(diff, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException exception) {
                RefactoringUIPlugin.log(exception);
            }
        }
        for (IResource resource : this.fRemovedFiles) {
            diff = context.getDiffTree().getDiff(resource);
            if (diff == null) continue;
            try {
                context.markAsMerged(diff, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException exception) {
                RefactoringUIPlugin.log(exception);
            }
        }
    }

    private class WorkspaceChangeListener
    implements IResourceChangeListener {
        private WorkspaceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            final IResourceDelta delta = event.getDelta();
            if (delta != null) {
                try {
                    delta.accept(new IResourceDeltaVisitor(){

                        public final boolean visit(IResourceDelta current) throws CoreException {
                            IResource resource = current.getResource();
                            if (!resource.isDerived() && resource.getType() == 1) {
                                switch (delta.getKind()) {
                                    case 1: {
                                        RefactoringHistoryMergeWizard.this.fAddedFiles.add(resource);
                                        break;
                                    }
                                    case 2: {
                                        RefactoringHistoryMergeWizard.this.fRemovedFiles.add(resource);
                                        break;
                                    }
                                    case 4: {
                                        RefactoringHistoryMergeWizard.this.fChangedFiles.add(resource);
                                    }
                                }
                            }
                            return true;
                        }
                    });
                }
                catch (CoreException exception) {
                    RefactoringUIPlugin.log(exception);
                }
            }
        }
    }
}

