/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.controls;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.ScenarioPackage;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.controls.AbstractEmbeddedComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class DescriptionComposite
extends AbstractEmbeddedComposite {
    private NamedElement element;
    private Composite control;
    private TextViewer descriptionControl;
    private Binding descriptionBinding;

    @Override
    protected void fillActions(IToolBarManager manager) {
        Action clearAction = new Action(){

            public void run() {
                DescriptionComposite.this.descriptionControl.getDocument().set("");
                DescriptionComposite.this.descriptionControl.getControl().setFocus();
            }
        };
        clearAction.setImageDescriptor(Images.getImageDescriptor("icons/panel/clear.gif"));
        clearAction.setToolTipText(Messages.DescriptionComposite_ClearToolTip);
        manager.add((IAction)clearAction);
    }

    public DescriptionComposite(NamedElement element) {
        this.element = element;
    }

    @Override
    public String getName() {
        return Messages.DescriptionComposite_Name;
    }

    @Override
    public Image getImage() {
        return Images.getImage("icons/file.gif");
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.control = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.control);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(true).applyTo(this.control);
        this.descriptionControl = new TextViewer(this.control, 2882);
        Document document = new Document();
        this.descriptionControl.setDocument((IDocument)document);
        this.descriptionControl.setUndoManager((IUndoManager)new TextViewerUndoManager(25));
        this.descriptionControl.activatePlugins();
        GridDataFactory.fillDefaults().grab(true, true).hint(100, 50).applyTo(this.descriptionControl.getControl());
        this.update(this.element);
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    public StyledText getDescriptionControl() {
        return (StyledText)this.descriptionControl.getControl();
    }

    public TextViewer getDescriptionViewer() {
        return this.descriptionControl;
    }

    public void update(NamedElement element) {
        String descr;
        String doc;
        this.element = element;
        if (this.descriptionBinding != null) {
            this.descriptionBinding.dispose();
        }
        this.descriptionControl.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                String value = DescriptionComposite.this.descriptionControl.getDocument().get();
                if (value != null && value.trim().length() == 0) {
                    value = null;
                }
                String curDescr = DescriptionComposite.this.element.getDescription();
                if (value == null && curDescr != null) {
                    DescriptionComposite.this.element.setDescription(value);
                } else if (value != curDescr && !value.equals(curDescr)) {
                    DescriptionComposite.this.element.setDescription(value);
                }
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        IChangeListener scenarioContentListener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                String descr;
                String doc;
                if (DescriptionComposite.this.descriptionControl.getDocument() != null && !(doc = DescriptionComposite.this.descriptionControl.getDocument().get()).equals(descr = DescriptionComposite.this.element.getDescription())) {
                    DescriptionComposite.this.descriptionControl.getDocument().set(descr);
                }
            }
        };
        IObservableValue scriptContent = EMFObservables.observeValue((EObject)element, (EStructuralFeature)ScenarioPackage.Literals.SCENARIO__CONTENT);
        scriptContent.addChangeListener(scenarioContentListener);
        if (this.descriptionControl.getDocument() != null && !(doc = this.descriptionControl.getDocument().get()).equals(descr = this.element.getDescription()) && descr != null) {
            this.descriptionControl.getDocument().set(descr);
        }
        this.descriptionControl.getUndoManager().reset();
    }

    IOperationHistory getHistory() {
        if (PlatformUI.getWorkbench() == null) {
            return null;
        }
        return PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
    }

    private IUndoContext getUndoContext() {
        IUndoManager undoManager;
        if (this.getDescriptionViewer() instanceof ITextViewerExtension6 && (undoManager = this.getDescriptionViewer().getUndoManager()) instanceof IUndoManagerExtension) {
            return ((IUndoManagerExtension)undoManager).getUndoContext();
        }
        return null;
    }

    public boolean canUndo() {
        IUndoContext ctx = this.getUndoContext();
        if (ctx != null) {
            return this.getHistory().canUndo(ctx);
        }
        return false;
    }

    public boolean canRedo() {
        IUndoContext ctx = this.getUndoContext();
        if (ctx != null) {
            return this.getHistory().canRedo(ctx);
        }
        return false;
    }

    public void undo() {
        IUndoContext ctx = this.getUndoContext();
        if (ctx != null) {
            try {
                this.getHistory().undo(ctx, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Q7UIPlugin.log(e);
            }
        }
    }

    public void redo() {
        IUndoContext ctx = this.getUndoContext();
        if (ctx != null) {
            try {
                this.getHistory().redo(ctx, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Q7UIPlugin.log(e);
            }
        }
    }
}

