/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.actions;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.internal.ide.actions.BuildSetAction;
import org.eclipse.ui.internal.ide.actions.SelectBuildWorkingSetAction;

public class BuildSetMenu
extends ContributionItem {
    private IActionBarConfigurer actionBars;
    boolean dirty = true;
    private IMenuListener menuListener = manager -> {
        manager.markDirty();
        this.dirty = true;
    };
    private IAction selectBuildWorkingSetAction;
    private IWorkbenchWindow window;

    public BuildSetMenu(IWorkbenchWindow window, IActionBarConfigurer actionBars) {
        this.window = window;
        this.actionBars = actionBars;
        this.selectBuildWorkingSetAction = new SelectBuildWorkingSetAction(window, actionBars);
    }

    private void addMnemonic(BuildSetAction action, int index) {
        StringBuilder label = new StringBuilder();
        if (index < 9) {
            label.append('&');
            label.append(index);
            label.append(' ');
        }
        label.append(action.getWorkingSet().getLabel());
        action.setText(label.toString());
    }

    public void fill(Menu menu, int index) {
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        if (!this.dirty) {
            return;
        }
        this.fillMenu(menu);
        this.dirty = false;
    }

    private void fillMenu(Menu menu) {
        int n;
        boolean isAutoBuilding = ResourcesPlugin.getWorkspace().isAutoBuilding();
        IWorkingSet[] sets = this.window.getWorkbench().getWorkingSetManager().getRecentWorkingSets();
        BuildSetAction last = BuildSetAction.lastBuilt;
        Object lastSet = null;
        int accel = 1;
        if (last != null) {
            boolean found = false;
            IWorkingSet[] iWorkingSetArray = sets;
            int n2 = sets.length;
            n = 0;
            while (n < n2) {
                IWorkingSet set = iWorkingSetArray[n];
                if (set.equals(last.getWorkingSet())) {
                    found = true;
                    break;
                }
                ++n;
            }
            if (found) {
                last.setChecked(true);
                last.setEnabled(!isAutoBuilding);
                last.setActionDefinitionId("org.eclipse.ui.project.buildLast");
                this.addMnemonic(last, accel++);
                new ActionContributionItem((IAction)last).fill(menu, -1);
                lastSet = last.getWorkingSet();
            } else {
                BuildSetAction.lastBuilt = null;
            }
        }
        IWorkingSet[] iWorkingSetArray = sets;
        n = sets.length;
        int n3 = 0;
        while (n3 < n) {
            IWorkingSet set = iWorkingSetArray[n3];
            if (lastSet == null || !lastSet.equals(set)) {
                BuildSetAction action = new BuildSetAction(set, this.window, this.actionBars);
                this.addMnemonic(action, accel++);
                action.setEnabled(!isAutoBuilding);
                new ActionContributionItem((IAction)action).fill(menu, -1);
            }
            ++n3;
        }
        if (sets.length > 0) {
            new Separator().fill(menu, -1);
        }
        this.selectBuildWorkingSetAction.setEnabled(!isAutoBuilding);
        new ActionContributionItem(this.selectBuildWorkingSetAction).fill(menu, -1);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDynamic() {
        return true;
    }
}

