/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.AbstractBundleContainer;
import org.eclipse.pde.internal.core.target.Messages;

public class DirectoryBundleContainer
extends AbstractBundleContainer {
    public static final String TYPE = "Directory";
    private String fPath;

    public DirectoryBundleContainer(String path) {
        this.fPath = path;
    }

    @Override
    public String getLocation(boolean resolve) throws CoreException {
        if (resolve) {
            return this.getDirectory().toString();
        }
        return this.fPath;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected TargetBundle[] resolveBundles(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        File dir = this.getDirectory();
        if (dir.isDirectory()) {
            File site = this.getSite(dir);
            File[] files = site.listFiles();
            SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DirectoryBundleContainer_0, (int)files.length);
            ArrayList<TargetBundle> bundles = new ArrayList<TargetBundle>(files.length);
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                block4: {
                    File file = fileArray[n2];
                    try {
                        TargetBundle rb = new TargetBundle(file);
                        bundles.add(rb);
                    }
                    catch (CoreException e) {
                        if (e.getStatus().getCode() != 201) break block4;
                        PDECore.log(e);
                    }
                }
                localMonitor.split(1);
                ++n2;
            }
            return bundles.toArray(new TargetBundle[bundles.size()]);
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.DirectoryBundleContainer_1, (Object)dir.toString())));
    }

    @Override
    protected TargetFeature[] resolveFeatures(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        File dir = this.getDirectory();
        if (!dir.isDirectory()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.DirectoryBundleContainer_1, (Object)dir.toString())));
        }
        File site = this.getFeatureSite(dir);
        File[] files = site.listFiles();
        SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DirectoryBundleContainer_0, (int)files.length);
        ArrayList<TargetFeature> features = new ArrayList<TargetFeature>(files.length);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                TargetFeature rf = new TargetFeature(file);
                features.add(rf);
            }
            catch (CoreException coreException) {}
            localMonitor.split(1);
            ++n2;
        }
        return features.toArray(new TargetFeature[features.size()]);
    }

    protected File getDirectory() throws CoreException {
        String path = this.resolveVariables(this.fPath);
        return new File(path);
    }

    public boolean equals(Object o) {
        if (o instanceof DirectoryBundleContainer) {
            DirectoryBundleContainer dbc = (DirectoryBundleContainer)o;
            return this.fPath.equals(dbc.fPath);
        }
        return false;
    }

    public int hashCode() {
        return this.fPath.hashCode();
    }

    public String toString() {
        return new StringBuffer().append("Directory ").append(this.fPath).toString();
    }

    private File getSite(File root) {
        File file = new File(root, "plugins");
        if (file.exists()) {
            return file;
        }
        return root;
    }

    private File getFeatureSite(File root) {
        File file = new File(root, "features");
        if (file.exists()) {
            return file;
        }
        return root;
    }
}

