/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.filesystem;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.rcptt.ecl.filesystem.EclFile;
import org.eclipse.rcptt.ecl.filesystem.EclFilesystemPlugin;
import org.eclipse.rcptt.ecl.filesystem.internal.CompositeEclFileResolver;
import org.eclipse.rcptt.ecl.filesystem.internal.JavaFileResolver;
import org.eclipse.rcptt.ecl.filesystem.internal.ResourceFileResolver;

public class FileResolver {
    private static CompositeEclFileResolver resolvers = new CompositeEclFileResolver();

    static {
        try {
            resolvers.add(new ResourceFileResolver());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        resolvers.add(new JavaFileResolver());
    }

    public static void refresh(File file) {
        try {
            IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(Path.fromOSString((String)file.getAbsolutePath()));
            if (ifile != null) {
                try {
                    ifile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {}
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
    }

    public static EclFile resolve(String uri) throws CoreException {
        uri = uri.replaceAll("(/{2,})|(\\\\{1,})", "/");
        try {
            return FileResolver.resolve(new URI(uri));
        }
        catch (URISyntaxException e) {
            throw new CoreException((IStatus)EclFilesystemPlugin.createError(e, "Cannot parse URI %s", uri));
        }
    }

    public static EclFile resolve(URI uri) throws CoreException {
        if (uri == null) {
            throw new NullPointerException();
        }
        try {
            return resolvers.resolve(uri);
        }
        catch (IOException e) {
            if (e.getCause() instanceof CoreException) {
                throw (CoreException)e.getCause();
            }
            throw new CoreException((IStatus)EclFilesystemPlugin.createError(e, "Failed to resolve " + uri, new Object[0]));
        }
    }
}

