/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jdt.ui.wizards.ClasspathAttributeConfiguration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;

public class ExternalAnnotationsAttributeConfiguration
extends ClasspathAttributeConfiguration {
    @Override
    public ImageDescriptor getImageDescriptor(ClasspathAttributeConfiguration.ClasspathAttributeAccess attribute) {
        return JavaPluginImages.DESC_OBJS_EXTERNAL_ANNOTATION_LOCATION_ATTRIB;
    }

    @Override
    public String getNameLabel(ClasspathAttributeConfiguration.ClasspathAttributeAccess attribute) {
        return NewWizardMessages.CPListLabelProvider_external_annotations_location_label;
    }

    @Override
    public String getValueLabel(ClasspathAttributeConfiguration.ClasspathAttributeAccess access) {
        String arg = null;
        String str = access.getClasspathAttribute().getValue();
        if (str != null) {
            String prefix = "jar:";
            if (str.startsWith(prefix)) {
                int sepIndex = str.lastIndexOf("!/");
                if (sepIndex == -1) {
                    arg = str.substring(prefix.length());
                } else {
                    String archive = str.substring(prefix.length(), sepIndex);
                    String root = str.substring(sepIndex + 2);
                    arg = root.length() > 0 ? Messages.format(NewWizardMessages.CPListLabelProvider_twopart, new String[]{BasicElementLabels.getURLPart((String)archive), BasicElementLabels.getURLPart((String)root)}) : BasicElementLabels.getURLPart((String)archive);
                }
            } else {
                arg = BasicElementLabels.getURLPart((String)str);
            }
        } else {
            arg = NewWizardMessages.CPListLabelProvider_none;
        }
        return arg;
    }

    @Override
    public boolean canEdit(ClasspathAttributeConfiguration.ClasspathAttributeAccess attribute) {
        return true;
    }

    @Override
    public boolean canRemove(ClasspathAttributeConfiguration.ClasspathAttributeAccess attribute) {
        return attribute.getClasspathAttribute().getValue() != null;
    }

    @Override
    public IClasspathAttribute performEdit(Shell shell, ClasspathAttributeConfiguration.ClasspathAttributeAccess attribute) {
        String initialLocation = attribute.getClasspathAttribute().getValue();
        Path locationPath = initialLocation == null ? null : new Path(initialLocation);
        IPath newPath = BuildPathDialogAccess.configureExternalAnnotationsAttachment(shell, (IPath)locationPath);
        if (newPath == null) {
            return null;
        }
        return JavaCore.newClasspathAttribute((String)"annotationpath", (String)(newPath.segmentCount() == 0 ? null : newPath.toPortableString()));
    }

    @Override
    public IClasspathAttribute performRemove(ClasspathAttributeConfiguration.ClasspathAttributeAccess attribute) {
        return JavaCore.newClasspathAttribute((String)"javadoc_location", null);
    }
}

