/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.DimensionRewrite;
import org.eclipse.jdt.internal.corext.dom.JdtASTMatcher;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.fix.ControlStatementsFix;
import org.eclipse.jdt.internal.corext.fix.ConvertLoopFix;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.fix.LambdaExpressionsFix;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.fix.TypeParametersFix;
import org.eclipse.jdt.internal.corext.fix.VariableDeclarationFix;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.code.ConvertAnonymousToNestedRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.ExtractConstantRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.ExtractMethodRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.ExtractTempRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineTempRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.PromoteTempToFieldRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.util.TightSourceRangeComputer;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.fix.ControlStatementsCleanUp;
import org.eclipse.jdt.internal.ui.fix.ConvertLoopCleanUp;
import org.eclipse.jdt.internal.ui.fix.LambdaExpressionsCleanUp;
import org.eclipse.jdt.internal.ui.fix.TypeParametersCleanUp;
import org.eclipse.jdt.internal.ui.fix.VariableDeclarationCleanUp;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.correction.AdvancedQuickAssistProcessor;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.LocalCorrectionsSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.proposals.AssignToVariableAssistProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.FixCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.GenerateForLoopAssistProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedNamesAssistProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.NewDefiningMethodProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.RefactoringCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.RenameRefactoringProposal;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickAssistProcessor;
import org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.ui.text.java.correction.ChangeCorrectionProposal;
import org.eclipse.jdt.ui.text.java.correction.ICommandAccess;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;

public class QuickAssistProcessor
implements IQuickAssistProcessor {
    public static final String SPLIT_JOIN_VARIABLE_DECLARATION_ID = "org.eclipse.jdt.ui.correction.splitJoinVariableDeclaration.assist";
    public static final String CONVERT_FOR_LOOP_ID = "org.eclipse.jdt.ui.correction.convertForLoop.assist";
    public static final String ASSIGN_TO_LOCAL_ID = "org.eclipse.jdt.ui.correction.assignToLocal.assist";
    public static final String ASSIGN_TO_FIELD_ID = "org.eclipse.jdt.ui.correction.assignToField.assist";
    public static final String ASSIGN_PARAM_TO_FIELD_ID = "org.eclipse.jdt.ui.correction.assignParamToField.assist";
    public static final String ASSIGN_ALL_PARAMS_TO_NEW_FIELDS_ID = "org.eclipse.jdt.ui.correction.assignAllParamsToNewFields.assist";
    public static final String ADD_BLOCK_ID = "org.eclipse.jdt.ui.correction.addBlock.assist";
    public static final String EXTRACT_LOCAL_ID = "org.eclipse.jdt.ui.correction.extractLocal.assist";
    public static final String EXTRACT_LOCAL_NOT_REPLACE_ID = "org.eclipse.jdt.ui.correction.extractLocalNotReplaceOccurrences.assist";
    public static final String EXTRACT_CONSTANT_ID = "org.eclipse.jdt.ui.correction.extractConstant.assist";
    public static final String INLINE_LOCAL_ID = "org.eclipse.jdt.ui.correction.inlineLocal.assist";
    public static final String CONVERT_LOCAL_TO_FIELD_ID = "org.eclipse.jdt.ui.correction.convertLocalToField.assist";
    public static final String CONVERT_ANONYMOUS_TO_LOCAL_ID = "org.eclipse.jdt.ui.correction.convertAnonymousToLocal.assist";
    public static final String CONVERT_TO_STRING_BUFFER_ID = "org.eclipse.jdt.ui.correction.convertToStringBuffer.assist";
    public static final String CONVERT_TO_MESSAGE_FORMAT_ID = "org.eclipse.jdt.ui.correction.convertToMessageFormat.assist";
    public static final String EXTRACT_METHOD_INPLACE_ID = "org.eclipse.jdt.ui.correction.extractMethodInplace.assist";

    @Override
    public boolean hasAssists(IInvocationContext context) throws CoreException {
        ASTNode coveringNode = context.getCoveringNode();
        if (coveringNode != null) {
            ArrayList<ASTNode> coveredNodes = AdvancedQuickAssistProcessor.getFullyCoveredNodes(context, coveringNode);
            return QuickAssistProcessor.getCatchClauseToThrowsProposals(context, coveringNode, null) || QuickAssistProcessor.getPickoutTypeFromMulticatchProposals(context, coveringNode, coveredNodes, null) || QuickAssistProcessor.getConvertToMultiCatchProposals(context, coveringNode, null) || QuickAssistProcessor.getUnrollMultiCatchProposals(context, coveringNode, null) || QuickAssistProcessor.getRenameLocalProposals(context, coveringNode, null, null) || QuickAssistProcessor.getRenameRefactoringProposal(context, coveringNode, null, null) || QuickAssistProcessor.getAssignToVariableProposals(context, coveringNode, null, null) || QuickAssistProcessor.getUnWrapProposals(context, coveringNode, null) || QuickAssistProcessor.getAssignParamToFieldProposals(context, coveringNode, null) || QuickAssistProcessor.getAssignAllParamsToFieldsProposals(context, coveringNode, null) || QuickAssistProcessor.getJoinVariableProposals(context, coveringNode, null) || QuickAssistProcessor.getAddFinallyProposals(context, coveringNode, null) || QuickAssistProcessor.getAddElseProposals(context, coveringNode, null) || QuickAssistProcessor.getSplitVariableProposals(context, coveringNode, null) || QuickAssistProcessor.getAddBlockProposals(context, coveringNode, null) || QuickAssistProcessor.getArrayInitializerToArrayCreation(context, coveringNode, null) || QuickAssistProcessor.getCreateInSuperClassProposals(context, coveringNode, null) || QuickAssistProcessor.getInvertEqualsProposal(context, coveringNode, null) || QuickAssistProcessor.getConvertForLoopProposal(context, coveringNode, null) || QuickAssistProcessor.getConvertIterableLoopProposal(context, coveringNode, null) || QuickAssistProcessor.getConvertEnhancedForLoopProposal(context, coveringNode, null) || QuickAssistProcessor.getGenerateForLoopProposals(context, coveringNode, null, null) || QuickAssistProcessor.getExtractVariableProposal(context, false, null) || QuickAssistProcessor.getExtractMethodProposal(context, coveringNode, false, null) || QuickAssistProcessor.getInlineLocalProposal(context, coveringNode, null) || QuickAssistProcessor.getConvertLocalToFieldProposal(context, coveringNode, null) || QuickAssistProcessor.getConvertAnonymousToNestedProposal(context, coveringNode, null) || QuickAssistProcessor.getConvertAnonymousClassCreationsToLambdaProposals(context, coveringNode, null) || QuickAssistProcessor.getConvertLambdaToAnonymousClassCreationsProposals(context, coveringNode, null) || QuickAssistProcessor.getChangeLambdaBodyToBlockProposal(context, coveringNode, null) || QuickAssistProcessor.getChangeLambdaBodyToExpressionProposal(context, coveringNode, null) || QuickAssistProcessor.getAddInferredLambdaParameterTypes(context, coveringNode, null) || QuickAssistProcessor.getConvertMethodReferenceToLambdaProposal(context, coveringNode, null) || QuickAssistProcessor.getConvertLambdaToMethodReferenceProposal(context, coveringNode, null) || QuickAssistProcessor.getFixParenthesesInLambdaExpression(context, coveringNode, null) || QuickAssistProcessor.getRemoveBlockProposals(context, coveringNode, null) || QuickAssistProcessor.getMakeVariableDeclarationFinalProposals(context, null) || QuickAssistProcessor.getMissingCaseStatementProposals(context, coveringNode, null) || QuickAssistProcessor.getConvertStringConcatenationProposals(context, null) || QuickAssistProcessor.getInferDiamondArgumentsProposal(context, coveringNode, null, null);
        }
        return false;
    }

    @Override
    public IJavaCompletionProposal[] getAssists(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ASTNode coveringNode = context.getCoveringNode();
        if (coveringNode != null) {
            ArrayList<ASTNode> coveredNodes = AdvancedQuickAssistProcessor.getFullyCoveredNodes(context, coveringNode);
            ArrayList<ICommandAccess> resultingCollections = new ArrayList<ICommandAccess>();
            boolean noErrorsAtLocation = QuickAssistProcessor.noErrorsAtLocation(locations);
            QuickAssistProcessor.getRenameLocalProposals(context, coveringNode, locations, resultingCollections);
            QuickAssistProcessor.getRenameRefactoringProposal(context, coveringNode, locations, resultingCollections);
            QuickAssistProcessor.getAssignToVariableProposals(context, coveringNode, locations, resultingCollections);
            QuickAssistProcessor.getAssignParamToFieldProposals(context, coveringNode, resultingCollections);
            QuickAssistProcessor.getAssignAllParamsToFieldsProposals(context, coveringNode, resultingCollections);
            QuickAssistProcessor.getInferDiamondArgumentsProposal(context, coveringNode, locations, resultingCollections);
            QuickAssistProcessor.getGenerateForLoopProposals(context, coveringNode, locations, resultingCollections);
            if (noErrorsAtLocation) {
                boolean problemsAtLocation = locations.length != 0;
                QuickAssistProcessor.getCatchClauseToThrowsProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getPickoutTypeFromMulticatchProposals(context, coveringNode, coveredNodes, resultingCollections);
                QuickAssistProcessor.getConvertToMultiCatchProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getUnrollMultiCatchProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getUnWrapProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getJoinVariableProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getSplitVariableProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getAddFinallyProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getAddElseProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getAddBlockProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getInvertEqualsProposal(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getArrayInitializerToArrayCreation(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getCreateInSuperClassProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getExtractVariableProposal(context, problemsAtLocation, resultingCollections);
                QuickAssistProcessor.getExtractMethodProposal(context, coveringNode, problemsAtLocation, resultingCollections);
                QuickAssistProcessor.getInlineLocalProposal(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getConvertLocalToFieldProposal(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getConvertAnonymousToNestedProposal(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getConvertAnonymousClassCreationsToLambdaProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getConvertLambdaToAnonymousClassCreationsProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getChangeLambdaBodyToBlockProposal(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getChangeLambdaBodyToExpressionProposal(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getAddInferredLambdaParameterTypes(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getConvertMethodReferenceToLambdaProposal(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getConvertLambdaToMethodReferenceProposal(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getFixParenthesesInLambdaExpression(context, coveringNode, resultingCollections);
                if (!QuickAssistProcessor.getConvertForLoopProposal(context, coveringNode, resultingCollections)) {
                    QuickAssistProcessor.getConvertIterableLoopProposal(context, coveringNode, resultingCollections);
                }
                QuickAssistProcessor.getConvertEnhancedForLoopProposal(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getRemoveBlockProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getMakeVariableDeclarationFinalProposals(context, resultingCollections);
                QuickAssistProcessor.getConvertStringConcatenationProposals(context, resultingCollections);
                QuickAssistProcessor.getMissingCaseStatementProposals(context, coveringNode, resultingCollections);
            }
            return resultingCollections.toArray(new IJavaCompletionProposal[resultingCollections.size()]);
        }
        return null;
    }

    static boolean noErrorsAtLocation(IProblemLocation[] locations) {
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                IProblemLocation location = locations[i];
                if (location.isError() && (!"org.eclipse.jdt.core.problem".equals(location.getMarkerType()) || JavaCore.getOptionForConfigurableSeverity((int)location.getProblemId()) == null)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static int getIndex(int offset, List<Statement> statements) {
        int i = 0;
        while (i < statements.size()) {
            Statement s = statements.get(i);
            if (offset <= s.getStartPosition()) {
                return i;
            }
            if (offset < s.getStartPosition() + s.getLength()) {
                return -1;
            }
            ++i;
        }
        return statements.size();
    }

    private static boolean getExtractMethodProposal(IInvocationContext context, ASTNode coveringNode, boolean problemsAtLocation, Collection<ICommandAccess> proposals) throws CoreException {
        if (!(coveringNode instanceof Expression || coveringNode instanceof Statement || coveringNode instanceof Block)) {
            return false;
        }
        if (coveringNode instanceof Block) {
            List statements = ((Block)coveringNode).statements();
            int startIndex = QuickAssistProcessor.getIndex(context.getSelectionOffset(), statements);
            if (startIndex == -1) {
                return false;
            }
            int endIndex = QuickAssistProcessor.getIndex(context.getSelectionOffset() + context.getSelectionLength(), statements);
            if (endIndex == -1 || endIndex <= startIndex) {
                return false;
            }
        }
        if (proposals == null) {
            return true;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        ExtractMethodRefactoring extractMethodRefactoring = new ExtractMethodRefactoring(context.getASTRoot(), context.getSelectionOffset(), context.getSelectionLength());
        extractMethodRefactoring.setMethodName("extracted");
        if (extractMethodRefactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            String label = CorrectionMessages.QuickAssistProcessor_extractmethod_description;
            LinkedProposalModel linkedProposalModel = new LinkedProposalModel();
            extractMethodRefactoring.setLinkedProposalModel(linkedProposalModel);
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.methpub_obj.gif");
            int relevance = problemsAtLocation ? 1 : 4;
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, cu, extractMethodRefactoring, relevance, image);
            proposal.setCommandId(EXTRACT_METHOD_INPLACE_ID);
            proposal.setLinkedProposalModel(linkedProposalModel);
            proposals.add(proposal);
        }
        return true;
    }

    private static boolean getExtractVariableProposal(IInvocationContext context, boolean problemsAtLocation, Collection<ICommandAccess> proposals) throws CoreException {
        ExtractConstantRefactoring extractConstRefactoring;
        Expression expression;
        ITypeBinding binding;
        ASTNode node = context.getCoveredNode();
        if (!(node instanceof Expression)) {
            if (context.getSelectionLength() != 0) {
                return false;
            }
            node = context.getCoveringNode();
            if (!(node instanceof Expression)) {
                return false;
            }
        }
        if ((binding = (expression = (Expression)node).resolveTypeBinding()) == null || Bindings.isVoidType((ITypeBinding)binding)) {
            return false;
        }
        if (proposals == null) {
            return true;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        ExtractTempRefactoring extractTempRefactoring = new ExtractTempRefactoring(context.getASTRoot(), context.getSelectionOffset(), context.getSelectionLength());
        if (extractTempRefactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            extractTempRefactoring.setReplaceAllOccurrences(true);
            LinkedProposalModel linkedProposalModel = new LinkedProposalModel();
            extractTempRefactoring.setLinkedProposalModel(linkedProposalModel);
            extractTempRefactoring.setCheckResultForCompileProblems(false);
            String label = CorrectionMessages.QuickAssistProcessor_extract_to_local_all_description;
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif");
            int relevance = context.getSelectionLength() == 0 ? 0 : (problemsAtLocation ? 3 : 6);
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, cu, extractTempRefactoring, relevance, image){

                @Override
                protected void init(Refactoring refactoring) throws CoreException {
                    ExtractTempRefactoring etr = (ExtractTempRefactoring)refactoring;
                    etr.setTempName(etr.guessTempName());
                }
            };
            proposal.setCommandId(EXTRACT_LOCAL_ID);
            proposal.setLinkedProposalModel(linkedProposalModel);
            proposals.add(proposal);
        }
        ExtractTempRefactoring extractTempRefactoringSelectedOnly = new ExtractTempRefactoring(context.getASTRoot(), context.getSelectionOffset(), context.getSelectionLength());
        extractTempRefactoringSelectedOnly.setReplaceAllOccurrences(false);
        if (extractTempRefactoringSelectedOnly.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            LinkedProposalModel linkedProposalModel = new LinkedProposalModel();
            extractTempRefactoringSelectedOnly.setLinkedProposalModel(linkedProposalModel);
            extractTempRefactoringSelectedOnly.setCheckResultForCompileProblems(false);
            String label = CorrectionMessages.QuickAssistProcessor_extract_to_local_description;
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif");
            int relevance = context.getSelectionLength() == 0 ? -1 : (problemsAtLocation ? 2 : 5);
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, cu, extractTempRefactoringSelectedOnly, relevance, image){

                @Override
                protected void init(Refactoring refactoring) throws CoreException {
                    ExtractTempRefactoring etr = (ExtractTempRefactoring)refactoring;
                    etr.setTempName(etr.guessTempName());
                }
            };
            proposal.setCommandId(EXTRACT_LOCAL_NOT_REPLACE_ID);
            proposal.setLinkedProposalModel(linkedProposalModel);
            proposals.add(proposal);
        }
        if ((extractConstRefactoring = new ExtractConstantRefactoring(context.getASTRoot(), context.getSelectionOffset(), context.getSelectionLength())).checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            LinkedProposalModel linkedProposalModel = new LinkedProposalModel();
            extractConstRefactoring.setLinkedProposalModel(linkedProposalModel);
            extractConstRefactoring.setCheckResultForCompileProblems(false);
            String label = CorrectionMessages.QuickAssistProcessor_extract_to_constant_description;
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif");
            int relevance = context.getSelectionLength() == 0 ? -2 : (problemsAtLocation ? 1 : 4);
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, cu, extractConstRefactoring, relevance, image){

                @Override
                protected void init(Refactoring refactoring) throws CoreException {
                    ExtractConstantRefactoring etr = (ExtractConstantRefactoring)refactoring;
                    etr.setConstantName(etr.guessConstantName());
                }
            };
            proposal.setCommandId(EXTRACT_CONSTANT_ID);
            proposal.setLinkedProposalModel(linkedProposalModel);
            proposals.add(proposal);
        }
        return false;
    }

    private static boolean getConvertAnonymousToNestedProposal(IInvocationContext context, ASTNode node, Collection<ICommandAccess> proposals) throws CoreException {
        if (!(node instanceof Name)) {
            return false;
        }
        ASTNode normalized = ASTNodes.getNormalizedNode((ASTNode)node);
        if (normalized.getLocationInParent() != ClassInstanceCreation.TYPE_PROPERTY) {
            return false;
        }
        AnonymousClassDeclaration anonymTypeDecl = ((ClassInstanceCreation)normalized.getParent()).getAnonymousClassDeclaration();
        if (anonymTypeDecl == null || anonymTypeDecl.resolveBinding() == null) {
            return false;
        }
        if (proposals == null) {
            return true;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        ConvertAnonymousToNestedRefactoring refactoring = new ConvertAnonymousToNestedRefactoring(anonymTypeDecl);
        String extTypeName = ASTNodes.getSimpleNameIdentifier((Name)((Name)node));
        ITypeBinding anonymTypeBinding = anonymTypeDecl.resolveBinding();
        String className = anonymTypeBinding.getInterfaces().length == 0 ? Messages.format(CorrectionMessages.QuickAssistProcessor_name_extension_from_interface, extTypeName) : Messages.format(CorrectionMessages.QuickAssistProcessor_name_extension_from_class, extTypeName);
        String[][] existingTypes = ((IType)anonymTypeBinding.getJavaElement()).resolveType(className);
        int i = 1;
        while (existingTypes != null) {
            existingTypes = ((IType)anonymTypeBinding.getJavaElement()).resolveType(String.valueOf(className) + ++i);
        }
        refactoring.setClassName(i == 1 ? className : String.valueOf(className) + i);
        if (refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            LinkedProposalModel linkedProposalModel = new LinkedProposalModel();
            refactoring.setLinkedProposalModel(linkedProposalModel);
            String label = CorrectionMessages.QuickAssistProcessor_convert_anonym_to_nested;
            Image image = JavaPlugin.getImageDescriptorRegistry().get(JavaElementImageProvider.getTypeImageDescriptor(true, false, 2, false));
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, cu, refactoring, 5, image);
            proposal.setLinkedProposalModel(linkedProposalModel);
            proposal.setCommandId(CONVERT_ANONYMOUS_TO_LOCAL_ID);
            proposals.add(proposal);
        }
        return false;
    }

    private static boolean getConvertAnonymousClassCreationsToLambdaProposals(IInvocationContext context, ASTNode covering, Collection<ICommandAccess> resultingCollections) {
        ClassInstanceCreation cic;
        while (covering instanceof Name || covering instanceof Type || covering instanceof Dimension || covering.getParent() instanceof MethodDeclaration || covering.getLocationInParent() == AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY) {
            covering = covering.getParent();
        }
        if (covering instanceof ClassInstanceCreation) {
            cic = (ClassInstanceCreation)covering;
        } else if (covering.getLocationInParent() == ClassInstanceCreation.ANONYMOUS_CLASS_DECLARATION_PROPERTY) {
            cic = (ClassInstanceCreation)covering.getParent();
        } else if (covering instanceof Name) {
            ASTNode normalized = ASTNodes.getNormalizedNode((ASTNode)covering);
            if (normalized.getLocationInParent() != ClassInstanceCreation.TYPE_PROPERTY) {
                return false;
            }
            cic = (ClassInstanceCreation)normalized.getParent();
        } else {
            return false;
        }
        LambdaExpressionsFix fix = LambdaExpressionsFix.createConvertToLambdaFix(cic);
        if (fix == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("cleanup.convert_functional_interfaces", "true");
        options.put("cleanup.use_lambda", "true");
        FixCorrectionProposal proposal = new FixCorrectionProposal(fix, new LambdaExpressionsCleanUp(options), 6, image, context);
        resultingCollections.add(proposal);
        return true;
    }

    public static boolean getConvertLambdaToAnonymousClassCreationsProposals(IInvocationContext context, ASTNode covering, Collection<ICommandAccess> resultingCollections) {
        LambdaExpression lambda;
        if (covering instanceof LambdaExpression) {
            lambda = (LambdaExpression)covering;
        } else if (covering.getLocationInParent() == LambdaExpression.BODY_PROPERTY) {
            lambda = (LambdaExpression)covering.getParent();
        } else {
            return false;
        }
        IProposableFix fix = LambdaExpressionsFix.createConvertToAnonymousClassCreationsFix(lambda);
        if (fix == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("cleanup.convert_functional_interfaces", "true");
        options.put("cleanup.use_anonymous_class_creation", "true");
        FixCorrectionProposal proposal = new FixCorrectionProposal(fix, new LambdaExpressionsCleanUp(options), 2, image, context);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getConvertMethodReferenceToLambdaProposal(IInvocationContext context, ASTNode covering, Collection<ICommandAccess> resultingCollections) throws JavaModelException {
        MethodReference methodReference;
        if (covering instanceof MethodReference) {
            methodReference = (MethodReference)covering;
        } else if (covering.getParent() instanceof MethodReference) {
            methodReference = (MethodReference)covering.getParent();
        } else {
            return false;
        }
        IMethodBinding functionalMethod = QuickAssistProcessor.getFunctionalMethodForMethodReference(methodReference);
        if (functionalMethod == null || functionalMethod.isGenericMethod()) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)methodReference.getAST());
        LinkedProposalModel linkedProposalModel = new LinkedProposalModel();
        LambdaExpression lambda = QuickAssistProcessor.convertMethodRefernceToLambda(methodReference, functionalMethod, context.getASTRoot(), rewrite, linkedProposalModel, false);
        String label = CorrectionMessages.QuickAssistProcessor_convert_to_lambda_expression;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, context.getCompilationUnit(), rewrite, 6, image);
        proposal.setLinkedProposalModel(linkedProposalModel);
        proposal.setEndPosition(rewrite.track((ASTNode)lambda));
        resultingCollections.add(proposal);
        return true;
    }

    public static IMethodBinding getFunctionalMethodForMethodReference(MethodReference methodReference) {
        ITypeBinding targetTypeBinding = ASTNodes.getTargetType((Expression)methodReference);
        if (targetTypeBinding == null) {
            return null;
        }
        IMethodBinding functionalMethod = targetTypeBinding.getFunctionalInterfaceMethod();
        if (functionalMethod.isSynthetic()) {
            functionalMethod = Bindings.findOverriddenMethodInType((ITypeBinding)functionalMethod.getDeclaringClass(), (IMethodBinding)functionalMethod);
        }
        return functionalMethod;
    }

    public static LambdaExpression convertMethodRefernceToLambda(MethodReference methodReference, IMethodBinding functionalMethod, CompilationUnit astRoot, ASTRewrite rewrite, LinkedProposalModel linkedProposalModel, boolean createBlockBody) throws JavaModelException {
        MethodInvocation methodInvocation;
        AST ast = astRoot.getAST();
        LambdaExpression lambda = ast.newLambdaExpression();
        String[] lambdaParamNames = QuickAssistProcessor.getUniqueParameterNames(methodReference, functionalMethod);
        List lambdaParameters = lambda.parameters();
        int i = 0;
        while (i < lambdaParamNames.length) {
            String paramName = lambdaParamNames[i];
            VariableDeclarationFragment lambdaParameter = ast.newVariableDeclarationFragment();
            SimpleName name = ast.newSimpleName(paramName);
            lambdaParameter.setName(name);
            lambdaParameters.add(lambdaParameter);
            if (linkedProposalModel != null) {
                linkedProposalModel.getPositionGroup(name.getIdentifier(), true).addPosition(rewrite.track((ASTNode)name), i == 0);
            }
            ++i;
        }
        int noOfLambdaParameters = lambdaParamNames.length;
        lambda.setParentheses(noOfLambdaParameters != 1);
        ITypeBinding returnTypeBinding = functionalMethod.getReturnType();
        IMethodBinding referredMethodBinding = methodReference.resolveMethodBinding();
        if (methodReference instanceof CreationReference) {
            CreationReference creationRef = (CreationReference)methodReference;
            Type type = creationRef.getType();
            if (type instanceof ArrayType) {
                ArrayCreation arrayCreation = ast.newArrayCreation();
                if (createBlockBody) {
                    Block blockBody = QuickAssistProcessor.getBlockBodyForLambda((Expression)arrayCreation, returnTypeBinding, ast);
                    lambda.setBody((ASTNode)blockBody);
                } else {
                    lambda.setBody((ASTNode)arrayCreation);
                }
                ArrayType arrayType = (ArrayType)type;
                Type copiedElementType = (Type)rewrite.createCopyTarget((ASTNode)arrayType.getElementType());
                arrayCreation.setType(ast.newArrayType(copiedElementType, arrayType.getDimensions()));
                SimpleName name = ast.newSimpleName(lambdaParamNames[0]);
                arrayCreation.dimensions().add(name);
                if (linkedProposalModel != null) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            } else {
                ClassInstanceCreation cic = ast.newClassInstanceCreation();
                if (createBlockBody) {
                    Block blockBody = QuickAssistProcessor.getBlockBodyForLambda((Expression)cic, returnTypeBinding, ast);
                    lambda.setBody((ASTNode)blockBody);
                } else {
                    lambda.setBody((ASTNode)cic);
                }
                ITypeBinding typeBinding = type.resolveBinding();
                if (!(type instanceof ParameterizedType) && typeBinding != null && typeBinding.getTypeDeclaration().isGenericType()) {
                    cic.setType((Type)ast.newParameterizedType((Type)rewrite.createCopyTarget((ASTNode)type)));
                } else {
                    cic.setType((Type)rewrite.createCopyTarget((ASTNode)type));
                }
                List<SimpleName> invocationArgs = QuickAssistProcessor.getInvocationArguments(ast, 0, noOfLambdaParameters, lambdaParamNames);
                cic.arguments().addAll(invocationArgs);
                if (linkedProposalModel != null) {
                    for (SimpleName name : invocationArgs) {
                        linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                    }
                }
                cic.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
            }
        } else if (referredMethodBinding != null && Modifier.isStatic((int)referredMethodBinding.getModifiers())) {
            methodInvocation = ast.newMethodInvocation();
            if (createBlockBody) {
                Block blockBody = QuickAssistProcessor.getBlockBodyForLambda((Expression)methodInvocation, returnTypeBinding, ast);
                lambda.setBody((ASTNode)blockBody);
            } else {
                lambda.setBody((ASTNode)methodInvocation);
            }
            Expression expr = null;
            boolean hasConflict = QuickAssistProcessor.hasConflict(methodReference.getStartPosition(), referredMethodBinding, 17, astRoot);
            if (hasConflict || !Bindings.isSuperType((ITypeBinding)referredMethodBinding.getDeclaringClass(), (ITypeBinding)ASTNodes.getEnclosingType((ASTNode)methodReference)) || methodReference.typeArguments().size() != 0) {
                Type type;
                ITypeBinding typeBinding;
                if (methodReference instanceof ExpressionMethodReference) {
                    ExpressionMethodReference expressionMethodReference = (ExpressionMethodReference)methodReference;
                    expr = (Expression)rewrite.createCopyTarget((ASTNode)expressionMethodReference.getExpression());
                } else if (methodReference instanceof TypeMethodReference && (typeBinding = (type = ((TypeMethodReference)methodReference).getType()).resolveBinding()) != null) {
                    ImportRewrite importRewrite = StubUtility.createImportRewrite(astRoot, true);
                    expr = ast.newName(importRewrite.addImport(typeBinding));
                }
            }
            methodInvocation.setExpression(expr);
            SimpleName methodName = QuickAssistProcessor.getMethodInvocationName(methodReference);
            methodInvocation.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodName));
            List<SimpleName> invocationArgs = QuickAssistProcessor.getInvocationArguments(ast, 0, noOfLambdaParameters, lambdaParamNames);
            methodInvocation.arguments().addAll(invocationArgs);
            if (linkedProposalModel != null) {
                for (SimpleName name : invocationArgs) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            }
            methodInvocation.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
        } else if (methodReference instanceof SuperMethodReference) {
            SuperMethodInvocation superMethodInvocation = ast.newSuperMethodInvocation();
            if (createBlockBody) {
                Block blockBody = QuickAssistProcessor.getBlockBodyForLambda((Expression)superMethodInvocation, returnTypeBinding, ast);
                lambda.setBody((ASTNode)blockBody);
            } else {
                lambda.setBody((ASTNode)superMethodInvocation);
            }
            Name superQualifier = ((SuperMethodReference)methodReference).getQualifier();
            if (superQualifier != null) {
                superMethodInvocation.setQualifier((Name)rewrite.createCopyTarget((ASTNode)superQualifier));
            }
            SimpleName methodName = QuickAssistProcessor.getMethodInvocationName(methodReference);
            superMethodInvocation.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodName));
            List<SimpleName> invocationArgs = QuickAssistProcessor.getInvocationArguments(ast, 0, noOfLambdaParameters, lambdaParamNames);
            superMethodInvocation.arguments().addAll(invocationArgs);
            if (linkedProposalModel != null) {
                for (SimpleName name : invocationArgs) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            }
            superMethodInvocation.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
        } else {
            methodInvocation = ast.newMethodInvocation();
            if (createBlockBody) {
                Block blockBody = QuickAssistProcessor.getBlockBodyForLambda((Expression)methodInvocation, returnTypeBinding, ast);
                lambda.setBody((ASTNode)blockBody);
            } else {
                lambda.setBody((ASTNode)methodInvocation);
            }
            boolean isTypeReference = QuickAssistProcessor.isTypeReferenceToInstanceMethod(methodReference);
            if (isTypeReference) {
                SimpleName name = ast.newSimpleName(lambdaParamNames[0]);
                methodInvocation.setExpression((Expression)name);
                if (linkedProposalModel != null) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            } else {
                Expression expr = ((ExpressionMethodReference)methodReference).getExpression();
                if (!(expr instanceof ThisExpression) || methodReference.typeArguments().size() != 0) {
                    methodInvocation.setExpression((Expression)rewrite.createCopyTarget((ASTNode)expr));
                }
            }
            SimpleName methodName = QuickAssistProcessor.getMethodInvocationName(methodReference);
            methodInvocation.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodName));
            List<SimpleName> invocationArgs = QuickAssistProcessor.getInvocationArguments(ast, isTypeReference ? 1 : 0, noOfLambdaParameters, lambdaParamNames);
            methodInvocation.arguments().addAll(invocationArgs);
            if (linkedProposalModel != null) {
                for (SimpleName name : invocationArgs) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            }
            methodInvocation.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
        }
        rewrite.replace((ASTNode)methodReference, (ASTNode)lambda, null);
        return lambda;
    }

    private static boolean hasConflict(int startPosition, IMethodBinding referredMethodBinding, int flags, CompilationUnit cu) {
        ScopeAnalyzer analyzer = new ScopeAnalyzer(cu);
        IBinding[] declarationsInScope = analyzer.getDeclarationsInScope(startPosition, flags);
        int i = 0;
        while (i < declarationsInScope.length) {
            IBinding decl = declarationsInScope[i];
            if (decl.getName().equals(referredMethodBinding.getName()) && !referredMethodBinding.getMethodDeclaration().isEqualTo(decl)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String[] getUniqueParameterNames(MethodReference methodReference, IMethodBinding functionalMethod) throws JavaModelException {
        String[] parameterNames = ((IMethod)functionalMethod.getJavaElement()).getParameterNames();
        ArrayList<String> oldNames = new ArrayList<String>(Arrays.asList(parameterNames));
        String[] newNames = new String[oldNames.size()];
        ArrayList<String> excludedNames = new ArrayList<String>(ASTNodes.getVisibleLocalVariablesInScope((ASTNode)methodReference));
        int i = 0;
        while (i < oldNames.size()) {
            String paramName = (String)oldNames.get(i);
            ArrayList<String> allNamesToExclude = new ArrayList<String>(excludedNames);
            allNamesToExclude.addAll(oldNames.subList(0, i));
            allNamesToExclude.addAll(oldNames.subList(i + 1, oldNames.size()));
            if (allNamesToExclude.contains(paramName)) {
                String newParamName = QuickAssistProcessor.createName(paramName, allNamesToExclude);
                excludedNames.add(newParamName);
                newNames[i] = newParamName;
            } else {
                newNames[i] = paramName;
            }
            ++i;
        }
        return newNames;
    }

    private static String createName(String candidate, List<String> excludedNames) {
        int i = 1;
        String result = candidate;
        while (excludedNames.contains(result)) {
            result = String.valueOf(candidate) + i++;
        }
        return result;
    }

    private static boolean isTypeReferenceToInstanceMethod(MethodReference methodReference) {
        IBinding nameBinding;
        Expression expression;
        if (methodReference instanceof TypeMethodReference) {
            return true;
        }
        return methodReference instanceof ExpressionMethodReference && (expression = ((ExpressionMethodReference)methodReference).getExpression()) instanceof Name && (nameBinding = ((Name)expression).resolveBinding()) != null && nameBinding instanceof ITypeBinding;
    }

    private static List<SimpleName> getInvocationArguments(AST ast, int begIndex, int noOfLambdaParameters, String[] lambdaParamNames) {
        ArrayList<SimpleName> args = new ArrayList<SimpleName>();
        int i = begIndex;
        while (i < noOfLambdaParameters) {
            args.add(ast.newSimpleName(lambdaParamNames[i]));
            ++i;
        }
        return args;
    }

    private static List<Type> getCopiedTypeArguments(ASTRewrite rewrite, List<Type> typeArguments) {
        ArrayList<Type> copiedTypeArgs = new ArrayList<Type>();
        for (Type typeArg : typeArguments) {
            copiedTypeArgs.add((Type)rewrite.createCopyTarget((ASTNode)typeArg));
        }
        return copiedTypeArgs;
    }

    private static SimpleName getMethodInvocationName(MethodReference methodReference) {
        SimpleName name = null;
        if (methodReference instanceof ExpressionMethodReference) {
            name = ((ExpressionMethodReference)methodReference).getName();
        } else if (methodReference instanceof TypeMethodReference) {
            name = ((TypeMethodReference)methodReference).getName();
        } else if (methodReference instanceof SuperMethodReference) {
            name = ((SuperMethodReference)methodReference).getName();
        }
        return name;
    }

    private static boolean getChangeLambdaBodyToBlockProposal(IInvocationContext context, ASTNode covering, Collection<ICommandAccess> resultingCollections) {
        LambdaExpression lambda;
        if (covering instanceof LambdaExpression) {
            lambda = (LambdaExpression)covering;
        } else if (covering.getLocationInParent() == LambdaExpression.BODY_PROPERTY) {
            lambda = (LambdaExpression)covering.getParent();
        } else {
            return false;
        }
        if (!(lambda.getBody() instanceof Expression)) {
            return false;
        }
        if (lambda.resolveMethodBinding() == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = lambda.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        QuickAssistProcessor.changeLambdaBodyToBlock(lambda, ast, rewrite);
        String label = CorrectionMessages.QuickAssistProcessor_change_lambda_body_to_block;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 3, image);
        resultingCollections.add(proposal);
        return true;
    }

    public static void changeLambdaBodyToBlock(LambdaExpression lambda, AST ast, ASTRewrite rewrite) {
        Expression bodyExpr = (Expression)rewrite.createMoveTarget(lambda.getBody());
        Block blockBody = QuickAssistProcessor.getBlockBodyForLambda(bodyExpr, lambda.resolveMethodBinding().getReturnType(), ast);
        rewrite.set((ASTNode)lambda, (StructuralPropertyDescriptor)LambdaExpression.BODY_PROPERTY, (Object)blockBody, null);
    }

    private static Block getBlockBodyForLambda(Expression bodyExpr, ITypeBinding returnTypeBinding, AST ast) {
        ExpressionStatement statementInBlockBody;
        if (ast.resolveWellKnownType("void").isEqualTo((IBinding)returnTypeBinding)) {
            ExpressionStatement expressionStatement;
            statementInBlockBody = expressionStatement = ast.newExpressionStatement(bodyExpr);
        } else {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(bodyExpr);
            statementInBlockBody = returnStatement;
        }
        Block blockBody = ast.newBlock();
        blockBody.statements().add(statementInBlockBody);
        return blockBody;
    }

    private static boolean getChangeLambdaBodyToExpressionProposal(IInvocationContext context, ASTNode covering, Collection<ICommandAccess> resultingCollections) {
        LambdaExpression lambda;
        if (covering instanceof LambdaExpression) {
            lambda = (LambdaExpression)covering;
        } else if (covering.getLocationInParent() == LambdaExpression.BODY_PROPERTY) {
            lambda = (LambdaExpression)covering.getParent();
        } else {
            return false;
        }
        if (!(lambda.getBody() instanceof Block)) {
            return false;
        }
        Block lambdaBody = (Block)lambda.getBody();
        Expression exprBody = QuickAssistProcessor.getSingleExpressionFromLambdaBody(lambdaBody);
        if (exprBody == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = lambda.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Expression movedBody = (Expression)rewrite.createMoveTarget((ASTNode)exprBody);
        rewrite.set((ASTNode)lambda, (StructuralPropertyDescriptor)LambdaExpression.BODY_PROPERTY, (Object)movedBody, null);
        String label = CorrectionMessages.QuickAssistProcessor_change_lambda_body_to_expression;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 3, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static Expression getSingleExpressionFromLambdaBody(Block lambdaBody) {
        Expression expression;
        if (lambdaBody.statements().size() != 1) {
            return null;
        }
        Statement singleStatement = (Statement)lambdaBody.statements().get(0);
        if (singleStatement instanceof ReturnStatement) {
            return ((ReturnStatement)singleStatement).getExpression();
        }
        if (singleStatement instanceof ExpressionStatement && QuickAssistProcessor.isValidLambdaExpressionBody(expression = ((ExpressionStatement)singleStatement).getExpression())) {
            return expression;
        }
        return null;
    }

    private static boolean isValidLambdaExpressionBody(Expression expression) {
        PrefixExpression.Operator operator;
        if (expression instanceof Assignment || expression instanceof ClassInstanceCreation || expression instanceof MethodInvocation || expression instanceof PostfixExpression || expression instanceof SuperMethodInvocation) {
            return true;
        }
        return expression instanceof PrefixExpression && ((operator = ((PrefixExpression)expression).getOperator()) == PrefixExpression.Operator.INCREMENT || operator == PrefixExpression.Operator.DECREMENT);
    }

    private static boolean getConvertLambdaToMethodReferenceProposal(IInvocationContext context, ASTNode coveringNode, Collection<ICommandAccess> resultingCollections) {
        IMethodBinding methodBinding;
        CreationReference replacement;
        CreationReference creationReference;
        IMethodBinding methodBinding2;
        LambdaExpression lambda;
        if (coveringNode instanceof LambdaExpression) {
            lambda = (LambdaExpression)coveringNode;
        } else if (coveringNode.getLocationInParent() == LambdaExpression.BODY_PROPERTY) {
            lambda = (LambdaExpression)coveringNode.getParent();
        } else {
            lambda = ASTResolving.findEnclosingLambdaExpression((ASTNode)coveringNode);
            if (lambda == null) {
                return false;
            }
        }
        ASTNode lambdaBody = lambda.getBody();
        Expression exprBody = lambdaBody instanceof Block ? QuickAssistProcessor.getSingleExpressionFromLambdaBody((Block)lambdaBody) : (Expression)lambdaBody;
        while (exprBody instanceof ParenthesizedExpression) {
            exprBody = ((ParenthesizedExpression)exprBody).getExpression();
        }
        if (exprBody == null || !QuickAssistProcessor.isValidLambdaReferenceToMethod(exprBody)) {
            return false;
        }
        if (!ASTNodes.isParent((ASTNode)exprBody, (ASTNode)coveringNode) && !QuickAssistProcessor.representsDefiningNode(coveringNode, (ASTNode)exprBody)) {
            return false;
        }
        ArrayList<Expression> lambdaParameters = new ArrayList<Expression>();
        for (VariableDeclaration param : lambda.parameters()) {
            lambdaParameters.add((Expression)param.getName());
        }
        if (exprBody instanceof ClassInstanceCreation) {
            ClassInstanceCreation cic = (ClassInstanceCreation)exprBody;
            if (cic.getExpression() != null || cic.getAnonymousClassDeclaration() != null) {
                return false;
            }
            if (!QuickAssistProcessor.matches(lambdaParameters, cic.arguments())) {
                return false;
            }
        } else if (exprBody instanceof ArrayCreation) {
            List dimensions = ((ArrayCreation)exprBody).dimensions();
            if (dimensions.size() != 1) {
                return false;
            }
            if (!QuickAssistProcessor.matches(lambdaParameters, dimensions)) {
                return false;
            }
        } else if (exprBody instanceof SuperMethodInvocation) {
            ITypeBinding invocationTypeBinding;
            SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)exprBody;
            methodBinding2 = superMethodInvocation.resolveMethodBinding();
            if (methodBinding2 == null) {
                return false;
            }
            if (Modifier.isStatic((int)methodBinding2.getModifiers()) && (invocationTypeBinding = ASTNodes.getInvocationType((ASTNode)superMethodInvocation, (IMethodBinding)methodBinding2, (Expression)superMethodInvocation.getQualifier())) == null) {
                return false;
            }
            if (!QuickAssistProcessor.matches(lambdaParameters, superMethodInvocation.arguments())) {
                return false;
            }
        } else {
            ITypeBinding invocationTypeBinding;
            MethodInvocation methodInvocation = (MethodInvocation)exprBody;
            methodBinding2 = methodInvocation.resolveMethodBinding();
            if (methodBinding2 == null) {
                return false;
            }
            Expression invocationExpr = methodInvocation.getExpression();
            if (Modifier.isStatic((int)methodBinding2.getModifiers())) {
                invocationTypeBinding = ASTNodes.getInvocationType((ASTNode)methodInvocation, (IMethodBinding)methodBinding2, (Expression)invocationExpr);
                if (invocationTypeBinding == null) {
                    return false;
                }
                if (!QuickAssistProcessor.matches(lambdaParameters, methodInvocation.arguments())) {
                    return false;
                }
            } else if (lambda.parameters().size() - methodInvocation.arguments().size() == 1) {
                if (invocationExpr == null) {
                    return false;
                }
                invocationTypeBinding = invocationExpr.resolveTypeBinding();
                if (invocationTypeBinding == null) {
                    return false;
                }
                IMethodBinding lambdaMethodBinding = lambda.resolveMethodBinding();
                if (lambdaMethodBinding == null) {
                    return false;
                }
                ITypeBinding firstParamType = lambdaMethodBinding.getParameterTypes()[0];
                if (!Bindings.equals((IBinding)invocationTypeBinding, (IBinding)firstParamType) && !Bindings.isSuperType((ITypeBinding)invocationTypeBinding, (ITypeBinding)firstParamType) || !JdtASTMatcher.doNodesMatch((ASTNode)lambdaParameters.get(0), (ASTNode)invocationExpr) || !QuickAssistProcessor.matches(lambdaParameters.subList(1, lambdaParameters.size()), methodInvocation.arguments())) {
                    return false;
                }
            } else if (!QuickAssistProcessor.matches(lambdaParameters, methodInvocation.arguments())) {
                return false;
            }
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = lambda.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ImportRewrite importRewrite = null;
        if (exprBody instanceof ClassInstanceCreation) {
            replacement = creationReference = ast.newCreationReference();
            ClassInstanceCreation cic = (ClassInstanceCreation)exprBody;
            Type type = cic.getType();
            if (type.isParameterizedType() && ((ParameterizedType)type).typeArguments().size() == 0) {
                type = ((ParameterizedType)type).getType();
            }
            creationReference.setType((Type)rewrite.createCopyTarget((ASTNode)type));
            creationReference.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, cic.typeArguments()));
        } else if (exprBody instanceof ArrayCreation) {
            replacement = creationReference = ast.newCreationReference();
            ArrayType arrayType = ((ArrayCreation)exprBody).getType();
            Type copiedElementType = (Type)rewrite.createCopyTarget((ASTNode)arrayType.getElementType());
            creationReference.setType((Type)ast.newArrayType(copiedElementType, arrayType.getDimensions()));
        } else if (exprBody instanceof SuperMethodInvocation) {
            SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)exprBody;
            methodBinding = superMethodInvocation.resolveMethodBinding();
            Name superQualifier = superMethodInvocation.getQualifier();
            if (Modifier.isStatic((int)methodBinding.getModifiers())) {
                TypeMethodReference typeMethodReference = ast.newTypeMethodReference();
                replacement = typeMethodReference;
                typeMethodReference.setName((SimpleName)rewrite.createCopyTarget((ASTNode)superMethodInvocation.getName()));
                importRewrite = StubUtility.createImportRewrite(context.getASTRoot(), true);
                ITypeBinding invocationTypeBinding = ASTNodes.getInvocationType((ASTNode)superMethodInvocation, (IMethodBinding)methodBinding, (Expression)superQualifier);
                typeMethodReference.setType(importRewrite.addImport(invocationTypeBinding.getTypeDeclaration(), ast));
                typeMethodReference.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, superMethodInvocation.typeArguments()));
            } else {
                SuperMethodReference superMethodReference = ast.newSuperMethodReference();
                replacement = superMethodReference;
                if (superQualifier != null) {
                    superMethodReference.setQualifier((Name)rewrite.createCopyTarget((ASTNode)superQualifier));
                }
                superMethodReference.setName((SimpleName)rewrite.createCopyTarget((ASTNode)superMethodInvocation.getName()));
                superMethodReference.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, superMethodInvocation.typeArguments()));
            }
        } else {
            boolean isTypeRefToInstanceMethod;
            MethodInvocation methodInvocation = (MethodInvocation)exprBody;
            methodBinding = methodInvocation.resolveMethodBinding();
            Expression invocationQualifier = methodInvocation.getExpression();
            boolean isStaticMethod = Modifier.isStatic((int)methodBinding.getModifiers());
            boolean bl = isTypeRefToInstanceMethod = methodInvocation.arguments().size() != lambda.parameters().size();
            if (isStaticMethod || isTypeRefToInstanceMethod) {
                TypeMethodReference typeMethodReference = ast.newTypeMethodReference();
                replacement = typeMethodReference;
                typeMethodReference.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodInvocation.getName()));
                importRewrite = StubUtility.createImportRewrite(context.getASTRoot(), true);
                ITypeBinding invocationTypeBinding = ASTNodes.getInvocationType((ASTNode)methodInvocation, (IMethodBinding)methodBinding, (Expression)invocationQualifier);
                invocationTypeBinding = StubUtility2.replaceWildcardsAndCaptures(invocationTypeBinding);
                ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)lambda, importRewrite);
                typeMethodReference.setType(importRewrite.addImport(invocationTypeBinding, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext, ImportRewrite.TypeLocation.OTHER));
                typeMethodReference.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, methodInvocation.typeArguments()));
            } else {
                ExpressionMethodReference exprMethodReference = ast.newExpressionMethodReference();
                replacement = exprMethodReference;
                exprMethodReference.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodInvocation.getName()));
                if (invocationQualifier != null) {
                    exprMethodReference.setExpression((Expression)rewrite.createCopyTarget((ASTNode)invocationQualifier));
                } else {
                    exprMethodReference.setExpression((Expression)ast.newThisExpression());
                }
                exprMethodReference.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, methodInvocation.typeArguments()));
            }
        }
        rewrite.replace((ASTNode)lambda, (ASTNode)replacement, null);
        String label = CorrectionMessages.QuickAssistProcessor_convert_to_method_reference;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 6, image);
        if (importRewrite != null) {
            proposal.setImportRewrite(importRewrite);
        }
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean representsDefiningNode(ASTNode innerNode, ASTNode definingNode) {
        if (innerNode == definingNode) {
            return true;
        }
        switch (definingNode.getNodeType()) {
            case 14: {
                return QuickAssistProcessor.representsDefiningNode(innerNode, (ASTNode)((ClassInstanceCreation)definingNode).getType());
            }
            case 3: {
                return QuickAssistProcessor.representsDefiningNode(innerNode, (ASTNode)((ArrayCreation)definingNode).getType());
            }
            case 48: {
                return innerNode == ((SuperMethodInvocation)definingNode).getName();
            }
            case 32: {
                return innerNode == ((MethodInvocation)definingNode).getName();
            }
            case 88: {
                return innerNode == ((NameQualifiedType)definingNode).getName();
            }
            case 75: {
                return innerNode == ((QualifiedType)definingNode).getName();
            }
            case 43: {
                return innerNode == ((SimpleType)definingNode).getName();
            }
            case 5: {
                return QuickAssistProcessor.representsDefiningNode(innerNode, (ASTNode)((ArrayType)definingNode).getElementType());
            }
            case 74: {
                return QuickAssistProcessor.representsDefiningNode(innerNode, (ASTNode)((ParameterizedType)definingNode).getType());
            }
        }
        return false;
    }

    private static boolean isValidLambdaReferenceToMethod(Expression expression) {
        return expression instanceof ClassInstanceCreation || expression instanceof ArrayCreation || expression instanceof SuperMethodInvocation || expression instanceof MethodInvocation;
    }

    private static boolean matches(List<Expression> expected, List<Expression> toMatch) {
        if (toMatch.size() != expected.size()) {
            return false;
        }
        int i = 0;
        while (i < toMatch.size()) {
            if (!JdtASTMatcher.doNodesMatch((ASTNode)expected.get(i), (ASTNode)toMatch.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean getFixParenthesesInLambdaExpression(IInvocationContext context, ASTNode coveringNode, Collection<ICommandAccess> resultingCollections) {
        String imageKey;
        Boolean parenthesesPropertyNewValue;
        String label;
        LambdaExpression enclosingLambda = null;
        if (coveringNode instanceof LambdaExpression) {
            enclosingLambda = (LambdaExpression)coveringNode;
        } else if (coveringNode.getLocationInParent() == VariableDeclarationFragment.NAME_PROPERTY && ((VariableDeclarationFragment)coveringNode.getParent()).getLocationInParent() == LambdaExpression.PARAMETERS_PROPERTY) {
            enclosingLambda = (LambdaExpression)coveringNode.getParent().getParent();
        } else {
            return false;
        }
        List lambdaParameters = enclosingLambda.parameters();
        if (lambdaParameters.size() != 1) {
            return false;
        }
        if (lambdaParameters.get(0) instanceof SingleVariableDeclaration) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        if (enclosingLambda.hasParentheses()) {
            label = CorrectionMessages.QuickAssistProcessor_removeParenthesesInLambda;
            parenthesesPropertyNewValue = Boolean.FALSE;
            imageKey = "org.eclipse.jdt.ui.remove_correction.gif";
        } else {
            label = CorrectionMessages.QuickAssistProcessor_addParenthesesInLambda;
            parenthesesPropertyNewValue = Boolean.TRUE;
            imageKey = "org.eclipse.jdt.ui.correction_cast.gif";
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)enclosingLambda.getAST());
        rewrite.set((ASTNode)enclosingLambda, (StructuralPropertyDescriptor)LambdaExpression.PARENTHESES_PROPERTY, (Object)parenthesesPropertyNewValue, null);
        Image image = JavaPluginImages.get(imageKey);
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, -10, image);
        resultingCollections.add(proposal);
        return true;
    }

    public static boolean getAddInferredLambdaParameterTypes(IInvocationContext context, ASTNode covering, Collection<ICommandAccess> resultingCollections) {
        LambdaExpression lambda;
        if (covering instanceof LambdaExpression) {
            lambda = (LambdaExpression)covering;
        } else if (covering.getLocationInParent() == VariableDeclarationFragment.NAME_PROPERTY && ((VariableDeclarationFragment)covering.getParent()).getLocationInParent() == LambdaExpression.PARAMETERS_PROPERTY) {
            lambda = (LambdaExpression)covering.getParent().getParent();
        } else {
            return false;
        }
        List lambdaParameters = lambda.parameters();
        int noOfLambdaParams = lambdaParameters.size();
        if (noOfLambdaParams == 0) {
            return false;
        }
        if (lambdaParameters.get(0) instanceof SingleVariableDeclaration) {
            return false;
        }
        IMethodBinding methodBinding = lambda.resolveMethodBinding();
        if (methodBinding == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = lambda.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ImportRewrite importRewrite = StubUtility.createImportRewrite(context.getASTRoot(), true);
        rewrite.set((ASTNode)lambda, (StructuralPropertyDescriptor)LambdaExpression.PARENTHESES_PROPERTY, (Object)true, null);
        ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)lambda, importRewrite);
        ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
        int i = 0;
        while (i < noOfLambdaParams) {
            VariableDeclaration param = (VariableDeclaration)lambdaParameters.get(i);
            SingleVariableDeclaration newParam = ast.newSingleVariableDeclaration();
            newParam.setName(ast.newSimpleName(param.getName().getIdentifier()));
            ITypeBinding type = StubUtility2.replaceWildcardsAndCaptures(parameterTypes[i]);
            newParam.setType(importRewrite.addImport(type, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext, ImportRewrite.TypeLocation.PARAMETER));
            rewrite.replace((ASTNode)param, (ASTNode)newParam, null);
            ++i;
        }
        String label = CorrectionMessages.QuickAssistProcessor_add_inferred_lambda_parameter_types;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 3, image);
        proposal.setImportRewrite(importRewrite);
        resultingCollections.add(proposal);
        return true;
    }

    public static boolean getInferDiamondArgumentsProposal(IInvocationContext context, ASTNode node, IProblemLocation[] locations, Collection<ICommandAccess> resultingCollections) {
        TypeParametersFix fix;
        ClassInstanceCreation creation;
        ASTNode type;
        if (QuickAssistProcessor.containsMatchingProblem(locations, 16778099)) {
            return false;
        }
        ParameterizedType createdType = null;
        if (node instanceof Name) {
            Name name = ASTNodes.getTopMostName((Name)((Name)node));
            if ((name.getLocationInParent() == SimpleType.NAME_PROPERTY || name.getLocationInParent() == NameQualifiedType.NAME_PROPERTY) && (type = name.getParent()).getLocationInParent() == ParameterizedType.TYPE_PROPERTY && (createdType = (ParameterizedType)type.getParent()).getLocationInParent() != ClassInstanceCreation.TYPE_PROPERTY) {
                return false;
            }
        } else if (node instanceof ParameterizedType) {
            createdType = (ParameterizedType)node;
            if (createdType.getLocationInParent() != ClassInstanceCreation.TYPE_PROPERTY) {
                return false;
            }
        } else if (node instanceof ClassInstanceCreation && (type = (creation = (ClassInstanceCreation)node).getType()) instanceof ParameterizedType) {
            createdType = (ParameterizedType)type;
        }
        if ((fix = TypeParametersFix.createInsertInferredTypeArgumentsFix(context.getASTRoot(), createdType)) != null && resultingCollections != null) {
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            int relevance = locations == null ? 7 : 1;
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("cleanup.insert_inferred_type_arguments", "true");
            FixCorrectionProposal proposal = new FixCorrectionProposal(fix, new TypeParametersCleanUp(options), relevance, image, context);
            resultingCollections.add(proposal);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean getJoinVariableProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        ASTNode parent = node.getParent();
        VariableDeclarationFragment fragment = null;
        boolean onFirstAccess = false;
        if (node instanceof SimpleName && node.getLocationInParent() == Assignment.LEFT_HAND_SIDE_PROPERTY) {
            onFirstAccess = true;
            SimpleName name = (SimpleName)node;
            IBinding binding = name.resolveBinding();
            if (!(binding instanceof IVariableBinding)) {
                return false;
            }
            ASTNode declaring = context.getASTRoot().findDeclaringNode(binding);
            if (!(declaring instanceof VariableDeclarationFragment)) return false;
            fragment = (VariableDeclarationFragment)declaring;
        } else {
            if (!(parent instanceof VariableDeclarationFragment)) return false;
            fragment = (VariableDeclarationFragment)parent;
        }
        IVariableBinding binding = fragment.resolveBinding();
        Expression initializer = fragment.getInitializer();
        if (initializer != null && initializer.getNodeType() != 33 || binding == null || binding.isField()) {
            return false;
        }
        if (!(fragment.getParent() instanceof VariableDeclarationStatement)) {
            return false;
        }
        VariableDeclarationStatement statement = (VariableDeclarationStatement)fragment.getParent();
        SimpleName[] names = LinkedNodeFinder.findByBinding(statement.getParent(), (IBinding)binding);
        if (names.length <= 1 || names[0] != fragment.getName()) {
            return false;
        }
        SimpleName firstAccess = names[1];
        if (onFirstAccess ? firstAccess != node : firstAccess.getLocationInParent() != Assignment.LEFT_HAND_SIDE_PROPERTY) {
            return false;
        }
        Assignment assignment = (Assignment)firstAccess.getParent();
        if (assignment.getLocationInParent() != ExpressionStatement.EXPRESSION_PROPERTY) {
            return false;
        }
        ExpressionStatement assignParent = (ExpressionStatement)assignment.getParent();
        if (resultingCollections == null) {
            return true;
        }
        AST ast = statement.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        TightSourceRangeComputer sourceRangeComputer = new TightSourceRangeComputer();
        sourceRangeComputer.addTightSourceNode((ASTNode)assignParent);
        rewrite.setTargetSourceRangeComputer((TargetSourceRangeComputer)sourceRangeComputer);
        String label = CorrectionMessages.QuickAssistProcessor_joindeclaration_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif");
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        proposal.setCommandId(SPLIT_JOIN_VARIABLE_DECLARATION_ID);
        Expression placeholder = (Expression)rewrite.createMoveTarget((ASTNode)assignment.getRightHandSide());
        rewrite.set((ASTNode)fragment, (StructuralPropertyDescriptor)VariableDeclarationFragment.INITIALIZER_PROPERTY, (Object)placeholder, null);
        if (onFirstAccess) {
            rewrite.replace((ASTNode)assignParent, rewrite.createMoveTarget((ASTNode)statement), null);
        } else if (ASTNodes.isControlStatementBody((StructuralPropertyDescriptor)assignParent.getLocationInParent())) {
            Block block = ast.newBlock();
            rewrite.replace((ASTNode)assignParent, (ASTNode)block, null);
        } else {
            rewrite.remove((ASTNode)assignParent, null);
        }
        proposal.setEndPosition(rewrite.track((ASTNode)fragment.getName()));
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getSplitVariableProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        ExpressionStatement newStatement;
        VariableDeclarationStatement statement;
        VariableDeclarationFragment fragment;
        if (node instanceof VariableDeclarationFragment) {
            fragment = (VariableDeclarationFragment)node;
        } else if (node.getLocationInParent() == VariableDeclarationFragment.NAME_PROPERTY) {
            fragment = (VariableDeclarationFragment)node.getParent();
        } else {
            return false;
        }
        if (fragment.getInitializer() == null) {
            return false;
        }
        ASTNode fragParent = fragment.getParent();
        if (fragParent instanceof VariableDeclarationStatement) {
            statement = (VariableDeclarationStatement)fragParent;
        } else if (fragParent instanceof VariableDeclarationExpression) {
            if (fragParent.getLocationInParent() == TryStatement.RESOURCES_PROPERTY) {
                return false;
            }
            statement = (Statement)fragParent.getParent();
        } else {
            return false;
        }
        ASTNode statementParent = statement.getParent();
        StructuralPropertyDescriptor property = statement.getLocationInParent();
        if (!property.isChildListProperty()) {
            return false;
        }
        List list = ASTNodes.getChildListProperty((ASTNode)statementParent, (ChildListPropertyDescriptor)((ChildListPropertyDescriptor)property));
        if (resultingCollections == null) {
            return true;
        }
        AST ast = statement.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        String label = CorrectionMessages.QuickAssistProcessor_splitdeclaration_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        boolean commandConflict = false;
        for (ICommandAccess completionProposal : resultingCollections) {
            if (!(completionProposal instanceof ChangeCorrectionProposal) || !SPLIT_JOIN_VARIABLE_DECLARATION_ID.equals(((ChangeCorrectionProposal)completionProposal).getCommandId())) continue;
            commandConflict = true;
        }
        if (!commandConflict) {
            proposal.setCommandId(SPLIT_JOIN_VARIABLE_DECLARATION_ID);
        }
        int insertIndex = list.indexOf(statement);
        Expression placeholder = (Expression)rewrite.createMoveTarget((ASTNode)fragment.getInitializer());
        ITypeBinding binding = fragment.getInitializer().resolveTypeBinding();
        if (placeholder instanceof ArrayInitializer && binding != null && binding.isArray()) {
            ArrayCreation creation = ast.newArrayCreation();
            creation.setInitializer((ArrayInitializer)placeholder);
            ITypeBinding componentType = binding.getElementType();
            Object type = null;
            type = componentType.isPrimitive() ? ast.newPrimitiveType(PrimitiveType.toCode((String)componentType.getName())) : ast.newSimpleType((Name)ast.newSimpleName(componentType.getName()));
            creation.setType(ast.newArrayType((Type)type, binding.getDimensions()));
            placeholder = creation;
        }
        Assignment assignment = ast.newAssignment();
        assignment.setRightHandSide(placeholder);
        assignment.setLeftHandSide((Expression)ast.newSimpleName(fragment.getName().getIdentifier()));
        if (statement instanceof VariableDeclarationStatement) {
            newStatement = ast.newExpressionStatement((Expression)assignment);
            ++insertIndex;
        } else {
            rewrite.replace(fragment.getParent(), (ASTNode)assignment, null);
            VariableDeclarationFragment newFrag = ast.newVariableDeclarationFragment();
            newFrag.setName(ast.newSimpleName(fragment.getName().getIdentifier()));
            newFrag.extraDimensions().addAll(DimensionRewrite.copyDimensions(fragment.extraDimensions(), rewrite));
            VariableDeclarationExpression oldVarDecl = (VariableDeclarationExpression)fragParent;
            VariableDeclarationStatement newVarDec = ast.newVariableDeclarationStatement(newFrag);
            newVarDec.setType((Type)rewrite.createCopyTarget((ASTNode)oldVarDecl.getType()));
            newVarDec.modifiers().addAll(ASTNodeFactory.newModifiers(ast, oldVarDecl.getModifiers()));
            newStatement = newVarDec;
        }
        ListRewrite listRewriter = rewrite.getListRewrite(statementParent, (ChildListPropertyDescriptor)property);
        listRewriter.insertAt((ASTNode)newStatement, insertIndex, null);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getConvertStringConcatenationProposals(IInvocationContext context, Collection<ICommandAccess> resultingCollections) {
        ASTNode node = context.getCoveringNode();
        BodyDeclaration parentDecl = ASTResolving.findParentBodyDeclaration((ASTNode)node);
        if (!(parentDecl instanceof MethodDeclaration) && !(parentDecl instanceof Initializer)) {
            return false;
        }
        AST ast = node.getAST();
        ITypeBinding stringBinding = ast.resolveWellKnownType("java.lang.String");
        if (node instanceof Expression && !(node instanceof InfixExpression)) {
            node = node.getParent();
        }
        if (node instanceof VariableDeclarationFragment) {
            node = ((VariableDeclarationFragment)node).getInitializer();
        } else if (node instanceof Assignment) {
            node = ((Assignment)node).getRightHandSide();
        }
        InfixExpression oldInfixExpression = null;
        while (node instanceof InfixExpression) {
            InfixExpression curr = (InfixExpression)node;
            if (curr.resolveTypeBinding() != stringBinding || curr.getOperator() != InfixExpression.Operator.PLUS) break;
            oldInfixExpression = curr;
            node = node.getParent();
        }
        if (oldInfixExpression == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        LinkedCorrectionProposal stringBufferProposal = QuickAssistProcessor.getConvertToStringBufferProposal(context, ast, oldInfixExpression);
        resultingCollections.add(stringBufferProposal);
        ASTRewriteCorrectionProposal messageFormatProposal = QuickAssistProcessor.getConvertToMessageFormatProposal(context, ast, oldInfixExpression);
        if (messageFormatProposal != null) {
            resultingCollections.add(messageFormatProposal);
        }
        return true;
    }

    private static LinkedCorrectionProposal getConvertToStringBufferProposal(IInvocationContext context, AST ast, InfixExpression oldInfixExpression) {
        String bufferName;
        Statement insertAfter;
        ListRewrite listRewrite;
        ICompilationUnit cu = context.getCompilationUnit();
        String bufferOrBuilderName = JavaModelUtil.is50OrHigher((IJavaProject)cu.getJavaProject()) ? "StringBuilder" : "StringBuffer";
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        SimpleName existingBuffer = QuickAssistProcessor.getEnclosingAppendBuffer(oldInfixExpression);
        String mechanismName = BasicElementLabels.getJavaElementName((String)(existingBuffer == null ? bufferOrBuilderName : existingBuffer.getIdentifier()));
        String label = Messages.format(CorrectionMessages.QuickAssistProcessor_convert_to_string_buffer_description, mechanismName);
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, cu, rewrite, 1, image);
        proposal.setCommandId(CONVERT_TO_STRING_BUFFER_ID);
        String groupID = "nameId";
        Statement enclosingStatement = ASTResolving.findParentStatement((ASTNode)oldInfixExpression);
        if (existingBuffer != null) {
            if (ASTNodes.isControlStatementBody((StructuralPropertyDescriptor)enclosingStatement.getLocationInParent())) {
                Block newBlock = ast.newBlock();
                listRewrite = rewrite.getListRewrite((ASTNode)newBlock, Block.STATEMENTS_PROPERTY);
                insertAfter = null;
                rewrite.replace((ASTNode)enclosingStatement, (ASTNode)newBlock, null);
            } else {
                listRewrite = rewrite.getListRewrite(enclosingStatement.getParent(), (ChildListPropertyDescriptor)enclosingStatement.getLocationInParent());
                insertAfter = enclosingStatement;
            }
            bufferName = existingBuffer.getIdentifier();
        } else {
            VariableDeclarationFragment frag = ast.newVariableDeclarationFragment();
            List<String> fExcludedVariableNames = Arrays.asList(ASTResolving.getUsedVariableNames((ASTNode)oldInfixExpression));
            SimpleType bufferType = ast.newSimpleType(ast.newName(bufferOrBuilderName));
            ClassInstanceCreation newBufferExpression = ast.newClassInstanceCreation();
            String[] newBufferNames = StubUtility.getVariableNameSuggestions(5, cu.getJavaProject(), bufferOrBuilderName, 0, fExcludedVariableNames, true);
            bufferName = newBufferNames[0];
            SimpleName bufferNameDeclaration = ast.newSimpleName(bufferName);
            frag.setName(bufferNameDeclaration);
            proposal.addLinkedPosition(rewrite.track((ASTNode)bufferNameDeclaration), true, groupID);
            int i = 0;
            while (i < newBufferNames.length) {
                proposal.addLinkedPositionProposal(groupID, newBufferNames[i], null);
                ++i;
            }
            newBufferExpression.setType((Type)bufferType);
            frag.setInitializer((Expression)newBufferExpression);
            VariableDeclarationStatement bufferDeclaration = ast.newVariableDeclarationStatement(frag);
            bufferDeclaration.setType((Type)ast.newSimpleType(ast.newName(bufferOrBuilderName)));
            insertAfter = bufferDeclaration;
            Statement statement = ASTResolving.findParentStatement((ASTNode)oldInfixExpression);
            if (ASTNodes.isControlStatementBody((StructuralPropertyDescriptor)statement.getLocationInParent())) {
                Block newBlock = ast.newBlock();
                listRewrite = rewrite.getListRewrite((ASTNode)newBlock, Block.STATEMENTS_PROPERTY);
                listRewrite.insertFirst((ASTNode)bufferDeclaration, null);
                listRewrite.insertLast(rewrite.createMoveTarget((ASTNode)statement), null);
                rewrite.replace((ASTNode)statement, (ASTNode)newBlock, null);
            } else {
                listRewrite = rewrite.getListRewrite(statement.getParent(), (ChildListPropertyDescriptor)statement.getLocationInParent());
                listRewrite.insertBefore((ASTNode)bufferDeclaration, (ASTNode)statement, null);
            }
        }
        ArrayList<Expression> operands = new ArrayList<Expression>();
        QuickAssistProcessor.collectInfixPlusOperands((Expression)oldInfixExpression, operands);
        Statement lastAppend = insertAfter;
        for (Expression operand : operands) {
            MethodInvocation appendIncovationExpression = ast.newMethodInvocation();
            appendIncovationExpression.setName(ast.newSimpleName("append"));
            SimpleName bufferNameReference = ast.newSimpleName(bufferName);
            if (existingBuffer == null) {
                proposal.addLinkedPosition(rewrite.track((ASTNode)bufferNameReference), true, groupID);
            }
            appendIncovationExpression.setExpression((Expression)bufferNameReference);
            appendIncovationExpression.arguments().add(rewrite.createCopyTarget((ASTNode)operand));
            ExpressionStatement appendExpressionStatement = ast.newExpressionStatement((Expression)appendIncovationExpression);
            if (lastAppend == null) {
                listRewrite.insertFirst((ASTNode)appendExpressionStatement, null);
            } else {
                listRewrite.insertAfter((ASTNode)appendExpressionStatement, (ASTNode)lastAppend, null);
            }
            lastAppend = appendExpressionStatement;
        }
        if (existingBuffer != null) {
            proposal.setEndPosition(rewrite.track((ASTNode)lastAppend));
            if (insertAfter != null) {
                rewrite.remove((ASTNode)enclosingStatement, null);
            }
        } else {
            MethodInvocation bufferToString = ast.newMethodInvocation();
            bufferToString.setName(ast.newSimpleName("toString"));
            SimpleName bufferNameReference = ast.newSimpleName(bufferName);
            bufferToString.setExpression((Expression)bufferNameReference);
            proposal.addLinkedPosition(rewrite.track((ASTNode)bufferNameReference), true, groupID);
            rewrite.replace((ASTNode)oldInfixExpression, (ASTNode)bufferToString, null);
            proposal.setEndPosition(rewrite.track((ASTNode)bufferToString));
        }
        return proposal;
    }

    private static void collectInfixPlusOperands(Expression expression, List<Expression> collector) {
        if (expression instanceof InfixExpression && ((InfixExpression)expression).getOperator() == InfixExpression.Operator.PLUS) {
            InfixExpression infixExpression = (InfixExpression)expression;
            QuickAssistProcessor.collectInfixPlusOperands(infixExpression.getLeftOperand(), collector);
            QuickAssistProcessor.collectInfixPlusOperands(infixExpression.getRightOperand(), collector);
            List extendedOperands = infixExpression.extendedOperands();
            Iterator iter = extendedOperands.iterator();
            while (iter.hasNext()) {
                QuickAssistProcessor.collectInfixPlusOperands((Expression)iter.next(), collector);
            }
        } else {
            collector.add(expression);
        }
    }

    private static SimpleName getEnclosingAppendBuffer(InfixExpression infixExpression) {
        String typeName;
        IBinding binding;
        Expression expression;
        MethodInvocation methodInvocation;
        if (infixExpression.getLocationInParent() == MethodInvocation.ARGUMENTS_PROPERTY && (methodInvocation = (MethodInvocation)infixExpression.getParent()).getParent() instanceof Statement && "append".equals(methodInvocation.getName().getIdentifier()) && (expression = methodInvocation.getExpression()) instanceof SimpleName && (binding = ((SimpleName)expression).resolveBinding()) instanceof IVariableBinding && ("java.lang.StringBuilder".equals(typeName = ((IVariableBinding)binding).getType().getQualifiedName()) || "java.lang.StringBuffer".equals(typeName))) {
            return (SimpleName)expression;
        }
        return null;
    }

    private static ASTRewriteCorrectionProposal getConvertToMessageFormatProposal(IInvocationContext context, AST ast, InfixExpression oldInfixExpression) {
        ICompilationUnit cu = context.getCompilationUnit();
        boolean is50OrHigher = JavaModelUtil.is50OrHigher((IJavaProject)cu.getJavaProject());
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        CompilationUnit root = context.getASTRoot();
        ImportRewrite importRewrite = StubUtility.createImportRewrite(root, true);
        ContextSensitiveImportRewriteContext importContext = new ContextSensitiveImportRewriteContext(root, oldInfixExpression.getStartPosition(), importRewrite);
        ArrayList<Expression> operands = new ArrayList<Expression>();
        QuickAssistProcessor.collectInfixPlusOperands((Expression)oldInfixExpression, operands);
        ArrayList<Expression> formatArguments = new ArrayList<Expression>();
        String formatString = "";
        int i = 0;
        for (Expression operand : operands) {
            Expression argument;
            if (operand instanceof StringLiteral) {
                String value = ((StringLiteral)operand).getEscapedValue();
                value = value.substring(1, value.length() - 1);
                value = value.replaceAll("'", "''");
                formatString = String.valueOf(formatString) + value;
                continue;
            }
            formatString = String.valueOf(formatString) + "{" + i + "}";
            if (is50OrHigher) {
                argument = (Expression)rewrite.createCopyTarget((ASTNode)operand);
            } else {
                ITypeBinding boxedBinding;
                ITypeBinding binding = operand.resolveTypeBinding();
                if (binding == null) {
                    return null;
                }
                argument = (Expression)rewrite.createCopyTarget((ASTNode)operand);
                if (binding.isPrimitive() && (boxedBinding = Bindings.getBoxedTypeBinding((ITypeBinding)binding, (AST)ast)) != binding) {
                    Type boxedType = importRewrite.addImport(boxedBinding, ast, (ImportRewrite.ImportRewriteContext)importContext);
                    ClassInstanceCreation cic = ast.newClassInstanceCreation();
                    cic.setType(boxedType);
                    cic.arguments().add(argument);
                    argument = cic;
                }
            }
            formatArguments.add(argument);
            ++i;
        }
        if (formatArguments.size() == 0) {
            return null;
        }
        String label = CorrectionMessages.QuickAssistProcessor_convert_to_message_format;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 0, image);
        proposal.setCommandId(CONVERT_TO_MESSAGE_FORMAT_ID);
        proposal.setImportRewrite(importRewrite);
        String messageType = importRewrite.addImport("java.text.MessageFormat", (ImportRewrite.ImportRewriteContext)importContext);
        MethodInvocation formatInvocation = ast.newMethodInvocation();
        formatInvocation.setExpression((Expression)ast.newName(messageType));
        formatInvocation.setName(ast.newSimpleName("format"));
        List arguments = formatInvocation.arguments();
        StringLiteral formatStringArgument = ast.newStringLiteral();
        formatStringArgument.setEscapedValue("\"" + formatString + "\"");
        arguments.add(formatStringArgument);
        if (is50OrHigher) {
            Iterator iterator = formatArguments.iterator();
            while (iterator.hasNext()) {
                arguments.add((Expression)iterator.next());
            }
        } else {
            ArrayCreation objectArrayCreation = ast.newArrayCreation();
            SimpleType objectType = ast.newSimpleType((Name)ast.newSimpleName("Object"));
            ArrayType arrayType = ast.newArrayType((Type)objectType);
            objectArrayCreation.setType(arrayType);
            ArrayInitializer arrayInitializer = ast.newArrayInitializer();
            List initializerExpressions = arrayInitializer.expressions();
            Iterator iterator = formatArguments.iterator();
            while (iterator.hasNext()) {
                initializerExpressions.add((Expression)iterator.next());
            }
            objectArrayCreation.setInitializer(arrayInitializer);
            arguments.add(objectArrayCreation);
        }
        rewrite.replace((ASTNode)oldInfixExpression, (ASTNode)formatInvocation, null);
        return proposal;
    }

    public static boolean getAssignToVariableProposals(IInvocationContext context, ASTNode node, IProblemLocation[] locations, Collection<ICommandAccess> resultingCollections) {
        Statement statement = ASTResolving.findParentStatement((ASTNode)node);
        if (!(statement instanceof ExpressionStatement)) {
            return false;
        }
        ExpressionStatement expressionStatement = (ExpressionStatement)statement;
        Expression expression = expressionStatement.getExpression();
        if (expression.getNodeType() == 7) {
            return false;
        }
        ITypeBinding typeBinding = expression.resolveTypeBinding();
        if ((typeBinding = Bindings.normalizeTypeBinding((ITypeBinding)typeBinding)) == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        if (QuickAssistProcessor.containsMatchingProblem(locations, 536871060)) {
            return false;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        AssignToVariableAssistProposal localProposal = new AssignToVariableAssistProposal(cu, 1, expressionStatement, typeBinding, 3);
        localProposal.setCommandId(ASSIGN_TO_LOCAL_ID);
        resultingCollections.add(localProposal);
        ASTNode type = ASTResolving.findParentType((ASTNode)expression);
        if (type != null) {
            AssignToVariableAssistProposal fieldProposal = new AssignToVariableAssistProposal(cu, 2, expressionStatement, typeBinding, 2);
            fieldProposal.setCommandId(ASSIGN_TO_FIELD_ID);
            resultingCollections.add(fieldProposal);
        }
        return true;
    }

    private static boolean containsMatchingProblem(IProblemLocation[] locations, int problemId) {
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                IProblemLocation location = locations[i];
                if ("org.eclipse.jdt.core.problem".equals(location.getMarkerType()) && location.getProblemId() == problemId) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean getAssignParamToFieldProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        ASTNode parent = (node = ASTNodes.getNormalizedNode((ASTNode)node)).getParent();
        if (!(parent instanceof SingleVariableDeclaration) || !(parent.getParent() instanceof MethodDeclaration)) {
            return false;
        }
        SingleVariableDeclaration paramDecl = (SingleVariableDeclaration)parent;
        IVariableBinding binding = paramDecl.resolveBinding();
        MethodDeclaration methodDecl = (MethodDeclaration)parent.getParent();
        if (binding == null || methodDecl.getBody() == null) {
            return false;
        }
        ITypeBinding typeBinding = binding.getType();
        if (typeBinding == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        ITypeBinding parentType = Bindings.getBindingOfParentType((ASTNode)node);
        if (parentType != null) {
            if (parentType.isInterface()) {
                return false;
            }
            CompilationUnit root = context.getASTRoot();
            IVariableBinding[] declaredFields = parentType.getDeclaredFields();
            boolean isStaticContext = ASTResolving.isInStaticContext((ASTNode)node);
            int i = 0;
            while (i < declaredFields.length) {
                VariableDeclarationFragment fragment;
                ASTNode fieldDeclFrag;
                IVariableBinding curr = declaredFields[i];
                if (isStaticContext == Modifier.isStatic((int)curr.getModifiers()) && typeBinding.isAssignmentCompatible(curr.getType()) && (fieldDeclFrag = root.findDeclaringNode((IBinding)curr)) instanceof VariableDeclarationFragment && (fragment = (VariableDeclarationFragment)fieldDeclFrag).getInitializer() == null) {
                    resultingCollections.add(new AssignToVariableAssistProposal(context.getCompilationUnit(), paramDecl, fragment, typeBinding, 1));
                }
                ++i;
            }
        }
        AssignToVariableAssistProposal fieldProposal = new AssignToVariableAssistProposal(context.getCompilationUnit(), paramDecl, null, typeBinding, 3);
        fieldProposal.setCommandId(ASSIGN_PARAM_TO_FIELD_ID);
        resultingCollections.add(fieldProposal);
        return true;
    }

    private static boolean getAssignAllParamsToFieldsProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        ASTNode parent = (node = ASTNodes.getNormalizedNode((ASTNode)node)).getParent();
        if (!(parent instanceof SingleVariableDeclaration) || !(parent.getParent() instanceof MethodDeclaration)) {
            return false;
        }
        MethodDeclaration methodDecl = (MethodDeclaration)parent.getParent();
        if (methodDecl.getBody() == null) {
            return false;
        }
        List parameters = methodDecl.parameters();
        if (parameters.size() <= 1) {
            return false;
        }
        ITypeBinding parentType = Bindings.getBindingOfParentType((ASTNode)node);
        if (parentType == null || parentType.isInterface()) {
            return false;
        }
        for (SingleVariableDeclaration param : parameters) {
            IVariableBinding binding = param.resolveBinding();
            if (binding != null && binding.getType() != null) continue;
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AssignToVariableAssistProposal fieldProposal = new AssignToVariableAssistProposal(context.getCompilationUnit(), parameters, 2);
        fieldProposal.setCommandId(ASSIGN_ALL_PARAMS_TO_NEW_FIELDS_ID);
        resultingCollections.add(fieldProposal);
        return true;
    }

    private static boolean getAddFinallyProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        TryStatement tryStatement = ASTResolving.findParentTryStatement((ASTNode)node);
        if (tryStatement == null || tryStatement.getFinally() != null) {
            return false;
        }
        Statement statement = ASTResolving.findParentStatement((ASTNode)node);
        if (tryStatement != statement && tryStatement.getBody() != statement) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = tryStatement.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Block finallyBody = ast.newBlock();
        rewrite.set((ASTNode)tryStatement, (StructuralPropertyDescriptor)TryStatement.FINALLY_PROPERTY, (Object)finallyBody, null);
        String label = CorrectionMessages.QuickAssistProcessor_addfinallyblock_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.add_correction.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getAddElseProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        if (!(node instanceof IfStatement)) {
            return false;
        }
        IfStatement ifStatement = (IfStatement)node;
        if (ifStatement.getElseStatement() != null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = node.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Block body = ast.newBlock();
        rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.ELSE_STATEMENT_PROPERTY, (Object)body, null);
        String label = CorrectionMessages.QuickAssistProcessor_addelseblock_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.add_correction.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    public static boolean getCatchClauseToThrowsProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        ASTRewriteCorrectionProposal proposal;
        String label;
        CatchClause catchClause = (CatchClause)ASTResolving.findAncestor((ASTNode)node, (int)12);
        if (catchClause == null) {
            return false;
        }
        Statement statement = ASTResolving.findParentStatement((ASTNode)node);
        if (statement != catchClause.getParent() && statement != catchClause.getBody()) {
            return false;
        }
        Type type = catchClause.getException().getType();
        if (!(type.isSimpleType() || type.isUnionType() || type.isNameQualifiedType())) {
            return false;
        }
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration((ASTNode)catchClause);
        if (!(bodyDeclaration instanceof MethodDeclaration) && !(bodyDeclaration instanceof Initializer)) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = bodyDeclaration.getAST();
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.jexception_obj.gif");
        SimpleType selectedMultiCatchType = null;
        if (type.isUnionType() && node instanceof Name) {
            Name topMostName = ASTNodes.getTopMostName((Name)((Name)node));
            ASTNode parent = topMostName.getParent();
            if (parent instanceof SimpleType) {
                selectedMultiCatchType = (SimpleType)parent;
            } else if (parent instanceof NameQualifiedType) {
                selectedMultiCatchType = (NameQualifiedType)parent;
            }
        }
        if (bodyDeclaration instanceof MethodDeclaration) {
            String label2;
            MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            if (selectedMultiCatchType != null) {
                QuickAssistProcessor.removeException(rewrite, (UnionType)type, (Type)selectedMultiCatchType);
                QuickAssistProcessor.addExceptionToThrows(ast, methodDeclaration, rewrite, (Type)selectedMultiCatchType);
                label2 = CorrectionMessages.QuickAssistProcessor_exceptiontothrows_description;
                ASTRewriteCorrectionProposal proposal2 = new ASTRewriteCorrectionProposal(label2, context.getCompilationUnit(), rewrite, 6, image);
                resultingCollections.add(proposal2);
            } else {
                QuickAssistProcessor.removeCatchBlock(rewrite, catchClause);
                if (type.isUnionType()) {
                    UnionType unionType = (UnionType)type;
                    List types = unionType.types();
                    for (Type elementType : types) {
                        if (!(elementType instanceof SimpleType) && !(elementType instanceof NameQualifiedType)) {
                            return false;
                        }
                        QuickAssistProcessor.addExceptionToThrows(ast, methodDeclaration, rewrite, elementType);
                    }
                } else {
                    QuickAssistProcessor.addExceptionToThrows(ast, methodDeclaration, rewrite, type);
                }
                label2 = CorrectionMessages.QuickAssistProcessor_catchclausetothrows_description;
                ASTRewriteCorrectionProposal proposal3 = new ASTRewriteCorrectionProposal(label2, context.getCompilationUnit(), rewrite, 4, image);
                resultingCollections.add(proposal3);
            }
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        if (selectedMultiCatchType != null) {
            QuickAssistProcessor.removeException(rewrite, (UnionType)type, selectedMultiCatchType);
            label = CorrectionMessages.QuickAssistProcessor_removeexception_description;
            proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 6, image);
            resultingCollections.add(proposal);
        } else {
            QuickAssistProcessor.removeCatchBlock(rewrite, catchClause);
            label = CorrectionMessages.QuickAssistProcessor_removecatchclause_description;
            proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 5, image);
            resultingCollections.add(proposal);
        }
        return true;
    }

    private static void removeException(ASTRewrite rewrite, UnionType unionType, Type exception) {
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)unionType, UnionType.TYPES_PROPERTY);
        List types = unionType.types();
        for (Type type : types) {
            if (!type.equals((Object)exception)) continue;
            listRewrite.remove((ASTNode)type, null);
        }
    }

    private static void addExceptionToThrows(AST ast, MethodDeclaration methodDeclaration, ASTRewrite rewrite, Type type2) {
        ITypeBinding binding = type2.resolveBinding();
        if (binding == null || QuickAssistProcessor.isNotYetThrown(binding, methodDeclaration.thrownExceptionTypes())) {
            Type newType = (Type)ASTNode.copySubtree((AST)ast, (ASTNode)type2);
            ListRewrite listRewriter = rewrite.getListRewrite((ASTNode)methodDeclaration, MethodDeclaration.THROWN_EXCEPTION_TYPES_PROPERTY);
            listRewriter.insertLast((ASTNode)newType, null);
        }
    }

    private static void removeCatchBlock(ASTRewrite rewrite, CatchClause catchClause) {
        TryStatement tryStatement = (TryStatement)catchClause.getParent();
        if (tryStatement.catchClauses().size() > 1 || tryStatement.getFinally() != null || !tryStatement.resources().isEmpty()) {
            rewrite.remove((ASTNode)catchClause, null);
        } else {
            Block block = tryStatement.getBody();
            List statements = block.statements();
            int nStatements = statements.size();
            if (nStatements == 1) {
                ASTNode first = (ASTNode)statements.get(0);
                rewrite.replace((ASTNode)tryStatement, rewrite.createCopyTarget(first), null);
            } else if (nStatements > 1) {
                ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
                ASTNode first = (ASTNode)statements.get(0);
                ASTNode last = (ASTNode)statements.get(statements.size() - 1);
                ASTNode newStatement = listRewrite.createCopyTarget(first, last);
                if (ASTNodes.isControlStatementBody((StructuralPropertyDescriptor)tryStatement.getLocationInParent())) {
                    Block newBlock = rewrite.getAST().newBlock();
                    newBlock.statements().add(newStatement);
                    newStatement = newBlock;
                }
                rewrite.replace((ASTNode)tryStatement, newStatement, null);
            } else {
                rewrite.remove((ASTNode)tryStatement, null);
            }
        }
    }

    private static boolean isNotYetThrown(ITypeBinding binding, List<Type> thrownExceptions) {
        int i = 0;
        while (i < thrownExceptions.size()) {
            Type name = thrownExceptions.get(i);
            ITypeBinding elem = name.resolveBinding();
            if (elem != null && Bindings.isSuperType((ITypeBinding)elem, (ITypeBinding)binding)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean getPickoutTypeFromMulticatchProposals(IInvocationContext context, ASTNode node, ArrayList<ASTNode> coveredNodes, Collection<ICommandAccess> resultingCollections) {
        BodyDeclaration bodyDeclaration;
        boolean multipleExceptions;
        Name topMostName;
        ASTNode parent;
        CatchClause catchClause = (CatchClause)ASTResolving.findAncestor((ASTNode)node, (int)12);
        if (catchClause == null) {
            return false;
        }
        Statement statement = ASTResolving.findParentStatement((ASTNode)node);
        if (statement != catchClause.getParent() && statement != catchClause.getBody()) {
            return false;
        }
        Type type = catchClause.getException().getType();
        if (!type.isUnionType()) {
            return false;
        }
        Type selectedMultiCatchType = null;
        if (type.isUnionType() && node instanceof Name && ((parent = (topMostName = ASTNodes.getTopMostName((Name)((Name)node))).getParent()) instanceof SimpleType || parent instanceof NameQualifiedType)) {
            selectedMultiCatchType = (Type)parent;
        }
        boolean bl = multipleExceptions = coveredNodes.size() > 1;
        if (!(selectedMultiCatchType != null || node instanceof UnionType && multipleExceptions)) {
            return false;
        }
        if (!multipleExceptions) {
            coveredNodes.add((ASTNode)selectedMultiCatchType);
        }
        if (!((bodyDeclaration = ASTResolving.findParentBodyDeclaration((ASTNode)catchClause)) instanceof MethodDeclaration) && !(bodyDeclaration instanceof Initializer)) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = bodyDeclaration.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        CatchClause newCatchClause = ast.newCatchClause();
        SingleVariableDeclaration newSingleVariableDeclaration = ast.newSingleVariableDeclaration();
        UnionType newUnionType = ast.newUnionType();
        List types = newUnionType.types();
        int i = 0;
        while (i < coveredNodes.size()) {
            ASTNode typeNode = coveredNodes.get(i);
            types.add((Type)rewrite.createCopyTarget(typeNode));
            rewrite.remove(typeNode, null);
            ++i;
        }
        newSingleVariableDeclaration.setType((Type)newUnionType);
        newSingleVariableDeclaration.setName((SimpleName)rewrite.createCopyTarget((ASTNode)catchClause.getException().getName()));
        newCatchClause.setException(newSingleVariableDeclaration);
        QuickAssistProcessor.setCatchClauseBody(newCatchClause, rewrite, catchClause);
        TryStatement tryStatement = (TryStatement)catchClause.getParent();
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)tryStatement, TryStatement.CATCH_CLAUSES_PROPERTY);
        listRewrite.insertAfter((ASTNode)newCatchClause, (ASTNode)catchClause, null);
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.jexception_obj.gif");
        String label = !multipleExceptions ? CorrectionMessages.QuickAssistProcessor_move_exception_to_separate_catch_block : CorrectionMessages.QuickAssistProcessor_move_exceptions_to_separate_catch_block;
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 6, image);
        resultingCollections.add(proposal);
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean getConvertToMultiCatchProposals(IInvocationContext context, ASTNode covering, Collection<ICommandAccess> resultingCollections) {
        Name topMostName;
        ASTNode parent;
        if (!JavaModelUtil.is17OrHigher((IJavaProject)context.getCompilationUnit().getJavaProject())) {
            return false;
        }
        CatchClause catchClause = (CatchClause)ASTResolving.findAncestor((ASTNode)covering, (int)12);
        if (catchClause == null) {
            return false;
        }
        Statement statement = ASTResolving.findParentStatement((ASTNode)covering);
        if (statement != catchClause.getParent() && statement != catchClause.getBody()) {
            return false;
        }
        Type type1 = catchClause.getException().getType();
        Type selectedMultiCatchType = null;
        if (type1.isUnionType() && covering instanceof Name && ((parent = (topMostName = ASTNodes.getTopMostName((Name)((Name)covering))).getParent()) instanceof SimpleType || parent instanceof NameQualifiedType)) {
            selectedMultiCatchType = (Type)parent;
        }
        if (selectedMultiCatchType != null) {
            return false;
        }
        TryStatement tryStatement = (TryStatement)catchClause.getParent();
        List catchClauses = tryStatement.catchClauses();
        if (catchClauses.size() <= 1) {
            return false;
        }
        String commonSource = null;
        try {
            IBuffer buffer = context.getCompilationUnit().getBuffer();
            for (CatchClause catchClause1 : catchClauses) {
                Block body = catchClause1.getBody();
                String source = buffer.getText(body.getStartPosition(), body.getLength());
                if (commonSource == null) {
                    commonSource = source;
                    continue;
                }
                if (commonSource.equals(source)) continue;
                return false;
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = covering.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        TightSourceRangeComputer sourceRangeComputer = new TightSourceRangeComputer();
        sourceRangeComputer.addTightSourceNode((ASTNode)catchClauses.get(catchClauses.size() - 1));
        rewrite.setTargetSourceRangeComputer((TargetSourceRangeComputer)sourceRangeComputer);
        CatchClause firstCatchClause = (CatchClause)catchClauses.get(0);
        UnionType newUnionType = ast.newUnionType();
        List types = newUnionType.types();
        for (CatchClause catchClause1 : catchClauses) {
            Type type = catchClause1.getException().getType();
            if (type instanceof UnionType) {
                List types2 = ((UnionType)type).types();
                Iterator iterator2 = types2.iterator();
                while (iterator2.hasNext()) {
                    types.add((Type)rewrite.createCopyTarget((ASTNode)iterator2.next()));
                }
                continue;
            }
            types.add((Type)rewrite.createCopyTarget((ASTNode)type));
        }
        SingleVariableDeclaration newExceptionDeclaration = ast.newSingleVariableDeclaration();
        newExceptionDeclaration.setType((Type)newUnionType);
        newExceptionDeclaration.setName((SimpleName)rewrite.createCopyTarget((ASTNode)firstCatchClause.getException().getName()));
        rewrite.replace((ASTNode)firstCatchClause.getException(), (ASTNode)newExceptionDeclaration, null);
        int i = 1;
        while (i < catchClauses.size()) {
            rewrite.remove((ASTNode)catchClauses.get(i), null);
            ++i;
        }
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        String label = CorrectionMessages.QuickAssistProcessor_convert_to_single_multicatch_block;
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 2, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getUnrollMultiCatchProposals(IInvocationContext context, ASTNode covering, Collection<ICommandAccess> resultingCollections) {
        Name topMostName;
        ASTNode parent;
        if (!JavaModelUtil.is17OrHigher((IJavaProject)context.getCompilationUnit().getJavaProject())) {
            return false;
        }
        CatchClause catchClause = (CatchClause)ASTResolving.findAncestor((ASTNode)covering, (int)12);
        if (catchClause == null) {
            return false;
        }
        Statement statement = ASTResolving.findParentStatement((ASTNode)covering);
        if (statement != catchClause.getParent() && statement != catchClause.getBody()) {
            return false;
        }
        Type type1 = catchClause.getException().getType();
        Type selectedMultiCatchType = null;
        if (type1.isUnionType() && covering instanceof Name && ((parent = (topMostName = ASTNodes.getTopMostName((Name)((Name)covering))).getParent()) instanceof SimpleType || parent instanceof NameQualifiedType)) {
            selectedMultiCatchType = (Type)parent;
        }
        if (selectedMultiCatchType != null) {
            return false;
        }
        SingleVariableDeclaration singleVariableDeclaration = catchClause.getException();
        Type type = singleVariableDeclaration.getType();
        if (!(type instanceof UnionType)) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = covering.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        TryStatement tryStatement = (TryStatement)catchClause.getParent();
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)tryStatement, TryStatement.CATCH_CLAUSES_PROPERTY);
        UnionType unionType = (UnionType)type;
        List types = unionType.types();
        int i = types.size() - 1;
        while (i >= 0) {
            Type type2 = (Type)types.get(i);
            CatchClause newCatchClause = ast.newCatchClause();
            SingleVariableDeclaration newSingleVariableDeclaration = ast.newSingleVariableDeclaration();
            newSingleVariableDeclaration.setType((Type)rewrite.createCopyTarget((ASTNode)type2));
            newSingleVariableDeclaration.setName((SimpleName)rewrite.createCopyTarget((ASTNode)singleVariableDeclaration.getName()));
            newCatchClause.setException(newSingleVariableDeclaration);
            QuickAssistProcessor.setCatchClauseBody(newCatchClause, rewrite, catchClause);
            listRewrite.insertAfter((ASTNode)newCatchClause, (ASTNode)catchClause, null);
            --i;
        }
        rewrite.remove((ASTNode)catchClause, null);
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        String label = CorrectionMessages.QuickAssistProcessor_convert_to_multiple_singletype_catch_blocks;
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 2, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static void setCatchClauseBody(CatchClause newCatchClause, ASTRewrite rewrite, CatchClause catchClause) {
        List statements = catchClause.getBody().statements();
        Iterator iterator2 = statements.iterator();
        while (iterator2.hasNext()) {
            newCatchClause.getBody().statements().add(rewrite.createCopyTarget((ASTNode)iterator2.next()));
        }
    }

    private static boolean getRenameLocalProposals(IInvocationContext context, ASTNode node, IProblemLocation[] locations, Collection<ICommandAccess> resultingCollections) {
        if (!(node instanceof SimpleName)) {
            return false;
        }
        SimpleName name = (SimpleName)node;
        IBinding binding = name.resolveBinding();
        if (binding != null && binding.getKind() == 1) {
            return false;
        }
        if (QuickAssistProcessor.containsQuickFixableRenameLocal(locations)) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        LinkedNamesAssistProposal proposal = new LinkedNamesAssistProposal(context, name);
        if (locations.length != 0) {
            proposal.setRelevance(1);
        }
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getRenameRefactoringProposal(IInvocationContext context, ASTNode node, IProblemLocation[] locations, Collection<ICommandAccess> resultingCollections) throws CoreException {
        if (!(context instanceof AssistContext)) {
            return false;
        }
        IEditorPart editor = ((AssistContext)context).getEditor();
        if (!(editor instanceof JavaEditor)) {
            return false;
        }
        if (!(node instanceof SimpleName)) {
            return false;
        }
        SimpleName name = (SimpleName)node;
        IBinding binding = name.resolveBinding();
        if (binding == null) {
            return false;
        }
        IJavaElement javaElement = binding.getJavaElement();
        if (javaElement == null || !RefactoringAvailabilityTester.isRenameElementAvailable(javaElement)) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        RenameRefactoringProposal proposal = new RenameRefactoringProposal((JavaEditor)editor);
        if (locations.length != 0) {
            proposal.setRelevance(1);
        } else if (QuickAssistProcessor.containsQuickFixableRenameLocal(locations)) {
            proposal.setRelevance(7);
        }
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean containsQuickFixableRenameLocal(IProblemLocation[] locations) {
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                IProblemLocation location = locations[i];
                if ("org.eclipse.jdt.core.problem".equals(location.getMarkerType())) {
                    switch (location.getProblemId()) {
                        case 536871002: 
                        case 536871006: 
                        case 536871007: 
                        case 570425435: 
                        case 570425436: 
                        case 570425437: {
                            return true;
                        }
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public static ASTNode getCopyOfInner(ASTRewrite rewrite, ASTNode statement, boolean toControlStatementBody) {
        if (statement.getNodeType() == 8) {
            Block block = (Block)statement;
            List innerStatements = block.statements();
            int nStatements = innerStatements.size();
            if (nStatements == 1) {
                return rewrite.createCopyTarget((ASTNode)innerStatements.get(0));
            }
            if (nStatements > 1) {
                if (toControlStatementBody) {
                    return rewrite.createCopyTarget((ASTNode)block);
                }
                ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
                ASTNode first = (ASTNode)innerStatements.get(0);
                ASTNode last = (ASTNode)innerStatements.get(nStatements - 1);
                return listRewrite.createCopyTarget(first, last);
            }
            return null;
        }
        return rewrite.createCopyTarget(statement);
    }

    private static boolean getUnWrapProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        MethodInvocation invocation;
        ASTNode outer = node;
        Block block = null;
        if (outer.getNodeType() == 8) {
            block = (Block)outer;
            outer = block.getParent();
        }
        Statement body = null;
        String label = null;
        if (outer instanceof IfStatement) {
            IfStatement ifStatement = (IfStatement)outer;
            Statement elseBlock = ifStatement.getElseStatement();
            if (elseBlock == null || elseBlock instanceof Block && ((Block)elseBlock).statements().isEmpty()) {
                body = ifStatement.getThenStatement();
            }
            label = CorrectionMessages.QuickAssistProcessor_unwrap_ifstatement;
        } else if (outer instanceof WhileStatement) {
            body = ((WhileStatement)outer).getBody();
            label = CorrectionMessages.QuickAssistProcessor_unwrap_whilestatement;
        } else if (outer instanceof ForStatement) {
            body = ((ForStatement)outer).getBody();
            label = CorrectionMessages.QuickAssistProcessor_unwrap_forstatement;
        } else if (outer instanceof EnhancedForStatement) {
            body = ((EnhancedForStatement)outer).getBody();
            label = CorrectionMessages.QuickAssistProcessor_unwrap_forstatement;
        } else if (outer instanceof SynchronizedStatement) {
            body = ((SynchronizedStatement)outer).getBody();
            label = CorrectionMessages.QuickAssistProcessor_unwrap_synchronizedstatement;
        } else if (outer instanceof SimpleName && outer.getParent() instanceof LabeledStatement) {
            LabeledStatement labeledStatement = (LabeledStatement)outer.getParent();
            outer = labeledStatement;
            body = labeledStatement.getBody();
            label = CorrectionMessages.QuickAssistProcessor_unwrap_labeledstatement;
        } else if (outer instanceof LabeledStatement) {
            body = ((LabeledStatement)outer).getBody();
            label = CorrectionMessages.QuickAssistProcessor_unwrap_labeledstatement;
        } else if (outer instanceof DoStatement) {
            body = ((DoStatement)outer).getBody();
            label = CorrectionMessages.QuickAssistProcessor_unwrap_dostatement;
        } else if (outer instanceof TryStatement) {
            TryStatement tryStatement = (TryStatement)outer;
            if (tryStatement.catchClauses().isEmpty() && tryStatement.resources().isEmpty()) {
                body = tryStatement.getBody();
            }
            label = CorrectionMessages.QuickAssistProcessor_unwrap_trystatement;
        } else if (outer instanceof AnonymousClassDeclaration) {
            List decls = ((AnonymousClassDeclaration)outer).bodyDeclarations();
            int i = 0;
            while (i < decls.size()) {
                BodyDeclaration elem = (BodyDeclaration)decls.get(i);
                if (elem instanceof MethodDeclaration) {
                    Block curr = ((MethodDeclaration)elem).getBody();
                    if (curr != null && !curr.statements().isEmpty()) {
                        if (body != null) {
                            return false;
                        }
                        body = curr;
                    }
                } else if (elem instanceof TypeDeclaration) {
                    return false;
                }
                ++i;
            }
            label = CorrectionMessages.QuickAssistProcessor_unwrap_anonymous;
            if ((outer = ASTResolving.findParentStatement((ASTNode)outer)) == null) {
                return false;
            }
        } else if (outer instanceof Block) {
            body = block;
            outer = block;
            label = CorrectionMessages.QuickAssistProcessor_unwrap_block;
        } else if (!(outer instanceof ParenthesizedExpression) && outer instanceof MethodInvocation && (invocation = (MethodInvocation)outer).arguments().size() == 1) {
            int kind;
            body = (ASTNode)invocation.arguments().get(0);
            if (invocation.getParent().getNodeType() == 21 && (kind = body.getNodeType()) != 7 && kind != 38 && kind != 37 && kind != 32 && kind != 48) {
                body = null;
            }
            label = CorrectionMessages.QuickAssistProcessor_unwrap_methodinvocation;
        }
        if (body == null) {
            return false;
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)outer.getAST());
        ASTNode inner = QuickAssistProcessor.getCopyOfInner(rewrite, (ASTNode)body, ASTNodes.isControlStatementBody((StructuralPropertyDescriptor)outer.getLocationInParent()));
        if (inner == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        rewrite.replace(outer, inner, null);
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.jexception_obj.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean isControlStatementWithBlock(ASTNode node) {
        switch (node.getNodeType()) {
            case 19: 
            case 24: 
            case 25: 
            case 61: 
            case 70: {
                return true;
            }
        }
        return false;
    }

    private static boolean getRemoveBlockProposals(IInvocationContext context, ASTNode coveringNode, Collection<ICommandAccess> resultingCollections) {
        ControlStatementsFix[] fixes = ControlStatementsFix.createRemoveBlockFix(context.getASTRoot(), coveringNode);
        if (fixes != null) {
            if (resultingCollections == null) {
                return true;
            }
            Hashtable<String, String> options = new Hashtable<String, String>();
            options.put("cleanup.use_blocks", "true");
            options.put("cleanup.never_use_blocks", "true");
            ControlStatementsCleanUp cleanUp = new ControlStatementsCleanUp(options);
            int i = 0;
            while (i < fixes.length) {
                ControlStatementsFix fix = fixes[i];
                Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                FixCorrectionProposal proposal = new FixCorrectionProposal(fix, cleanUp, 2, image, context);
                resultingCollections.add(proposal);
                ++i;
            }
            return true;
        }
        return false;
    }

    private static boolean getAddBlockProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        if (!(node instanceof Statement)) {
            return false;
        }
        if (!QuickAssistProcessor.isControlStatementWithBlock(node) && QuickAssistProcessor.isControlStatementWithBlock(node.getParent())) {
            int statementStart = node.getStartPosition();
            int statementEnd = statementStart + node.getLength();
            int offset = context.getSelectionOffset();
            int length = context.getSelectionLength();
            if (length == 0 ? offset != statementEnd : offset > statementStart || offset + length < statementEnd) {
                return false;
            }
            node = node.getParent();
        }
        ChildPropertyDescriptor childProperty = null;
        Statement child = null;
        switch (node.getNodeType()) {
            case 25: {
                Statement then = ((IfStatement)node).getThenStatement();
                Statement elseStatement = ((IfStatement)node).getElseStatement();
                if (then instanceof Block && (elseStatement instanceof Block || elseStatement == null)) break;
                int thenEnd = then.getStartPosition() + then.getLength();
                int selectionEnd = context.getSelectionOffset() + context.getSelectionLength();
                if (!(then instanceof Block)) {
                    if (selectionEnd <= thenEnd) {
                        childProperty = IfStatement.THEN_STATEMENT_PROPERTY;
                        child = then;
                        break;
                    }
                    if (elseStatement != null && selectionEnd < elseStatement.getStartPosition()) {
                        try {
                            TokenScanner scanner = new TokenScanner((ITypeRoot)context.getCompilationUnit());
                            int elseTokenStart = scanner.getNextStartOffset(thenEnd, true);
                            if (selectionEnd < elseTokenStart) {
                                childProperty = IfStatement.THEN_STATEMENT_PROPERTY;
                                child = then;
                                break;
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                }
                if (elseStatement == null || elseStatement instanceof Block || context.getSelectionOffset() < thenEnd) break;
                childProperty = IfStatement.ELSE_STATEMENT_PROPERTY;
                child = elseStatement;
                break;
            }
            case 61: {
                Statement whileBody = ((WhileStatement)node).getBody();
                if (whileBody instanceof Block) break;
                childProperty = WhileStatement.BODY_PROPERTY;
                child = whileBody;
                break;
            }
            case 24: {
                Statement forBody = ((ForStatement)node).getBody();
                if (forBody instanceof Block) break;
                childProperty = ForStatement.BODY_PROPERTY;
                child = forBody;
                break;
            }
            case 70: {
                Statement enhancedForBody = ((EnhancedForStatement)node).getBody();
                if (enhancedForBody instanceof Block) break;
                childProperty = EnhancedForStatement.BODY_PROPERTY;
                child = enhancedForBody;
                break;
            }
            case 19: {
                Statement doBody = ((DoStatement)node).getBody();
                if (doBody instanceof Block) break;
                childProperty = DoStatement.BODY_PROPERTY;
                child = doBody;
            }
        }
        if (child == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = node.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ASTNode childPlaceholder = rewrite.createMoveTarget((ASTNode)child);
        Block replacingBody = ast.newBlock();
        replacingBody.statements().add(childPlaceholder);
        rewrite.set(node, (StructuralPropertyDescriptor)childProperty, (Object)replacingBody, null);
        String label = childProperty == IfStatement.THEN_STATEMENT_PROPERTY ? CorrectionMessages.QuickAssistProcessor_replacethenwithblock_description : (childProperty == IfStatement.ELSE_STATEMENT_PROPERTY ? CorrectionMessages.QuickAssistProcessor_replaceelsewithblock_description : CorrectionMessages.QuickAssistProcessor_replacebodywithblock_description);
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, context.getCompilationUnit(), rewrite, 5, image);
        proposal.setCommandId(ADD_BLOCK_ID);
        proposal.setEndPosition(rewrite.track((ASTNode)child));
        resultingCollections.add(proposal);
        if (node.getNodeType() == 25) {
            IfStatement ifStatement;
            Statement elseStatment;
            rewrite = ASTRewrite.create((AST)ast);
            while (node.getLocationInParent() == IfStatement.ELSE_STATEMENT_PROPERTY) {
                node = node.getParent();
            }
            boolean missingBlockFound = false;
            boolean foundElse = false;
            do {
                ifStatement = (IfStatement)node;
                Statement thenStatment = ifStatement.getThenStatement();
                elseStatment = ifStatement.getElseStatement();
                if (!(thenStatment instanceof Block)) {
                    ASTNode childPlaceholder1 = rewrite.createMoveTarget((ASTNode)thenStatment);
                    Block replacingBody1 = ast.newBlock();
                    replacingBody1.statements().add(childPlaceholder1);
                    rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.THEN_STATEMENT_PROPERTY, (Object)replacingBody1, null);
                    if (thenStatment != child) {
                        missingBlockFound = true;
                    }
                }
                if (elseStatment != null) {
                    foundElse = true;
                }
                node = elseStatment;
            } while (elseStatment instanceof IfStatement);
            if (elseStatment != null && !(elseStatment instanceof Block)) {
                ASTNode childPlaceholder2 = rewrite.createMoveTarget((ASTNode)elseStatment);
                Block replacingBody2 = ast.newBlock();
                replacingBody2.statements().add(childPlaceholder2);
                rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.ELSE_STATEMENT_PROPERTY, (Object)replacingBody2, null);
                if (elseStatment != child) {
                    missingBlockFound = true;
                }
            }
            if (missingBlockFound && foundElse) {
                String label2 = CorrectionMessages.QuickAssistProcessor_replacethenelsewithblock_description;
                Image image2 = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                ASTRewriteCorrectionProposal proposal2 = new ASTRewriteCorrectionProposal(label2, context.getCompilationUnit(), rewrite, 6, image2);
                resultingCollections.add(proposal2);
            }
        }
        return true;
    }

    private static boolean getInvertEqualsProposal(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        MethodInvocation replacement;
        if (!(node instanceof MethodInvocation) && !((node = node.getParent()) instanceof MethodInvocation)) {
            return false;
        }
        MethodInvocation method = (MethodInvocation)node;
        String identifier = method.getName().getIdentifier();
        if (!"equals".equals(identifier) && !"equalsIgnoreCase".equals(identifier)) {
            return false;
        }
        List arguments = method.arguments();
        if (arguments.size() != 1) {
            return false;
        }
        Expression right = (Expression)arguments.get(0);
        ITypeBinding binding = right.resolveTypeBinding();
        if (!(binding == null || binding.isClass() || binding.isInterface() || binding.isEnum())) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        Expression left = method.getExpression();
        AST ast = method.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        if (left == null) {
            replacement = ast.newMethodInvocation();
            replacement.setName((SimpleName)rewrite.createCopyTarget((ASTNode)method.getName()));
            replacement.arguments().add(ast.newThisExpression());
            replacement.setExpression((Expression)rewrite.createCopyTarget((ASTNode)right));
            rewrite.replace((ASTNode)method, (ASTNode)replacement, null);
        } else if (right instanceof ThisExpression) {
            replacement = ast.newMethodInvocation();
            replacement.setName((SimpleName)rewrite.createCopyTarget((ASTNode)method.getName()));
            replacement.arguments().add(rewrite.createCopyTarget((ASTNode)left));
            rewrite.replace((ASTNode)method, (ASTNode)replacement, null);
        } else {
            Expression leftExpression = left;
            while (leftExpression instanceof ParenthesizedExpression) {
                leftExpression = ((ParenthesizedExpression)left).getExpression();
            }
            rewrite.replace((ASTNode)right, rewrite.createCopyTarget((ASTNode)leftExpression), null);
            if (right instanceof CastExpression || right instanceof Assignment || right instanceof ConditionalExpression || right instanceof InfixExpression) {
                ParenthesizedExpression paren = ast.newParenthesizedExpression();
                paren.setExpression((Expression)rewrite.createCopyTarget((ASTNode)right));
                rewrite.replace((ASTNode)left, (ASTNode)paren, null);
            } else {
                rewrite.replace((ASTNode)left, rewrite.createCopyTarget((ASTNode)right), null);
            }
        }
        String label = CorrectionMessages.QuickAssistProcessor_invertequals_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getArrayInitializerToArrayCreation(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        if (!(node instanceof ArrayInitializer)) {
            return false;
        }
        ArrayInitializer initializer = (ArrayInitializer)node;
        ASTNode parent = initializer.getParent();
        while (parent instanceof ArrayInitializer) {
            initializer = (ArrayInitializer)parent;
            parent = parent.getParent();
        }
        ITypeBinding typeBinding = initializer.resolveTypeBinding();
        if (!(parent instanceof VariableDeclaration) || typeBinding == null || !typeBinding.isArray()) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = node.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        String label = CorrectionMessages.QuickAssistProcessor_typetoarrayInitializer_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        ImportRewrite imports = proposal.createImportRewrite(context.getASTRoot());
        ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext(node, imports);
        String typeName = imports.addImport(typeBinding, (ImportRewrite.ImportRewriteContext)importRewriteContext);
        ArrayCreation creation = ast.newArrayCreation();
        creation.setInitializer((ArrayInitializer)rewrite.createMoveTarget((ASTNode)initializer));
        creation.setType((ArrayType)ASTNodeFactory.newType(ast, typeName));
        rewrite.replace((ASTNode)initializer, (ASTNode)creation, null);
        resultingCollections.add(proposal);
        return true;
    }

    public static boolean getCreateInSuperClassProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) throws CoreException {
        if (!(node instanceof SimpleName) || !(node.getParent() instanceof MethodDeclaration)) {
            return false;
        }
        MethodDeclaration decl = (MethodDeclaration)node.getParent();
        if (decl.getName() != node || decl.resolveBinding() == null || Modifier.isPrivate((int)decl.getModifiers())) {
            return false;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        IMethodBinding binding = decl.resolveBinding();
        ITypeBinding[] paramTypes = binding.getParameterTypes();
        ITypeBinding[] superTypes = Bindings.getAllSuperTypes((ITypeBinding)binding.getDeclaringClass());
        if (resultingCollections == null) {
            int i = 0;
            while (i < superTypes.length) {
                ITypeBinding curr = superTypes[i];
                if (curr.isFromSource() && Bindings.findOverriddenMethodInType((ITypeBinding)curr, (IMethodBinding)binding) == null) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        List params = decl.parameters();
        String[] paramNames = new String[paramTypes.length];
        int i = 0;
        while (i < params.size()) {
            SingleVariableDeclaration param = (SingleVariableDeclaration)params.get(i);
            paramNames[i] = param.getName().getIdentifier();
            ++i;
        }
        i = 0;
        while (i < superTypes.length) {
            ITypeBinding typeDecl;
            ICompilationUnit targetCU;
            IMethodBinding method;
            ITypeBinding curr = superTypes[i];
            if (curr.isFromSource() && (method = Bindings.findOverriddenMethodInType((ITypeBinding)curr, (IMethodBinding)binding)) == null && (targetCU = ASTResolving.findCompilationUnitForBinding((ICompilationUnit)cu, (CompilationUnit)astRoot, (ITypeBinding)(typeDecl = curr.getTypeDeclaration()))) != null) {
                String label = Messages.format(CorrectionMessages.QuickAssistProcessor_createmethodinsuper_description, new String[]{BasicElementLabels.getJavaElementName((String)curr.getName()), BasicElementLabels.getJavaElementName((String)binding.getName())});
                resultingCollections.add(new NewDefiningMethodProposal(label, targetCU, (ASTNode)astRoot, typeDecl, binding, paramNames, 6));
            }
            ++i;
        }
        return true;
    }

    private static boolean getConvertEnhancedForLoopProposal(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        InfixExpression condition;
        Image image;
        String label;
        EnhancedForStatement enhancedForStatement = QuickAssistProcessor.getEnclosingHeader(node, EnhancedForStatement.class, new StructuralPropertyDescriptor[]{EnhancedForStatement.PARAMETER_PROPERTY, EnhancedForStatement.EXPRESSION_PROPERTY});
        if (enhancedForStatement == null) {
            return false;
        }
        SingleVariableDeclaration parameter = enhancedForStatement.getParameter();
        IVariableBinding parameterBinding = parameter.resolveBinding();
        if (parameterBinding == null) {
            return false;
        }
        Expression initializer = enhancedForStatement.getExpression();
        ITypeBinding initializerTypeBinding = initializer.resolveTypeBinding();
        if (initializerTypeBinding == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        EnhancedForStatement topLabelStatement = enhancedForStatement;
        while (topLabelStatement.getLocationInParent() == LabeledStatement.BODY_PROPERTY) {
            topLabelStatement = (Statement)topLabelStatement.getParent();
        }
        IJavaProject project = context.getCompilationUnit().getJavaProject();
        AST ast = node.getAST();
        Statement enhancedForBody = enhancedForStatement.getBody();
        List<String> usedVarNames = Arrays.asList(ASTResolving.getUsedVariableNames((ASTNode)enhancedForBody));
        boolean initializerIsArray = initializerTypeBinding.isArray();
        ITypeBinding initializerListType = Bindings.findTypeInHierarchy((ITypeBinding)initializerTypeBinding, (String)"java.util.List");
        ITypeBinding initializerIterableType = Bindings.findTypeInHierarchy((ITypeBinding)initializerTypeBinding, (String)"java.lang.Iterable");
        if (initializerIterableType != null) {
            label = CorrectionMessages.QuickAssistProcessor_convert_to_iterator_for_loop;
            image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            String iterNameKey = "iterName";
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
            ForStatement forStatement = ast.newForStatement();
            MethodInvocation iterInitializer = ast.newMethodInvocation();
            iterInitializer.setName(ast.newSimpleName("iterator"));
            ImportRewrite imports = proposal.createImportRewrite(context.getASTRoot());
            ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext(node, imports);
            SimpleType iterType = ast.newSimpleType(ast.newName(imports.addImport("java.util.Iterator", (ImportRewrite.ImportRewriteContext)importRewriteContext)));
            if (initializerIterableType.getTypeArguments().length == 1) {
                Type iterTypeArgument = imports.addImport(Bindings.normalizeTypeBinding((ITypeBinding)initializerIterableType.getTypeArguments()[0]), ast, (ImportRewrite.ImportRewriteContext)importRewriteContext, ImportRewrite.TypeLocation.TYPE_ARGUMENT);
                ParameterizedType parameterizedIterType = ast.newParameterizedType((Type)iterType);
                parameterizedIterType.typeArguments().add(iterTypeArgument);
                iterType = parameterizedIterType;
            }
            String[] iterNames = StubUtility.getVariableNameSuggestions(5, project, (Type)iterType, (Expression)iterInitializer, usedVarNames);
            String iterName = iterNames[0];
            SimpleName initializerIterName = ast.newSimpleName(iterName);
            VariableDeclarationFragment iterFragment = ast.newVariableDeclarationFragment();
            iterFragment.setName(initializerIterName);
            proposal.addLinkedPosition(rewrite.track((ASTNode)initializerIterName), 0, iterNameKey);
            int i = 0;
            while (i < iterNames.length) {
                proposal.addLinkedPositionProposal(iterNameKey, iterNames[i], null);
                ++i;
            }
            Expression initializerExpression = (Expression)rewrite.createCopyTarget((ASTNode)initializer);
            iterInitializer.setExpression(initializerExpression);
            iterFragment.setInitializer((Expression)iterInitializer);
            VariableDeclarationExpression iterVariable = ast.newVariableDeclarationExpression(iterFragment);
            iterVariable.setType((Type)iterType);
            forStatement.initializers().add(iterVariable);
            condition = ast.newMethodInvocation();
            condition.setName(ast.newSimpleName("hasNext"));
            SimpleName conditionExpression = ast.newSimpleName(iterName);
            proposal.addLinkedPosition(rewrite.track((ASTNode)conditionExpression), -1, iterNameKey);
            condition.setExpression((Expression)conditionExpression);
            forStatement.setExpression((Expression)condition);
            VariableDeclarationFragment elementFragment = ast.newVariableDeclarationFragment();
            elementFragment.extraDimensions().addAll(DimensionRewrite.copyDimensions(parameter.extraDimensions(), rewrite));
            elementFragment.setName((SimpleName)rewrite.createCopyTarget((ASTNode)parameter.getName()));
            SimpleName elementIterName = ast.newSimpleName(iterName);
            proposal.addLinkedPosition(rewrite.track((ASTNode)elementIterName), -1, iterNameKey);
            MethodInvocation getMethodInvocation = ast.newMethodInvocation();
            getMethodInvocation.setName(ast.newSimpleName("next"));
            getMethodInvocation.setExpression((Expression)elementIterName);
            elementFragment.setInitializer((Expression)getMethodInvocation);
            VariableDeclarationStatement elementVariable = ast.newVariableDeclarationStatement(elementFragment);
            ModifierRewrite.create(rewrite, (ASTNode)elementVariable).copyAllModifiers((ASTNode)parameter, null);
            elementVariable.setType((Type)rewrite.createCopyTarget((ASTNode)parameter.getType()));
            Block newBody = ast.newBlock();
            List statements = newBody.statements();
            statements.add(elementVariable);
            if (enhancedForBody instanceof Block) {
                List oldStatements = ((Block)enhancedForBody).statements();
                if (oldStatements.size() > 0) {
                    ListRewrite statementsRewrite = rewrite.getListRewrite((ASTNode)enhancedForBody, Block.STATEMENTS_PROPERTY);
                    Statement oldStatementsCopy = (Statement)statementsRewrite.createCopyTarget((ASTNode)oldStatements.get(0), (ASTNode)oldStatements.get(oldStatements.size() - 1));
                    statements.add(oldStatementsCopy);
                }
            } else {
                statements.add((Statement)rewrite.createCopyTarget((ASTNode)enhancedForBody));
            }
            forStatement.setBody((Statement)newBody);
            rewrite.replace((ASTNode)enhancedForStatement, (ASTNode)forStatement, null);
            resultingCollections.add(proposal);
        }
        if (initializerIsArray || initializerListType != null) {
            ArrayAccess elementAccess;
            QualifiedName conditionRight;
            boolean varNameGenerated;
            String varName;
            label = CorrectionMessages.QuickAssistProcessor_convert_to_indexed_for_loop;
            image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            String varNameKey = "varName";
            String indexNameKey = "indexName";
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, context.getCompilationUnit(), rewrite, 2, image);
            if (initializer instanceof SimpleName) {
                varName = ((SimpleName)initializer).getIdentifier();
                varNameGenerated = false;
            } else {
                ArrayType varType;
                VariableDeclarationFragment varFragment = ast.newVariableDeclarationFragment();
                String[] varNames = StubUtility.getVariableNameSuggestions(5, project, initializerTypeBinding, initializer, usedVarNames);
                varName = varNames[0];
                usedVarNames = new ArrayList<String>(usedVarNames);
                usedVarNames.add(varName);
                varNameGenerated = true;
                SimpleName varNameNode = ast.newSimpleName(varName);
                varFragment.setName(varNameNode);
                proposal.addLinkedPosition(rewrite.track((ASTNode)varNameNode), 0, varNameKey);
                int i = 0;
                while (i < varNames.length) {
                    proposal.addLinkedPositionProposal(varNameKey, varNames[i], null);
                    ++i;
                }
                varFragment.setInitializer((Expression)rewrite.createCopyTarget((ASTNode)initializer));
                VariableDeclarationStatement varDeclaration = ast.newVariableDeclarationStatement(varFragment);
                if (initializerIsArray) {
                    Type copiedType = DimensionRewrite.copyTypeAndAddDimensions(parameter.getType(), parameter.extraDimensions(), rewrite);
                    varType = ASTNodeFactory.newArrayType(copiedType);
                } else {
                    ImportRewrite imports = proposal.createImportRewrite(context.getASTRoot());
                    ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext(node, imports);
                    varType = imports.addImport(Bindings.normalizeForDeclarationUse((ITypeBinding)initializerTypeBinding, (AST)ast), ast, (ImportRewrite.ImportRewriteContext)importRewriteContext, ImportRewrite.TypeLocation.TYPE_ARGUMENT);
                }
                varDeclaration.setType((Type)varType);
                if (!(topLabelStatement.getParent() instanceof Block)) {
                    Block block = ast.newBlock();
                    List statements = block.statements();
                    statements.add(varDeclaration);
                    statements.add((Statement)rewrite.createCopyTarget((ASTNode)topLabelStatement));
                    rewrite.replace((ASTNode)topLabelStatement, (ASTNode)block, null);
                } else {
                    rewrite.getListRewrite(topLabelStatement.getParent(), Block.STATEMENTS_PROPERTY).insertBefore((ASTNode)varDeclaration, (ASTNode)topLabelStatement, null);
                }
            }
            ForStatement forStatement = ast.newForStatement();
            VariableDeclarationFragment indexFragment = ast.newVariableDeclarationFragment();
            NumberLiteral indexInitializer = ast.newNumberLiteral();
            indexFragment.setInitializer((Expression)indexInitializer);
            PrimitiveType indexType = ast.newPrimitiveType(PrimitiveType.INT);
            String[] indexNames = StubUtility.getVariableNameSuggestions(5, project, (Type)indexType, (Expression)indexInitializer, usedVarNames);
            String indexName = indexNames[0];
            SimpleName initializerIndexName = ast.newSimpleName(indexName);
            indexFragment.setName(initializerIndexName);
            proposal.addLinkedPosition(rewrite.track((ASTNode)initializerIndexName), 0, indexNameKey);
            int i = 0;
            while (i < indexNames.length) {
                proposal.addLinkedPositionProposal(indexNameKey, indexNames[i], null);
                ++i;
            }
            VariableDeclarationExpression indexVariable = ast.newVariableDeclarationExpression(indexFragment);
            indexVariable.setType((Type)indexType);
            forStatement.initializers().add(indexVariable);
            condition = ast.newInfixExpression();
            condition.setOperator(InfixExpression.Operator.LESS);
            SimpleName conditionLeft = ast.newSimpleName(indexName);
            proposal.addLinkedPosition(rewrite.track((ASTNode)conditionLeft), -1, indexNameKey);
            condition.setLeftOperand((Expression)conditionLeft);
            SimpleName conditionRightName = ast.newSimpleName(varName);
            if (varNameGenerated) {
                proposal.addLinkedPosition(rewrite.track((ASTNode)conditionRightName), -1, varNameKey);
            }
            if (initializerIsArray) {
                conditionRight = ast.newQualifiedName((Name)conditionRightName, ast.newSimpleName("length"));
            } else {
                MethodInvocation sizeMethodInvocation = ast.newMethodInvocation();
                sizeMethodInvocation.setName(ast.newSimpleName("size"));
                sizeMethodInvocation.setExpression((Expression)conditionRightName);
                conditionRight = sizeMethodInvocation;
            }
            condition.setRightOperand((Expression)conditionRight);
            forStatement.setExpression((Expression)condition);
            SimpleName indexUpdaterName = ast.newSimpleName(indexName);
            proposal.addLinkedPosition(rewrite.track((ASTNode)indexUpdaterName), -1, indexNameKey);
            PostfixExpression indexUpdater = ast.newPostfixExpression();
            indexUpdater.setOperator(PostfixExpression.Operator.INCREMENT);
            indexUpdater.setOperand((Expression)indexUpdaterName);
            forStatement.updaters().add(indexUpdater);
            VariableDeclarationFragment elementFragment = ast.newVariableDeclarationFragment();
            elementFragment.extraDimensions().addAll(DimensionRewrite.copyDimensions(parameter.extraDimensions(), rewrite));
            elementFragment.setName((SimpleName)rewrite.createCopyTarget((ASTNode)parameter.getName()));
            SimpleName elementVarName = ast.newSimpleName(varName);
            if (varNameGenerated) {
                proposal.addLinkedPosition(rewrite.track((ASTNode)elementVarName), -1, varNameKey);
            }
            SimpleName elementIndexName = ast.newSimpleName(indexName);
            proposal.addLinkedPosition(rewrite.track((ASTNode)elementIndexName), -1, indexNameKey);
            if (initializerIsArray) {
                ArrayAccess elementArrayAccess = ast.newArrayAccess();
                elementArrayAccess.setArray((Expression)elementVarName);
                elementArrayAccess.setIndex((Expression)elementIndexName);
                elementAccess = elementArrayAccess;
            } else {
                MethodInvocation getMethodInvocation = ast.newMethodInvocation();
                getMethodInvocation.setName(ast.newSimpleName("get"));
                getMethodInvocation.setExpression((Expression)elementVarName);
                getMethodInvocation.arguments().add(elementIndexName);
                elementAccess = getMethodInvocation;
            }
            elementFragment.setInitializer((Expression)elementAccess);
            VariableDeclarationStatement elementVariable = ast.newVariableDeclarationStatement(elementFragment);
            ModifierRewrite.create(rewrite, (ASTNode)elementVariable).copyAllModifiers((ASTNode)parameter, null);
            elementVariable.setType((Type)rewrite.createCopyTarget((ASTNode)parameter.getType()));
            Block newBody = ast.newBlock();
            List statements = newBody.statements();
            statements.add(elementVariable);
            if (enhancedForBody instanceof Block) {
                List oldStatements = ((Block)enhancedForBody).statements();
                if (oldStatements.size() > 0) {
                    ListRewrite statementsRewrite = rewrite.getListRewrite((ASTNode)enhancedForBody, Block.STATEMENTS_PROPERTY);
                    Statement oldStatementsCopy = (Statement)statementsRewrite.createCopyTarget((ASTNode)oldStatements.get(0), (ASTNode)oldStatements.get(oldStatements.size() - 1));
                    statements.add(oldStatementsCopy);
                }
            } else {
                statements.add((Statement)rewrite.createCopyTarget((ASTNode)enhancedForBody));
            }
            forStatement.setBody((Statement)newBody);
            rewrite.replace((ASTNode)enhancedForStatement, (ASTNode)forStatement, null);
            resultingCollections.add(proposal);
        }
        return true;
    }

    private static boolean getConvertForLoopProposal(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        ForStatement forStatement = QuickAssistProcessor.getEnclosingForStatementHeader(node);
        if (forStatement == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        ConvertLoopFix fix = ConvertLoopFix.createConvertForLoopToEnhancedFix(context.getASTRoot(), forStatement);
        if (fix == null) {
            return false;
        }
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("cleanup.convert_to_enhanced_for_loop", "true");
        ConvertLoopCleanUp cleanUp = new ConvertLoopCleanUp(options);
        FixCorrectionProposal proposal = new FixCorrectionProposal(fix, cleanUp, 1, image, context);
        proposal.setCommandId(CONVERT_FOR_LOOP_ID);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getConvertIterableLoopProposal(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        ForStatement forStatement = QuickAssistProcessor.getEnclosingForStatementHeader(node);
        if (forStatement == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        ConvertLoopFix fix = ConvertLoopFix.createConvertIterableLoopToEnhancedFix(context.getASTRoot(), forStatement);
        if (fix == null) {
            return false;
        }
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("cleanup.convert_to_enhanced_for_loop", "true");
        ConvertLoopCleanUp cleanUp = new ConvertLoopCleanUp(options);
        FixCorrectionProposal proposal = new FixCorrectionProposal(fix, cleanUp, 1, image, context);
        proposal.setCommandId(CONVERT_FOR_LOOP_ID);
        resultingCollections.add(proposal);
        return true;
    }

    public static boolean getGenerateForLoopProposals(IInvocationContext context, ASTNode coveringNode, IProblemLocation[] locations, Collection<ICommandAccess> resultingCollections) {
        Statement statement = ASTResolving.findParentStatement((ASTNode)coveringNode);
        if (!(statement instanceof ExpressionStatement)) {
            return false;
        }
        ExpressionStatement expressionStatement = (ExpressionStatement)statement;
        Expression expression = expressionStatement.getExpression();
        ITypeBinding expressionType = null;
        if (!(expression instanceof MethodInvocation || expression instanceof SimpleName || expression instanceof FieldAccess)) {
            return false;
        }
        expressionType = expression.resolveTypeBinding();
        if (expressionType == null) {
            return false;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        if (Bindings.findTypeInHierarchy((ITypeBinding)expressionType, (String)"java.lang.Iterable") != null) {
            if (resultingCollections == null) {
                return true;
            }
            resultingCollections.add(new GenerateForLoopAssistProposal(cu, expressionStatement, 1));
            if (Bindings.findTypeInHierarchy((ITypeBinding)expressionType, (String)"java.util.List") != null) {
                resultingCollections.add(new GenerateForLoopAssistProposal(cu, expressionStatement, 3));
            }
        } else if (expressionType.isArray()) {
            if (resultingCollections == null) {
                return true;
            }
            resultingCollections.add(new GenerateForLoopAssistProposal(cu, expressionStatement, 2));
        } else {
            return false;
        }
        if (JavaModelUtil.is50OrHigher((IJavaProject)cu.getJavaProject())) {
            resultingCollections.add(new GenerateForLoopAssistProposal(cu, expressionStatement, 0));
        }
        return true;
    }

    private static ForStatement getEnclosingForStatementHeader(ASTNode node) {
        return QuickAssistProcessor.getEnclosingHeader(node, ForStatement.class, new StructuralPropertyDescriptor[]{ForStatement.INITIALIZERS_PROPERTY, ForStatement.EXPRESSION_PROPERTY, ForStatement.UPDATERS_PROPERTY});
    }

    /*
     * Unable to fully structure code
     */
    private static <T extends ASTNode> T getEnclosingHeader(ASTNode node, Class<T> headerType, StructuralPropertyDescriptor ... headerProperties) {
        if (!headerType.isInstance(node)) ** GOTO lbl17
        return (T)((ASTNode)headerType.cast(node));
lbl-1000:
        // 1 sources

        {
            parent = node.getParent();
            if (headerType.isInstance(parent)) {
                locationInParent = node.getLocationInParent();
                var8_5 = headerProperties;
                var7_6 = headerProperties.length;
                var6_7 = 0;
                while (var6_7 < var7_6) {
                    property = var8_5[var6_7];
                    if (locationInParent == property) {
                        return (T)((ASTNode)headerType.cast(parent));
                    }
                    ++var6_7;
                }
                return null;
            }
            node = parent;
lbl17:
            // 2 sources

            ** while (node != null)
        }
lbl18:
        // 1 sources

        return null;
    }

    private static boolean getMakeVariableDeclarationFinalProposals(IInvocationContext context, Collection<ICommandAccess> resultingCollections) {
        SelectionAnalyzer analyzer = new SelectionAnalyzer(Selection.createFromStartLength(context.getSelectionOffset(), context.getSelectionLength()), false);
        context.getASTRoot().accept((ASTVisitor)analyzer);
        ASTNode[] selectedNodes = analyzer.getSelectedNodes();
        if (selectedNodes.length == 0) {
            return false;
        }
        VariableDeclarationFix fix = VariableDeclarationFix.createChangeModifierToFinalFix(context.getASTRoot(), selectedNodes);
        if (fix == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("cleanup.make_variable_declarations_final", "true");
        options.put("cleanup.make_local_variable_final", "true");
        options.put("cleanup.make_parameters_final", "true");
        options.put("cleanup.make_private_fields_final", "true");
        VariableDeclarationCleanUp cleanUp = new VariableDeclarationCleanUp(options);
        FixCorrectionProposal proposal = new FixCorrectionProposal(fix, cleanUp, -1, image, context);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getInlineLocalProposal(IInvocationContext context, ASTNode node, Collection<ICommandAccess> proposals) throws CoreException {
        if (!(node instanceof SimpleName)) {
            return false;
        }
        SimpleName name = (SimpleName)node;
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof IVariableBinding)) {
            return false;
        }
        IVariableBinding varBinding = (IVariableBinding)binding;
        if (varBinding.isField() || varBinding.isParameter()) {
            return false;
        }
        ASTNode decl = context.getASTRoot().findDeclaringNode((IBinding)varBinding);
        if (!(decl instanceof VariableDeclarationFragment) || decl.getLocationInParent() != VariableDeclarationStatement.FRAGMENTS_PROPERTY) {
            return false;
        }
        if (proposals == null) {
            return true;
        }
        InlineTempRefactoring refactoring = new InlineTempRefactoring((VariableDeclaration)decl);
        if (refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            String label = CorrectionMessages.QuickAssistProcessor_inline_local_description;
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, context.getCompilationUnit(), refactoring, 5, image);
            proposal.setCommandId(INLINE_LOCAL_ID);
            proposals.add(proposal);
        }
        return true;
    }

    private static boolean getMissingCaseStatementProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> proposals) {
        if (node instanceof SwitchCase) {
            node = node.getParent();
        }
        if (!(node instanceof SwitchStatement)) {
            return false;
        }
        SwitchStatement switchStatement = (SwitchStatement)node;
        ITypeBinding expressionBinding = switchStatement.getExpression().resolveTypeBinding();
        if (expressionBinding == null || !expressionBinding.isEnum()) {
            return false;
        }
        ArrayList<String> missingEnumCases = new ArrayList<String>();
        boolean hasDefault = LocalCorrectionsSubProcessor.evaluateMissingSwitchCases(expressionBinding, switchStatement.statements(), missingEnumCases);
        if (missingEnumCases.size() == 0 && hasDefault) {
            return false;
        }
        if (proposals == null) {
            return true;
        }
        LocalCorrectionsSubProcessor.createMissingCaseProposals(context, switchStatement, missingEnumCases, proposals);
        return true;
    }

    private static boolean getConvertLocalToFieldProposal(IInvocationContext context, ASTNode node, Collection<ICommandAccess> proposals) throws CoreException {
        if (!(node instanceof SimpleName)) {
            return false;
        }
        SimpleName name = (SimpleName)node;
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof IVariableBinding)) {
            return false;
        }
        IVariableBinding varBinding = (IVariableBinding)binding;
        if (varBinding.isField() || varBinding.isParameter()) {
            return false;
        }
        ASTNode decl = context.getASTRoot().findDeclaringNode((IBinding)varBinding);
        if (decl == null || decl.getLocationInParent() != VariableDeclarationStatement.FRAGMENTS_PROPERTY) {
            return false;
        }
        if (proposals == null) {
            return true;
        }
        PromoteTempToFieldRefactoring refactoring = new PromoteTempToFieldRefactoring((VariableDeclaration)decl);
        if (refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            String label = CorrectionMessages.QuickAssistProcessor_convert_local_to_field_description;
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            LinkedProposalModel linkedProposalModel = new LinkedProposalModel();
            refactoring.setLinkedProposalModel(linkedProposalModel);
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, context.getCompilationUnit(), refactoring, 5, image);
            proposal.setLinkedProposalModel(linkedProposalModel);
            proposal.setCommandId(CONVERT_LOCAL_TO_FIELD_ID);
            proposals.add(proposal);
        }
        return true;
    }
}

